class BreakoutBall extends BreakoutObject;

#exec TEXTURE IMPORT NAME=BreakoutBall FILE=Textures\BreakoutBall.pcx GROUP=UI MIPS=OFF FLAGS=2 LODSET=2

var float 	speedInit,
		speedBoost;

var bool	bSlow,
		bFast,
		bKiller,
		bSuperKiller;

var float	TimeLeftSlow,
		TimeLeftFast,
		TimeLeftKiller,
		TimeLeftSuperKiller;

function Collide(BreakoutObject other)
{
	local BreakoutWall wall;
//	local bool bChangedDirection;

	if(other.IsA('BreakoutWall') || other.IsA('BreakoutPaddle'))
		board.PlaySound(Sound'BreakoutBallHit', 1.0);

//	if(other.IsA('BreakoutWall') || other.IsA('BreakoutBlock')/* || other.IsA('BreakoutPaddle')*/)
//		VS+=speedBoost;

	if(other.IsA('BreakoutWall'))
	{
		wall=BreakoutWall(other);

		if(wall.wallType=="BOTTOM")
		{
			board.BallFell();
			Kill();
			return;
		}

		if(wall.wallType=="TOP")
			VY=-VY;
		else
			VX=-VX;
	}
}

function Dock()
{
	VX=0;
	VY=0;
	bCollidable=false;
}

function Launch()
{
	bCollidable=true;
	VS=Default.SpeedInit;
}

function DrawOverride(GC gc, int dX, int dY, int dW, int dH, int oX, int oY, int oU, int oV, Texture tex)
{
	gc.DrawStretchedTexture(dX,dY,dW,dH,oX+2,oY+2,oU-3,oV-3,tex);
}

function PowerUp(string power)
{
	local BreakoutBall b;

	switch(power)
	{
	case "SPLIT":
		b=new (None) Class'BreakoutBall';
		b.X=X;
		b.Y=Y;
		b.VS=speedInit;
		b.VX=FRand();
		if(FRand()<0.5)
			b.VX=-b.VX;
		b.VY=sqrt(1-b.VX*b.VX);
		if(FRand()<0.5)
			b.VY=-b.VY;
		board.AddElement(b);

		b=new (None) Class'BreakoutBall';
		b.X=X;
		b.Y=Y;
		b.VS=speedInit;
		b.VX=FRand();
		if(FRand()<0.5)
			b.VX=-b.VX;
		b.VY=sqrt(1-b.VX*b.VX);
		if(FRand()<0.5)
			b.VY=-b.VY;
		board.AddElement(b);

		board.ballCount+=2;
		break;
	case "FAST":
		if(bSlow)
		{
			bSlow=false;
			VS=speedInit;
		}
		else
		{
			bFast=true;
			TimeLeftFast=10.0;
			VS*=1.5;
		}
		break;
	case "SLOW":
		if(bFast)
		{
			bFast=false;
			VS=speedInit;
		}
		else
		{
			bSlow=true;
			TimeLeftSlow=30.0;
			VS/=1.5;
		}
		break;
	case "KILLER":
		if(bSuperKiller)
			bSuperKiller=false;
		bKiller=true;
		TimeLeftKiller=10.0;
		drawColor.R=255;
		drawColor.G=0;
		drawColor.B=0;
		break;
	case "SUPERKILLER":
		if(bKiller)
			bKiller=false;
		bSuperKiller=true;
		TimeLeftSuperKiller=6.0;
		drawColor.R=255;
		drawColor.G=0;
		drawColor.B=0;
		break;
	}
}

function PostUpdate(float deltaTime)
{
	deltaTime/=100;

	if(bFast)
	{
		TimeLeftFast-=deltaTime;
		if(TimeLeftFast<=0)
		{
			bFast=false;
			VS=speedInit;
		}
	}

	if(bSlow)
	{
		TimeLeftSlow-=deltaTime;
		if(TimeLeftSlow<=0)
		{
			bSlow=false;
			VS=speedInit;
		}
	}

	if(bKiller)
	{
		TimeLeftKiller-=deltaTime;
		if(TimeLeftKiller<=0)
		{
			bKiller=false;
			drawColor.R=255;
			drawColor.G=255;
			drawColor.B=255;
		}
	}

	if(bSuperKiller)
	{
		TimeLeftSuperKiller-=deltaTime;
		if(TimeLeftSuperKiller<=0)
		{
			bSuperKiller=false;
			drawColor.R=255;
			drawColor.G=255;
			drawColor.B=255;
		}
	}
}

function float GetScoreMultiplier()
{
	local float base;
	base=1.0;
	if(bFast)
		base*=2.0;
	if(bSlow)
		base*=0.75;
	if(bKiller)
		base*=0.5;
	if(bSuperKiller)
		base*=0.25;
	if(board.ballCount>1)
		base*=0.75;
	return base;
}

defaultproperties
{
     speedInit=2.500000
     speedBoost=0.050000
     bStatic=False
     bMoving=True
     bCollidable=True
     DrawTexture=Texture'TNMGUI.UI.BreakoutBall'
     drawStyle=DSTY_Masked
     bOverrideTextureDraw=True
     W=12.000000
     H=12.000000
}
