class BreakoutBlock extends BreakoutObject;

#exec TEXTURE IMPORT NAME=BreakoutBlock01 FILE=Textures\BreakoutBlock01.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2
#exec TEXTURE IMPORT NAME=BreakoutBlock02 FILE=Textures\BreakoutBlock02.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2
#exec TEXTURE IMPORT NAME=BreakoutBlock03 FILE=Textures\BreakoutBlock03.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2

var int		strengthMax,
		strengthCur;
var float	powerupChance;
var Color	colorFullHealth;
var float	oldX, oldY, oldW, oldH;
var float	scoreMultiplier;

var bool	bBroken;
var Texture	BrokenTexture;

var bool	bUnbreakable;
var Texture	UnbreakableTexture;

function SetBallVelocityNormal(BreakoutBall B)
{
	local float dst, tmp;

	switch(CollisionSide(B))
	{
	case "TOP":
	case "BOTTOM":
		dst = X + W/2 - B.X - B.W/2;
		tmp = FClamp(abs(dst) / (W/2), 0.15, 0.75);
		if(B.VX/abs(B.VX)<0)
			tmp=-tmp;
		break;
	case "LEFT":
	case "RIGHT":
		dst = Y + H/2 - B.Y - B.H/2;
		tmp = FClamp(abs(dst) / (H/2), 0.35, 0.9);
		if(B.VY/abs(B.VY)<0)
			tmp=-tmp;
		break;
	}

	switch(CollisionSide(B))
	{
	case "TOP":
		B.VX=tmp;
		B.VY=-sqrt(1-tmp*tmp);
		break;
	case "BOTTOM":
		B.VX=tmp;
		B.VY=sqrt(1-tmp*tmp);
		break;
	case "LEFT":
		B.VX=-sqrt(1-tmp*tmp);
		B.VY=tmp;
		break;
	case "RIGHT":
		B.VX=sqrt(1-tmp*tmp);
		B.VY=tmp;
		break;
	}
}

function Collide(BreakoutObject other)
{
	if(other.IsA('BreakoutBall'))
	{
		scoreMultiplier=BreakoutBall(other).GetScoreMultiplier();
		if(bUnbreakable)
			scoreMultiplier=2.0;
		else
			scoreMultiplier*=1+0.5*(strengthMax-1);

		if((BreakoutBall(other).bKiller || board.IsKeyDown(IK_Z)) && !bUnbreakable || BreakoutBall(other).bSuperKiller)
		{
			Kill();
			return;
		}

		SetBallVelocityNormal(BreakoutBall(other));

		if(bUnbreakable)
		{
			board.PlaySound(Sound'BreakoutUnbreakable', 1.0);
			return;
		}

		if(--strengthCur==0)
		{
			Kill();
			return;
		}

		if(!bBroken)
		{
			drawTexture=BrokenTexture;
			bBroken=true;
		}

		drawColor.R=colorFullHealth.R*(128+(255-128)*strengthCur/strengthMax)/float(255);
		drawColor.G=colorFullHealth.G*(128+(255-128)*strengthCur/strengthMax)/float(255);
		drawColor.B=colorFullHealth.B*(128+(255-128)*strengthCur/strengthMax)/float(255);

		board.PlaySound(Sound'BreakoutBallHit', 1.0);
	}
}

function PostUpdate(float deltaTime)
{
	if(bRemove)
	{
		X=oldX+oldW/4*(removeTimerAmt-removeTimer)/removeTimerAmt;
		Y=oldY+oldH/4*(removeTimerAmt-removeTimer)/removeTimerAmt;
		W=oldW*(1-0.5*(removeTimerAmt-removeTimer)/removeTimerAmt);
		H=oldH*(1-0.5*(removeTimerAmt-removeTimer)/removeTimerAmt);
	}
}

function Color MakeColor(int R, int G, int B)
{
	local color ret;
	ret.R=R;
	ret.G=G;
	ret.B=B;
	return ret;
}

function MakePowerup()
{
	local BreakoutPowerup powerup;

	powerup=new Class'BreakoutPowerup';
	powerup.X=X+W/2-powerup.W/2;
	powerup.Y=Y+H/2-powerup.H/2;

	switch(rand(11))
	{
	case 0:
		powerup.power="SHRINK";
		powerup.letter="S";
		powerup.letterColor=MakeColor(0,0,255);
		powerup.drawColor=MakeColor(255,0,255);
		break;
	case 1:
		powerup.power="GROW";
		powerup.letter="G";
		powerup.letterColor=MakeColor(0,255,0);
		powerup.drawColor=MakeColor(255,255,0);
		break;
	case 2:
		powerup.power="INVERT";
		powerup.letter=" I";
		powerup.letterColor=MakeColor(255,0,0);
		powerup.drawColor=MakeColor(255,255,255);
		break;
	case 3:
		powerup.power="FAST";
		powerup.letter="F";
		powerup.letterColor=MakeColor(255,128,0);
		powerup.drawColor=MakeColor(64,255,64);
		break;
	case 4:
		powerup.power="SLOW";
		powerup.letter="S";
		powerup.letterColor=MakeColor(255,255,255);
		powerup.drawColor=MakeColor(0,255,0);
		break;
	case 5:
		powerup.power="KILLER";
		powerup.letter="K";
		powerup.letterColor=MakeColor(255,255,255);
		powerup.drawColor=MakeColor(128,0,0);
		break;
	case 6:
		powerup.power="SUPERKILLER";
		powerup.letter="K";
		powerup.letterColor=MakeColor(255,0,0);
		powerup.drawColor=MakeColor(64,64,64);
		break;

	case 7:
		powerup.power="SPLIT";
		powerup.letter="+";
		powerup.letterColor=MakeColor(255,0,255);
		powerup.drawColor=MakeColor(64,64,64);
		break;

	case 8:
		powerup.power="MAGNET";
		powerup.letter="M";
		powerup.letterColor=MakeColor(255,255,255);
		powerup.drawColor=MakeColor(0,0,255);
		break;

	case 9:
		powerup.power="SKIP";
		powerup.letter="L";
		powerup.letterColor=MakeColor(255,255,0);
		powerup.drawColor=MakeColor(255,255,255);
		break;

	case 10:
		powerup.power="1UP";
		powerup.letter="E";
		powerup.letterColor=MakeColor(0,255,0);
		powerup.drawColor=MakeColor(0,128,0);
		break;
	}

	board.AddElement(powerup);
}

function PostKill()
{
	board.PlaySound(Sound'BreakoutBlockBreak', 1.0);
	drawStyle=DSTY_Translucent;
	drawColor=colorFullHealth;
	bStatic=false;
	bCollidable=false;
	oldX=X;
	oldY=Y;
	oldW=W;
	oldH=H;
	if(!bUnbreakable)
		board.BlockDestroyed(scoreMultiplier);
	if(FRand()<powerupChance)
		MakePowerup();
}

function Init()
{
	StrengthCur=StrengthMax;
	colorFullHealth=drawColor;
	removeTimerAmt=7.5;
	if(bUnbreakable)
		drawTexture=UnbreakableTexture;
}

defaultproperties
{
     strengthMax=1
     powerupChance=0.050000
     BrokenTexture=Texture'TNMGUI.UI.BreakoutBlock02'
     UnbreakableTexture=Texture'TNMGUI.UI.BreakoutBlock03'
     bCollidable=True
     DrawTexture=Texture'TNMGUI.UI.BreakoutBlock01'
     W=32.000000
     H=16.000000
}
