//handles the main game logic, it started off as relatively clean oo goodness
//then it got hacked until it worked
//	created by Nicholas 'NVShacker' Van Sickle
class BreakoutBoard extends Window
			abstract; //subclass has levels, as they're generated by the editor and FUCKING HUGE

//no idea what's using what sound where, so what the hell, import them all here
#exec AUDIO IMPORT NAME=BreakoutBlockBreak FILE=Sounds\Breakout-BlockBreak.wav GROUP=UI
#exec AUDIO IMPORT NAME=BreakoutExtraLife FILE=Sounds\Breakout-ExtraLife.wav GROUP=UI
#exec AUDIO IMPORT NAME=BreakoutPowerUpBad FILE=Sounds\Breakout-NegPowerUp.wav GROUP=UI
#exec AUDIO IMPORT NAME=BreakoutPowerUpGood FILE=Sounds\Breakout-PosPowerUp.wav GROUP=UI
#exec AUDIO IMPORT NAME=BreakoutBallHit FILE=Sounds\Breakout-Paddle.wav GROUP=UI
#exec AUDIO IMPORT NAME=BreakoutGrowPaddle FILE=Sounds\Breakout-ExtendPaddle.wav GROUP=UI
#exec AUDIO IMPORT NAME=BreakoutShrinkPaddle FILE=Sounds\Breakout-RetractPaddle.wav GROUP=UI
#exec AUDIO IMPORT NAME=BreakoutUnbreakable FILE=Sounds\Breakout-Unbreakable.wav GROUP=UI
#exec AUDIO IMPORT NAME=BreakoutBallFell FILE=Sounds\Breakout-Failure.wav GROUP=UI

//simple font to show the passcodes on the scoreboard, the TrueTypeFontFactory was clearly made for this noble purpose
#exec new TrueTypeFontFactory Name="PasscodeFont" FontName="Courier New" Height=16 AntiAlias=2 XPad=2 CharactersPerPage=64

//a level, generated by the level editor, is dumped into lines of code that initialize the levels structure
//yay for uscript not having struct pointers!

//a block in a level
struct BBlock
{
  var() bool 	bUsed,		//indicates the block should be created in the given level, otherwise it's ignored
		bUnbreakable;	//is it an evil metal unbreakable block?
  var() Color 	col;		//block color, works with unbreakables but the editor makes them gray regardless
  var() int	str;		//how many hits does this block take to destroy? only matters for breakable blocks
};

//a level
struct BLevel
{
  var() BBlock	blocks[/*20x14*/280];	//stores the grid in a block array which is used to create the level
  var() string	name,passcode;		//level name and passcode to jump to it
};
var BLevel		levels[100];		//100 levels max, any more and the engine would probably just die
var int			level_order[100];	//since the order is subject to change, point to their array indices
var int			level_count,		//number of levels, game will cycle back to the begining
			level_start,		//level to start on, for debugging with the set command
			lives_start;		//extra times you can drop the ball and not lose

var bool		bRunning,		//should the breakoutobjects be updated in tick?
			bPaused,		//should the paused text be drawn?
			bGameOver,		//should the game over text be drawn?
			bPassCode;		//should the passcode prompt be drawn?

var string		PassCodeStr;		//current string in the passcode prompt
var bool		bPasscodeUseKey;	//should the last key pressed be added the the passcode prompt string?

var LinkedList		elements;		//the actual game elements to be updated

var BreakoutPaddle	paddle;			//the paddle, reset when the ball is dropped and such
var BreakoutWall	wallTop,		//the white line wall boundaries around the board
			wallBottom,		//stored for debugging and checking for a ball fall iirc
			wallLeft,
			wallRight;

var int			blockStartX,		//top left corner of the block drawing area
			blockStartY,
			blockSpaceX,		//horizontal and vertical space between blocks
			blockSpaceY;

var int			blockCount,		//number of blocks left in the level to be destroyed
			ballCount;		//number of balls left in the level to check if all have been dropped

var float		scoreboardX,		//scoreboard offset from the right of the window
			scoreboardY,
			scoreboardW,		//total width available for scoreboard
			scoreboardSpacer;	//distance between scoreboard lines
var Font		scoreboardHeaderFont,	//scoreboard title font
			scoreboardFont,		//other stat font
			scoreboardPasscodeFont;	//passcode font
var localized string	scoreboardHeaderStr,	//scoreboard title unformatted string, unused, replaced with level name
			scoreboardLivesStr,	//lives left label/indicator formatted string
			scoreboardLevelStr,	//level name label/indicator formatted string
			scoreboardScoreStr,	//current score label/indicator formatted string
			scoreboardPasscodeStr;	//passcode label unformatted string

var int			gameLives,		//current lives left, ball drops at 0, game over
			gameScore,		//current score
			gameLevel;		//current level number (index in level_order)
var Font		gameOverlayFont;	//font used when the game has been paused and text is drawn over the board

var Trestkon		player;			//reference to the player, for updating his high score

//draw everything. rather than use difficult to manage child windows (they don't like to be destroyed, for one thing)
event DrawWindow(GC gc)
{
	local LinkedListNode n;

	local Window parent;
	local float sX,sY,sW,sH;
	local string str;

	//simple iteration, the draw method in breakoutobject handles the rest
	for(n=elements.first;n!=None;n=n.next)
		BreakoutObject(n.data).Draw(gc);

	//draw the overlay stuff if the game isn't running
	if(!bRunning)
	{
		gc.SetTileColorRGB(0,0,96); 	//draw a blue overlay, ideally it'd darken the board with DSTY_Modulated
		gc.SetStyle(DSTY_Translucent); 	//but modulated doesn't support colorizing drawn textures (which SUCKS)
		gc.DrawStretchedTexture(0,0,width,height,0,0,1,1,Texture'Extension.Solid');
		str=""; //figure out the overlay message, CR() returns the newline char for drawtext
		if(bPaused)
			str="PAUSED"$CR()$"PRESS 'P' TO RESUME";
		else if(bGameOver)
			str="GAME OVER"$CR()$"PRESS ENTER TO BEGIN OR 'P' TO ENTER A PASSCODE";
		else if(bPassCode)
			str="ENTER PASSCODE OR LEAVE BLANK TO GO BACK:"$CR()$PassCodeStr;
		else
			str="PRESS ENTER TO BEGIN OR 'P' TO ENTER A PASSCODE";
		gc.SetFont(gameOverlayFont);
		gc.GetTextExtent(width,sW,sH,str); //get the text size
		gc.SetTextColorRGB(255,255,255);
		gc.DrawText(width/2-sW/2,height/2-sH/2,width,height,str); //centers the text using the board and text size
		return;
	}

	//ugly as fuck, gets the network terminal parent's gc to draw to the right of the owning computerui window
	//depends on the (winClient) -> (ComputerUIWindow) -> (NetworkTerminal) chain
	parent=winParent.winParent.winParent;
	gc=parent.GetGC();

	//get the coordinates in parent at the top right corner and add the scoreboarX/Y offset
	ConvertCoordinates(Self,width,0,parent,sX,sY);
	sX+=scoreboardX;
	sY+=scoreboardY;

	//draw the various parts of the scoreboard roughly as such:
	//set the text font/color, get the string to draw, get the size of the text to be drawn, draw it
	//move the current Y down past this line plus the space between lines, repeat with new line

	//header
	gc.SetFont(scoreboardHeaderFont);
	gc.SetTextColorRGB(255,0,0);
	str=/*scoreboardHeaderStr*/levels[level_order[gameLevel%level_count]].name; //use level name now
	gc.GetTextExtent(scoreboardW,sW,sH,str);
	gc.DrawText(sX/*+scoreboardW/2-sW/2*/,sY,sW,sH,str); //commented out centering header, looks better left justified
	sY+=sH*1.25+scoreboardSpacer; //slightly larger space between header and rest of scoreboard

	//lives
	gc.SetFont(scoreboardFont);
	gc.SetTextColorRGB(255,255,255);
	str=sprintf(scoreboardLivesStr,gameLives);
	gc.GetTextExtent(scoreboardW,sW,sH,str);
	gc.DrawText(sX,sY,sW,sH,str);
	sY+=sH+scoreboardSpacer;

	//level
	gc.SetFont(scoreboardFont);
	gc.SetTextColorRGB(255,255,255);
	str=sprintf(scoreboardLevelStr,gameLevel+1);
	gc.GetTextExtent(scoreboardW,sW,sH,str);
	gc.DrawText(sX,sY,sW,sH,str);
	sY+=sH+scoreboardSpacer;

	//score
	gc.SetFont(scoreboardFont);
	gc.SetTextColorRGB(255,255,255);
	str=sprintf(scoreboardScoreStr,gameScore);
	gc.GetTextExtent(scoreboardW,sW,sH,str);
	gc.DrawText(sX,sY,sW,sH,str);
	sY+=sH+scoreboardSpacer;
	sY+=sH+scoreboardSpacer;

	//if the level has a passcode, show it
	if(levels[level_order[gameLevel%level_count]].passcode!="")
	{
		//passcode label
		gc.SetFont(scoreboardFont);
		gc.SetTextColorRGB(255,255,0);
		str=scoreboardPasscodeStr;
		gc.GetTextExtent(scoreboardW,sW,sH,str);
		gc.DrawText(sX,sY,sW,sH,str);
		sY+=sH+scoreboardSpacer;

		//passcode
		gc.SetFont(scoreboardPasscodeFont);
		gc.SetTextColorRGB(255,255,0);
		str="  "$levels[level_order[gameLevel%level_count]].passcode; //indent with a space
		gc.GetTextExtent(scoreboardW,sW,sH,str);
		gc.DrawText(sX,sY,sW,sH,str);
		sY+=sH+scoreboardSpacer;
	}

	//always release a gc you acquire, lest the renderer get really fucked up
	parent.ReleaseGC(gc);
}

//integrates and initializes a breakoutobject with the game logic/rendering code
function AddElement(BreakoutObject obj)
{
	elements.add(obj);
	obj.BoardInit(Self);
}

//used when prompting for a passcode to append valid input to the passcode string, always called AFTER VirtualKeyPressed
event bool KeyPressed(string key)
{
	if(!bRunning && bPassCode && bPassCodeUseKey) //check for passcode prompt
	{
		if(key=="-" || key==" ") //replace the space and minus with underscores
			key="_";
		PassCodeStr=PassCodeStr$caps(key);
		bPassCodeUseKey=false;
		return true;
	}
	return false;
}

//handle input, mainly starting a new game and pausing
event bool VirtualKeyPressed(EInputKey key, bool bRepeat)
{
	local bool bKeyHandled;
	local int code;

	if(bPassCode) //allow alphanumeric characters and underscores (spaces get replaced) for passcode strings
		bPassCodeUseKey=key>=IK_A&&key<=IK_Z || key>=IK_0&&key<=IK_9 || key==IK_Minus || key==IK_Space;

	bKeyHandled = True;

	switch(key)
	{
		case IK_Enter:
			if(!bRunning && !bPaused && !bPassCode) //start a new game
			{
				bRunning=true;
				if(bGameOver)
				{
					InitGame();
					CreateGame();
				}
			}
			else if(!bRunning && bPassCode) //try a passcode
			{
				if(PassCodeStr!="")
				{
					code=PassCode(PassCodeStr);
					if(code!=-1)
					{
						InitGame();
						gameLevel=code;
						CreateGame();
						bRunning=true;
						bPassCode=false;
					}
					else
						PassCodeStr="";
				}
				else
					bPassCode=false;
			}
			break;

		case IK_P:
			if(bRunning != bPaused) //toggle pause
			{
				bRunning=!bRunning;
				bPaused=!bPaused;
			}
			else if(!bRunning && !bPassCode) //passcode prompt
			{
				bGameOver=false;
				bPassCode=true;
				PassCodeStr="";
			}
			break;

		case IK_Backspace:
			if(!bRunning && bPasscode) //delete last passcode prompt char
				PassCodeStr=left(PassCodeStr, len(PassCodeStr)-1);

		case IK_Left:
		case IK_Right:
		case IK_A:
		case IK_D:
		case IK_Space:
			bKeyHandled=bRunning; //the paddle will handle these
			break;

		//powerup debugging
/*		case IK_Z:
			paddle.PowerUp("SUPERKILLER");
			break;

		case IK_X:
			paddle.PowerUp("SKIP");
			break;

		case IK_G:
			paddle.PowerUp("GROW");
			break;

		case IK_H:
			paddle.PowerUp("1UP");
			break;*/

		default:
			bKeyHandled = False; //not handled
			break;
	}

	return bKeyHandled || Super.VirtualKeyPressed(key, bRepeat); //to quote shane: "go go short ciruit whatever"
}

//try to find a level with the given passcode, returns the level index or -1 if no match is found
function int PassCode(string code)
{
	local int i;

	for(i=0;i<level_count;i++)
		if(levels[level_order[i]].passcode==code)
			return i;

	return -1;
}

//handles calling all integrated objects' logic updates
function Tick(float deltaTime)
{
	local LinkedListNode n;
	local BreakoutObject b;

	if(!bRunning) //if the game isn't running don't update
		return;

	Trestkon(GetPlayerPawn()).AddGameTimePlayed("BREAKOUT",deltaTime);

	for(n=elements.first;n!=None;n=n.next)
	{
		b=BreakoutObject(n.data);
		if(b.bRemove && b.removeTimer<=0)	//remove objects queued for deletion
			elements.remove(n);		
		else					//update the rest
			b.Update(deltaTime*100);	//100 was a typo, should have been milliseconds, caught it too late
	}
}

//initializes all game data
event InitWindow()
{
	bTickEnabled=true;
	player=Trestkon(BreakoutWindow(winParent).player);
	InitGame();
	InitLevels();
}

//create a new linkedlist for game objects, set the level and lives to the defaults
function InitGame()
{
	elements=new (None) Class'LinkedList';
	gameLevel=Class'BreakoutBoard'.Default.level_start;
	gameLives=Class'BreakoutBoard'.Default.lives_start;
}

//create the blocks for a given level using the levels structure
function CreateLevel(int l)
{
	local BreakoutBlock block;
	local int row, col;

	l=level_order[l]; //look up indice

	KillAll('BreakoutBlock'); //get rid of old blocks

	blockCount=0;

	for(row=0;row<20;row++) //iterate through the level's block array and create and set up the used blocks
	{
		for(col=0;col<14;col++)
		{
			if(levels[l].blocks[row*14+col].bUsed)
			{
				block=new (None) Class'BreakoutBlock';
				block.drawColor=levels[l].blocks[row*14+col].col;
				block.strengthMax=levels[l].blocks[row*14+col].str;

				block.X=blockStartX+(block.W+blockSpaceX)*col;
				block.Y=blockStartY+(block.H+blockSpaceY)*row;

				if(levels[l].blocks[row*14+col].bUnbreakable)
					block.bUnbreakable=true;
				else
					blockCount++;

				AddElement(block);
			}
		}
	}
}

//creates a ball in the center of the paddle
function CreatePaddleBall()
{
	local BreakoutBall ball;

	ball=new (None) Class'BreakoutBall';
	ball.X=paddle.X+paddle.W/2-ball.W/2;
	ball.Y=paddle.Y-ball.H-1;
	AddElement(ball);
	paddle.GetBall(ball);
	ballCount++;
}

//creates the breakoutobjects for a new game
function CreateGame()
{
	paddle=new (None) Class'BreakoutPaddle';
	paddle.X=width/2-paddle.W/2;
	paddle.Y=height-paddle.H-3;
	AddElement(paddle);

	wallTop=new (None) Class'BreakoutWall';
	wallTop.wallType="TOP";
	AddElement(wallTop);

	wallBottom=new (None) Class'BreakoutWall';
	wallBottom.wallType="BOTTOM";
	AddElement(wallBottom);

	wallLeft=new (None) Class'BreakoutWall';
	wallLeft.wallType="LEFT";
	AddElement(wallLeft);

	wallRight=new (None) Class'BreakoutWall';
	wallRight.wallType="RIGHT";
	AddElement(wallRight);

	CreatePaddleBall();
	CreateLevel(gameLevel);
	ballCount=1;
}

//remove all integrated objects of a given type
function KillAll(Name type)
{
	local LinkedListNode n;
	local BreakoutObject b;
	for(n=elements.first;n!=None;n=n.next)
	{
		b=BreakoutObject(n.data);
		if(b.IsA(type))
			elements.remove(n);
	}
}

//when the board's size has been set, add a timer to call CreateGame shortly after (this avoids a bunch of log spam)
event ConfigurationChanged()
{
	super.ConfigurationChanged();
	AddTimer(0.01,false,,'CreateGame');
}

//called by destroyed blocks, the scoreMultiplier passed in is based on block strength and player powerups
function BlockDestroyed(float scoreMultiplier)
{
	gameScore+=10*FClamp(scoreMultiplier*paddle.GetScoreMultiplier(),0.1,4.0);
	if(player==None)
		foreach AllObjects(Class'Trestkon',player)
			break;
//	if(player!=None && player.GameHighScoreBreakout<gameScore)
//		player.GameHighScoreBreakout=gameScore;
	if(--blockCount==0)
	{
		if(gameLevel%2==1)
			gameLives++;
		NextLevel();
	}
}

//reset the paddle and balls, go to next level
function NextLevel()
{
	blockCount=0;
	KillAll('BreakoutBall');
	CreateLevel(++gameLevel%level_count);
	CreatePaddleBall();
	paddle.BallFell();
	ballCount=1;
}

//handles collision detection notification
function UpdateChild(BreakoutObject obj, float nx, float ny)
{
	local LinkedListNode n;
	local BreakoutObject b;

	obj.PX=obj.X;
	obj.PY=obj.Y;
	obj.X=NX;
	obj.Y=NY;

	if(!obj.bCollidable)
		return;

	for(n=elements.first;n!=None;n=n.next)
	{
		b=BreakoutObject(n.data);
		//a bunch of ugly shit, I didn't think to have collision exemption lists or anything at the time
		if(!b.IsA('BreakoutPowerup') && (!obj.IsA('BreakoutPowerup')||!b.IsA('BreakoutBlock')) &&
			(!b.IsA('BreakoutBall') || !obj.IsA('BreakoutBall')) &&
			obj!=b && b.bCollidable && obj.IsColliding(b))
		{
			obj.Collide(b); //objects handle the collision
			b.Collide(obj);
			obj.X=obj.PX; //reset to the pre-collision location
			obj.Y=obj.PY;
		}
	}
}

//enables the game over overlay
function GameOver()
{
	bRunning=false;
	bGameOver=true;
}

//handle a ball hitting the bottom wall
function BallFell()
{
	if(--ballCount==0)
	{
		if(--gameLives<0)
		{
			GameOver();
			return;
		}

		paddle.BallFell();
		PlaySound(Sound'BreakoutBallFell', 1.0);
		AddTimer(1.0,false,,'CreatePaddleBall'); //let the sound play a bit
//		CreatePaddleBall();
	}
}

//since there's no way for breakoutobjects to iterate through the intgrated linked list
//paddle uses this to call PowerUp on all the balls
function PowerUpBalls(string pwr)
{
	local LinkedListNode n;
	local BreakoutBall b;

	for(n=elements.first;n!=None;n=n.next)
	{
		b=BreakoutBall(n.data);
		if(b!=None)
		{
			b.PowerUp(pwr);
			if(pwr=="SPLIT")
				return;
		}
	}
}

//used in subclass to define the level data
function InitLevels();

defaultproperties
{
     lives_start=3
     blockStartX=8
     blockStartY=32
     blockSpaceX=1
     blockSpaceY=1
     scoreboardX=8.000000
     scoreboardW=221.000000
     scoreboardSpacer=3.000000
     scoreboardHeaderFont=Font'DeusExUI.FontMenuExtraLarge'
     scoreboardFont=Font'DeusExUI.FontFixedWidthLocation'
     scoreboardPasscodeFont=Font'TNMGUI.PasscodeFont'
     scoreboardHeaderStr="BREAKOUT"
     scoreboardLivesStr=" Lives: %i"
     scoreboardLevelStr=" Level: %i"
     scoreboardScoreStr=" Score: %i"
     scoreboardPasscodeStr=" Passcode:"
     gameOverlayFont=Font'DeusExUI.FontMenuHeaders'
}
