class BreakoutEditBoard extends Window;

var BreakoutBlock	blocks[280];
var int			blockStartX,
			blockStartY,
			blockSpaceX,
			blockSpaceY,
			blockSelected;

static final preoperator int # (float f)
{
	return int(f+0.5);
}

event InitWindow()
{
	local int i,c;
	bTickEnabled=true;
	for(i=0;i<20;i++)
	{
		for(c=0;c<14;c++)
		{
			blocks[i*14+c]=new (None) Class'BreakoutBlock';
			blocks[i*14+c].DrawTexture=Texture'Extension.Solid';
			blocks[i*14+c].X=blockStartX+(blocks[i*14+c].W+blockSpaceX)*c;
			blocks[i*14+c].Y=blockStartY+(blocks[i*14+c].H+blockSpaceY)*i;
			blocks[i*14+c].boardInit(None);
		}
	}
}

event DrawWindow(GC gc)
{
	local int i;

	for(i=0;i<280;i++)
	{
		if(i==blockSelected)
		{
			gc.SetTileColorRGB(255,0,0);
			gc.DrawStretchedTexture(#blocks[i].X-1, #blocks[i].Y-1, #blocks[i].W+2, #blocks[i].H+2,
						 0, 0, 1, 1, Texture'Extension.Solid');
		}
		blocks[i].Draw(gc);
		if(blocks[i].drawTexture!=Texture'Extension.Solid')
		{
			gc.SetFont(Font'DeusEx.FontConversationLargeBold');
			gc.SetTextColorRGB(255,255,255);
			gc.SetStyle(DSTY_Normal);
			gc.DrawText(blocks[i].X+blocks[i].W*3/8,blocks[i].Y-3,
				blocks[i].W/4,blocks[i].H+3,""$blocks[i].strengthMax);
		}
	}
}

function ToggleCurrent()
{
	if(blocks[blockSelected].drawTexture==Texture'Extension.Solid')
		blocks[blockSelected].drawTexture=Texture'BreakoutBlock01';
	else
	{
		blocks[blockSelected].drawTexture=Texture'Extension.Solid';
		blocks[blockSelected].drawColor.R=255;
		blocks[blockSelected].drawColor.G=255;
		blocks[blockSelected].drawColor.B=255;
		blocks[blockSelected].strengthMax=1;
	}
}

function SetBlockType(int type)
{
	if(blocks[blockSelected].drawTexture==Texture'Extension.Solid')
		return;

	switch(type)
	{
	case 1:
		blocks[blockSelected].drawTexture=Texture'BreakoutBlock01';
		blocks[blockSelected].drawColor.R=255;
		blocks[blockSelected].drawColor.G=0;
		blocks[blockSelected].drawColor.B=0;
		break;
	case 2:
		blocks[blockSelected].drawTexture=Texture'BreakoutBlock01';
		blocks[blockSelected].drawColor.R=0;
		blocks[blockSelected].drawColor.G=255;
		blocks[blockSelected].drawColor.B=0;
		break;
	case 3:
		blocks[blockSelected].drawTexture=Texture'BreakoutBlock01';
		blocks[blockSelected].drawColor.R=0;
		blocks[blockSelected].drawColor.G=0;
		blocks[blockSelected].drawColor.B=255;
		break;
	case 4:
		blocks[blockSelected].drawTexture=Texture'BreakoutBlock01';
		blocks[blockSelected].drawColor.R=255;
		blocks[blockSelected].drawColor.G=255;
		blocks[blockSelected].drawColor.B=0;
		break;
	case 5:
		blocks[blockSelected].drawTexture=Texture'BreakoutBlock01';
		blocks[blockSelected].drawColor.R=0;
		blocks[blockSelected].drawColor.G=255;
		blocks[blockSelected].drawColor.B=255;
		break;
	case 6:
		blocks[blockSelected].drawTexture=Texture'BreakoutBlock01';
		blocks[blockSelected].drawColor.R=255;
		blocks[blockSelected].drawColor.G=0;
		blocks[blockSelected].drawColor.B=255;
		break;
	case 7:
		blocks[blockSelected].drawTexture=Texture'BreakoutBlock01';
		blocks[blockSelected].drawColor.R=255;
		blocks[blockSelected].drawColor.G=128;
		blocks[blockSelected].drawColor.B=0;
		break;
	case 8:
		blocks[blockSelected].drawTexture=Texture'BreakoutBlock01';
		blocks[blockSelected].drawColor.R=0;
		blocks[blockSelected].drawColor.G=255;
		blocks[blockSelected].drawColor.B=128;
		break;
	case 9:
		blocks[blockSelected].drawTexture=Texture'BreakoutBlock03';
		blocks[blockSelected].drawColor.R=192;
		blocks[blockSelected].drawColor.G=192;
		blocks[blockSelected].drawColor.B=192;
		break;
	}
}

function SetBlockStrength(int str)
{
	if(blocks[blockSelected].drawTexture==Texture'Extension.Solid')
		return;

	blocks[blockSelected].strengthMax=str;
}

function logLevel()
{
	local int i;
	local string prefix;
	log("dumping level contents...");
	for(i=0;i<280;i++)
	{
		if(blocks[i].drawTexture!=Texture'Extension.Solid')
		{
			prefix="levels[%LEVELNUM%].blocks["$i$"].";
			log(prefix$"bUsed=true;");
			log(prefix$"bUnbreakable="$(blocks[i].drawTexture==Texture'BreakoutBlock03')$";");
			log(prefix$"col.R="$blocks[i].drawColor.R$";");
			log(prefix$"col.G="$blocks[i].drawColor.G$";");
			log(prefix$"col.B="$blocks[i].drawColor.B$";");
			log(prefix$"str="$blocks[i].strengthMax$";");
		}
	}
}

defaultproperties
{
     blockStartX=8
     blockStartY=32
     blockSpaceX=1
     blockSpaceY=1
}
