class BreakoutEditWindow extends ComputerUIWindow;

var MenuUIActionButtonWindow 	btnLog;
var MenuUIActionButtonWindow 	btnExit;

var BreakoutEditBoard		winBoard;

function CreateControls()
{
	super.CreateControls();

	btnLog=winButtonBar.AddButton("Log Level", HALIGN_Right);
	btnExit=winButtonBar.AddButton("Exit", HALIGN_Right);

//	btnLog.SetSelectability(false);
//	btnExit.SetSelectability(false);

	winBoard=BreakoutEditBoard(winClient.NewChild(Class'BreakoutEditBoard'));
	winBoard.SetSize(479,480);
	SetFocusWindow(winBoard);
}

function bool ButtonActivated( Window buttonPressed )
{
	if(buttonPressed == btnLog)
	{
		winBoard.logLevel();
		return true;
	}

	if(buttonPressed == btnExit)
	{
		CloseScreen("EXIT");
		return true;
	}

	return super.ButtonActivated(buttonPressed);
}

event bool VirtualKeyPressed(EInputKey key, bool bRepeat)
{
	local bool bKeyHandled;

	bKeyHandled = True;

	switch(key)
	{
		case IK_Left:
		case IK_A:
			if(winBoard.blockSelected-1>=0)
				winBoard.blockSelected--;
			break;

		case IK_Right:
		case IK_D:
			if(winBoard.blockSelected+1<280)
				winBoard.blockSelected++;
			break;

		case IK_Up:
		case IK_W:
			if(winBoard.blockSelected-14>=0)
				winBoard.blockSelected-=14;
			break;

		case IK_Down:
		case IK_S:
			if(winBoard.blockSelected+14<280)
				winBoard.blockSelected+=14;
			break;

		case IK_T:
			winBoard.ToggleCurrent();
		case IK_1:
			winBoard.SetBlockType(1);
			break;

		case IK_2:
			winBoard.SetBlockType(2);
			break;

		case IK_3:
			winBoard.SetBlockType(3);
			break;

		case IK_4:
			winBoard.SetBlockType(4);
			break;

		case IK_5:
			winBoard.SetBlockType(5);
			break;

		case IK_6:
			winBoard.SetBlockType(6);
			break;

		case IK_7:
			winBoard.SetBlockType(7);
			break;

		case IK_8:
			winBoard.SetBlockType(8);
			break;

		case IK_9:
			winBoard.SetBlockType(9);
			break;

		case IK_NumPad1:
			winBoard.SetBlockStrength(1);
			break;

		case IK_NumPad2:
			winBoard.SetBlockStrength(2);
			break;

		case IK_NumPad3:
			winBoard.SetBlockStrength(3);
			break;

		case IK_NumPad4:
			winBoard.SetBlockStrength(4);
			break;

		case IK_NumPad5:
			winBoard.SetBlockStrength(5);
			break;

		case IK_NumPad6:
			winBoard.SetBlockStrength(6);
			break;

		case IK_NumPad7:
			winBoard.SetBlockStrength(7);
			break;

		case IK_NumPad8:
			winBoard.SetBlockStrength(8);
			break;

		case IK_NumPad9:
			winBoard.SetBlockStrength(9);
			break;

		default:
			bKeyHandled = False;
			break;
	}

	if (!bKeyHandled)
		return Super.VirtualKeyPressed(key, bRepeat);
	else
		return bKeyHandled;
}

defaultproperties
{
     Title="Breakout Editor"
     ClientWidth=479
     ClientHeight=480
     clientTextures(0)=Texture'TNMGUI.UI.BreakoutBackground01'
     clientTextures(1)=Texture'TNMGUI.UI.BreakoutBackground02'
     clientTextures(2)=Texture'TNMGUI.UI.BreakoutBackground03'
     clientTextures(3)=Texture'TNMGUI.UI.BreakoutBackground04'
     textureRows=2
     textureCols=2
     bUsesStatusWindow=False
     statusPosY=383
     ComputerNodeFunctionLabel="BreakoutEdit"
}
