//handles all the basic logic and rendering shit for the game entities in breakout
//	created by Nicholas 'NVShacker' Van Sickle
class BreakoutObject extends ExtensionObject
				abstract;

//board that owns this object
var BreakoutBoard	board;

//object properties
var bool		bVisible,
			bStatic,
			bMoving,
			bCollidable,
			bRemove;

var float		removeTimer;
var float		removeTimerAmt;

//drawing properties
var Texture		drawTexture;
var Color		drawColor;
var EDrawStyle		drawStyle;

//hacked in later to allow breakoutpaddle to draw properly
var bool		bOverrideTextureDraw;

//location rectangle
var float		X,
			Y,
			W,
			H;

//old location
var float		PX,
			PY;

//velocity normal and scalar
var float		VX,
			VY,
			VS;

//simple float rounding, kept getting tweaked so it was made an operator
static final preoperator int # (float f)
{
	return int(f/*+0.5*/);
}

//used instead of the default draw code if bOverrideTextureDraw is true
function DrawOverride(GC gc, int dX, int dY, int dW, int dH, int oX, int oY, int oU, int oV, Texture tex)
{
	gc.DrawStretchedTexture(dX,dY,dW,dH,oX,oY,oU,oV,tex);
}

//for further drawing in the subclass
function PostDraw(GC gc)
{
	return;
}

//immutable draw function used by breakoutboard
final function Draw(GC gc)
{
	if(!bVisible)
		return;

	gc.SetTileColor(drawColor);
	gc.SetStyle(drawStyle);
	if(bOverrideTextureDraw)
		DrawOverride(gc, #X, #Y, #W, #H, 0, 0, drawTexture.USize, drawTexture.VSize, drawTexture);
	else
		gc.DrawStretchedTexture(#X, #Y, #W, #H, 0, 0, drawTexture.USize, drawTexture.VSize, drawTexture);
	PostDraw(gc);
}

//for further updating in the subclass
function PostUpdate(float deltaTime)
{
	return;
}

//immutable logic update fucntion used by breakoutboard
final function Update(float deltaTime)
{
	local float deltaX, deltaY;

	if(bRemove)
		removeTimer-=deltaTime;

	if(bStatic)
		return;

	if(bMoving)
	{
		deltaX=VX*VS*deltaTime;
		deltaY=VY*VS*deltaTime;
	}

	board.UpdateChild(Self,X+deltaX,Y+deltaY);

	PostUpdate(deltaTime);
}

//really funky looking overridable collision detection algorithm using the rounding operator liberally
function bool IsColliding(BreakoutObject B)
{
	return  	(#X >= #B.X && #X <= #B.X + #B.W ||
			#B.X >= #X && #B.X <= #X + #W ||
			#X + #W >= #B.X && #X + #W <= #B.X + #B.W ||
			#B.X + #B.W >= #X && #B.X + #B.W <= #X + #W)

			&&

			(#Y >= #B.Y && #Y <= #B.Y + #B.H ||
			#B.Y >= #Y && #B.Y <= #Y + #H ||
			#Y + #H >= #B.Y && #Y + #H <= #B.Y + #B.H ||
			#B.Y + #B.H >= #Y && #B.Y + #B.H <= #Y + #H);
}

//get which side of the rectangle the collision occured on, should only be used if a collision occured
//used by breakoutblock to determine the variables to use in determining the ball's new velocity
function string CollisionSide(BreakoutObject B)
{
	local string ret;

	if(!IsColliding(B))
		ret="NONE";
	else if(#B.X + #B.W >= #X && #B.PX + #B.W < #X)
		ret="LEFT";
	else if(#B.X <= #X + #W && #B.PX > #X + #W)
		ret="RIGHT";
	else if(#B.Y + #B.H >= #Y && #B.PY + #B.H < #Y)
		ret="TOP";
	else if(#B.Y <= #Y + #H && #B.PY > #Y + #H)
		ret="BOTTOM";

	return ret;
}

//allows subclass handle collisions (had debugging stuff iirc)
function Collide(BreakoutObject other)
{
	return;
}

//allows subclass to initialize its shit after being integrated
function Init()
{
	return;
}

//immutable function to make sure the board is set and init is called during integration
final function BoardInit(BreakoutBoard b)
{
	board=b;
	Init();
	return;
}

//handle any removal animation or cleanup in the subclass
function PostKill()
{
	return;
}

//flag the object for removal, enable the removetimer and call PostKill
function Kill()
{
	if(bRemove) //you can't kill me, I'm already dead!
		return;
	removeTimer=removeTimerAmt;
	bRemove=true;
	PostKill();
	return;
}

defaultproperties
{
     bVisible=True
     bStatic=True
     DrawTexture=Texture'Extension.Solid'
     DrawColor=(R=255,G=255,B=255)
     drawStyle=DSTY_Normal
}
