class BreakoutPaddle extends BreakoutObject;

#exec TEXTURE IMPORT NAME=BreakoutPaddle FILE=Textures\BreakoutPaddle.pcx GROUP=UI MIPS=OFF FLAGS=2 LODSET=2

var BreakoutBall 	ball;
var float		ballOffsetX,
			ballOffsetY;
var bool		bHasBall;

var float		baseW;

var bool		bInvert,
			bMagnet;
var float		TimeLeftInvert;



function SetBallVelocityNormal(BreakoutBall B)
{
	local float dst, tmp;
	dst = X + W/2 - B.X - B.W/2;
	tmp = FClamp(abs(dst) / (W/2), 0.15, 0.75);
	if(dst>0)
		tmp=-tmp;
	B.VX=tmp;
	B.VY=-sqrt(1-tmp*tmp);
}

function PostUpdate(float deltaTime)
{
	VX=0;
	if(board.IsKeyDown(IK_Left) || board.IsKeyDown(IK_A))
		VX-=1;
	if(board.IsKeyDown(IK_Right) || board.IsKeyDown(IK_D))	
		VX+=1;

	if(bInvert)
	{
		TimeLeftInvert-=deltaTime/100;
		VX=-VX;

		if(TimeLeftInvert<=0)
			bInvert=false;
	}

	if(bHasBall)
	{
		ball.X=ballOffsetX+X;
		ball.Y=ballOffsetY+Y;
		if(board.IsKeyDown(IK_Space))
		{
			SetBallVelocityNormal(ball);
			ball.launch();
			bHasBall=false;
		}
	}
}

function GetBall(BreakoutBall b)
{
	ball=b;
	ball.dock();
	ball.VS=VS;
	ballOffsetX=ball.X-X;
	ballOffsetY=ball.Y-Y;
	bHasBall=true;
}

function Collide(BreakoutObject other)
{
	if(other.IsA('BreakoutBall'))
	{
		other.Y=min(other.Y,Y-other.H-2);
		if(bMagnet && !bHasBall)
			GetBall(BreakoutBall(other));
		else
			SetBallVelocityNormal(BreakoutBall(other));
	}
}

function DrawOverride(GC gc, int dX, int dY, int dW, int dH, int oX, int oY, int oU, int oV, Texture tex)
{
	gc.DrawStretchedTexture(dX-1,dY,dW+2,dH,oX+4,oY+2,oU-6,oV-3,tex);
}

function PowerUp(string power)
{
	switch(power)
	{
	case "SPLIT":
	case "FAST":
	case "SLOW":
	case "KILLER":
	case "SUPERKILLER":
		board.PowerUpBalls(power);
		break;

	case "INVERT":
		bInvert=true;
		TimeLeftInvert=10.0;
		break;

	case "GROW":
		if(W<baseW*2)
		{
			if(W<baseW)
			{
				X=max(X-(baseW-W)/2,1);
				W=baseW;
				if(X+W>board.width-2)
					X=board.width-2-w;
			}
			else
			{
				X=max(X-baseW/4,1);
				W+=baseW/2;
				if(X+W>board.width-2)
					X=board.width-2-w;
			}
		}
		break;

	case "SHRINK":
		if(W>baseW/2)
		{
			if(W>baseW)
			{
				X+=(W-baseW)/2;
				W=baseW;
			}
			else
			{
				X+=W/8;
				W-=W/4;
			}
		}
		break;

	case "MAGNET":
		bMagnet=true;
		break;

	case "SKIP":
		board.NextLevel();
		break;

	case "1UP":
		board.gameLives++;
		break;
	}

	switch(power)
	{
	case "SPLIT":
	case "SLOW":
	case "KILLER":
	case "SUPERKILLER":
	case "MAGNET":
	case "SKIP":
		board.PlaySound(Sound'BreakoutPowerUpGood', 1.0);
		break;

	case "INVERT":
	case "FAST":
		board.PlaySound(Sound'BreakoutPowerUpBad', 1.0);
		break;

	case "GROW":
		board.PlaySound(Sound'BreakoutGrowPaddle', 1.0);
		break;

	case "SHRINK":
		board.PlaySound(Sound'BreakoutShrinkPaddle', 1.0);
		break;

	case "1UP":
		board.PlaySound(Sound'BreakoutExtraLife', 1.0);
		break;
	}
}

function Init()
{
	baseW=W;
}

function BallFell()
{
	W=baseW;
	bInvert=false;
	bMagnet=false;
}

function float GetScoreMultiplier()
{
	local float base;
	base=1.0;
	if(bMagnet)
		base*=0.75;
	if(bInvert)
		base*=1.5;
	if(W<=baseW*0.5)
		base*=1.5;
	if(W<=baseW*0.75)
		base*=1.5;
	if(W>=baseW*1.5)
		base*=0.75;
	if(W>=baseW*2.0)
		base*=0.75;
	return base;
}

defaultproperties
{
     bStatic=False
     bMoving=True
     bCollidable=True
     DrawTexture=Texture'TNMGUI.UI.BreakoutPaddle'
     DrawColor=(R=192,G=192,B=192)
     drawStyle=DSTY_Masked
     bOverrideTextureDraw=True
     W=56.000000
     H=14.000000
     VS=4.000000
}
