class BreakoutPowerup extends BreakoutObject;

#exec TEXTURE IMPORT NAME=BreakoutPowerup FILE=Textures\BreakoutPowerup.pcx GROUP=UI MIPS=OFF FLAGS=2 LODSET=2

var string		power;

var string		letter;
var Color		letterColor;
var Font		letterFont;

function PostDraw(GC gc)
{
	gc.SetStyle(DSTY_Normal);
	gc.SetFont(letterFont);
	gc.SetTextColor(letterColor);
	gc.DrawText(W/3+X,H/5+Y,W,H,letter);
}

function Collide(BreakoutObject other)
{
	if(other.IsA('BreakoutPaddle'))
	{
		BreakoutPaddle(other).PowerUp(power);
		Kill();
		return;
	}
	
	if(other.IsA('BreakoutWall'))
		Kill();
}

defaultproperties
{
     letterFont=Font'DeusExUI.FontConversationLargeBold'
     bStatic=False
     bMoving=True
     bCollidable=True
     DrawTexture=Texture'TNMGUI.UI.BreakoutPowerup'
     drawStyle=DSTY_Masked
     W=28.000000
     H=28.000000
     VY=1.000000
     VS=2.250000
}
