class BreakoutWall extends BreakoutObject;

var string wallType;

function Init()
{
	if(wallType=="TOP")
	{
		X=0;
		Y=0;
		W=board.width;
		H=1;
	}
	else if(wallType=="BOTTOM")
	{
		X=0;
		Y=board.height-1;
		W=board.width;
		H=1;
	}
	else if(wallType=="LEFT")
	{
		X=0;
		Y=0;
		W=1;
		H=board.height-1;
	}
	else if(wallType=="RIGHT")
	{
		X=board.width-1;
		Y=0;
		W=1;
		H=board.height-1;
	}
	else
		Kill();
}

function bool IsColliding(BreakoutObject B)
{
	switch(wallType)
	{
	case "TOP":
		return B.Y<=Y;
		break;
	case "BOTTOM":
		return B.Y+B.H>=Y;
		break;
	case "LEFT":
		return B.X<=X;
		break;
	case "RIGHT":
		return B.X+B.W>=X;
		break;
	}
	return false;
}

function DrawOverride(GC gc, int dX, int dY, int dW, int dH, int oX, int oY, int oU, int oV, Texture tex)
{
	if(board.bRunning)
		gc.SetTileColorRGB(255,255,255);
	else
		gc.SetTileColorRGB(64,64,64);
	super.DrawOverride(gc,dX,dY,dW,dH,oX,oY,oU,oV,tex);
}

defaultproperties
{
     bCollidable=True
}
