class ConsoleInputWindow extends MenuUIEditWindow;

var LinkedList history;
var LinkedListNode cur;

event InitWindow()
{
	super.InitWindow();
	history=new(None) class'LinkedList';
}

function PushHistory(string s)
{
	local IRCHistory h; //so lame that structs can't be pointers. SO LAME.
	h=new(None) class'IRCHistory';
	h.content=s;
	history.add(h);
	cur=none;
}

event bool VirtualKeyPressed(EInputKey key, bool bRepeat)
{
	local LinkedListNode n;

	if (key == IK_Up)
	{
		if(cur==None)
			cur=history.last;
		else
			cur=cur.prev;

		if(cur!=None)
			SetText(IRCHistory(cur.data).content);

		key=IK_End;
	}
	else if (key == IK_Down)
	{
		if(cur!=None)
			cur=cur.next;

		if(cur!=None)
			SetText(IRCHistory(cur.data).content);
		else
			SetText("");

		key=IK_End;
	}

	return Super.VirtualKeyPressed(key, bRepeat);

}

defaultproperties
{
}
