class FakeIRCInterface extends TextConsoleIRCInterface;

var bool bBanned;
var string def_users[32];
var string def_prefixes[32];

function bool Parse(string command, string args[256], int argc, string raw_text, string raw_args)
{
	ConsoleMessage("Input parser disabled, unable to parse text.");
	return true;
}

function Init(TextConsole c)
{
	super.init(c);
	GenerateUsers();
	Connect();
}

function GenerateUsers()
{
	local IRCUser u;
	local int i;
	for(i=0;def_users[i]!=""&&i<32;i++)
	{
		u=new(None) class'IRCUser';
		u.name=def_users[i];
		u.prefix=def_prefixes[i];
		users.add(u);
	}
}

function bool AttemptConnect()
{
	if(bBanned)
	{
		ConsoleMessage("* Unable to resolve connection.");
		bNoRetry=true;
		return false;
	}
	return true;
}

function bool JoinChannel()
{
	if(!bBanned)
	{
		bInChannel=true;
		return true;
	}
	ConsoleMessage("Unable to rejoin"@channel$". Address is banned.");
	return false;
}

function string GetTopic()
{
	return "We need dedicated new texture artists and mappers! || FORGET ABOUT RADISHES FOR NOW";
}

function string GetTopicUser()
{
	return "Jonas (~jonaswaever@external.sweden.nowait.denmark.node522)";
}

function string GetTopicTime()
{
	local int hour,minute;
	if(!class'tnmTime'.static.IsEnabled())
		return "unknown time";

	hour=class'tnmTime'.static.GetHour();
	minute=class'tnmTime'.static.GetMinute()-rand(4)-1;
	if(minute<0)
	{
		hour--;
		minute+=60;
	}

	return
		left(class'tnmTime'.static.GetDayOfWeekStr(),3)
		@ left(class'tnmTime'.static.GetMonthStr(),3)
		@ class'tnmTime'.static.GetDate()
		@ right("0"$hour,2)$":"
		$ right("0"$minute,2)$":"
		$ right("0"$rand(60),2);
}

function string GetChannelModes()
{
	return "+mnt";
}

function OpPhas()
{
	local LinkedListNode n;
	local IRCUser u;

	SetMode("ChanServ","+h Phasmatis");

	for(n=users.first;n!=None;n=n.next)
	{
		u=IRCUser(n.data);
		if(u.name=="Phasmatis")
		{
			u.prefix="%";
			break;
		}
	}
	RebuildUsers();
}

defaultproperties
{
     def_users(0)="Jonas"
     def_users(1)="Lawrence"
     def_users(2)="Chris"
     def_users(3)="Gelo"
     def_users(4)="Jim"
     def_users(5)="LeoBad"
     def_users(6)="Nicholas"
     def_users(7)="Phasmatis"
     def_users(8)="Shane"
     def_prefixes(0)="@"
     def_prefixes(1)="@"
     def_prefixes(2)="%"
     def_prefixes(3)="%"
     def_prefixes(4)="%"
     def_prefixes(5)="%"
     def_prefixes(6)="%"
     def_prefixes(7)="%"
     def_prefixes(8)="%"
     Nick="Trestkon"
     Server="narcissus://external.chat.node0"
     Channel="#offtopicproductions"
}
