class HUDVendingMachineButton expands ButtonWindow;

var DeusExPlayer player;

// Border and Background Translucency
var bool bBorderTranslucent;
var bool bBackgroundTranslucent;
var bool bDrawBorder;

// Default Colors
var Color colBackground;
var Color colBorder;
var Color colHeaderText;
var Color colSensitive;
var Color colInsensitive;

var int index;

var Texture keypadButtonTextures[2];

var Texture ItemIcon;

// ----------------------------------------------------------------------
// InitWindow()
//
// Responsible for creating the various and sundry sub-windows for
// the keypad popup.
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();
	
	SetSize(32, 32);

	// Get a pointer to the player
	player = DeusExPlayer(GetRootWindow().parentPawn);

	StyleChanged();
}

// ----------------------------------------------------------------------
// DrawWindow()
// ----------------------------------------------------------------------

event DrawWindow(GC gc)
{
	gc.SetStyle(DSTY_Masked);
	gc.DrawStretchedTexture(3,3,width,height,0,0,48,48,ItemIcon);
	gc.SetStyle(DSTY_Translucent);
	if (bButtonPressed) //+1 to prevent a minor graphical error when the button clips something
		gc.DrawStretchedTexture(0,0, 32, 32, 0, 0, 25+1, 27+1, keypadButtonTextures[0]);
	else
		gc.DrawStretchedTexture(0,0, 32, 32, 0, 0, 25+1, 27+1, keypadButtonTextures[1]);		

	// Display darker if the button's insensitive
	if (bIsSensitive)
		gc.SetTextColor(colSensitive);
	else
		gc.SetTextColor(colInsensitive);
}

// ----------------------------------------------------------------------
// StyleChanged()
// ----------------------------------------------------------------------

event StyleChanged()
{
	local ColorTheme theme;

	theme = player.ThemeManager.GetCurrentHUDColorTheme();

	colBackground = theme.GetColorFromName('HUDColor_Background');

	bBorderTranslucent     = player.GetHUDBorderTranslucency();
	bBackgroundTranslucent = player.GetHUDBackgroundTranslucency();
	bDrawBorder            = player.GetHUDBordersVisible();
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     colSensitive=(R=255,G=255,B=255)
     colInsensitive=(R=64,G=64,B=64)
     keypadButtonTextures(0)=Texture'DeusExUI.UserInterface.HUDKeypadButton_Normal'
     keypadButtonTextures(1)=Texture'DeusExUI.UserInterface.HUDKeypadButton_Pressed'
}
