class HUDVendingMachineWindow extends ComputerUIWindow;

#exec TEXTURE IMPORT NAME=TNMVendingMenu01 FILE=Textures\TNMVendingMenu01.pcx GROUP=UI MIPS=OFF LODSET=2
#exec TEXTURE IMPORT NAME=TNMVendingMenu02 FILE=Textures\TNMVendingMenu02.pcx GROUP=UI MIPS=OFF LODSET=2
#exec TEXTURE IMPORT NAME=TNMVendingMenu03 FILE=Textures\TNMVendingMenu03.pcx GROUP=UI MIPS=OFF LODSET=2
#exec TEXTURE IMPORT NAME=TNMVendingMenu04 FILE=Textures\TNMVendingMenu04.pcx GROUP=UI MIPS=OFF LODSET=2
#exec TEXTURE IMPORT NAME=TNMVendingMenu05 FILE=Textures\TNMVendingMenu05.pcx GROUP=UI MIPS=OFF LODSET=2
#exec TEXTURE IMPORT NAME=TNMVendingMenu06 FILE=Textures\TNMVendingMenu06.pcx GROUP=UI MIPS=OFF LODSET=2

var int CurrentSelection;

//var string Description;

var MenuUIActionButtonWindow CloseButton;
var MenuUIActionButtonWindow PurchaseButton;

var TNMVendingMachine machine;

var MenuUISmallLabelWindow ItemNameWindow;
var MenuUISmallLabelWindow ItemCostWindow;

var MenuUISmallLabelWindow PlayerCreditsWindow;

//todo: let the user resort with sort buttons
var bool bSortByName;
var bool bSortByCost;

//------------------------
//item list stuff
//------------------------
var MenuUIListWindow             lstItems; //scrollable list of items and prices
//var ClipWindow 			 lstItemsClipWin; //scrollable area for lstItems, used for the buttons.
//var ModalWindow			lstItemsClipWin;
var TabGroupWindow		 lstItemsClipWin; //clip window for some reason only displays one child
//modal window would work but it crashes when being destroyed, but TabGroupWindow works for some reason
//not sure if any functionality is lost in not using ModalWindow, but TabGroupWindow _seems_ to work
//------------------------

var Window  winItemDesc; //scrollable description of item
var bool bScrollDescText; //scroll through the description? (like a datalink)
//it's a nice effect but if it's not functional enough
//set the bool to false and it'll use a normal TextWindow instead

var MenuUIListHeaderButtonWindow btnItemName; //sort by name
var MenuUIListHeaderButtonWindow btnItemCost; //sort by cost

var localized String ButtonLabelClose;
var localized String ButtonLabelPurchase;

var bool bCheckStatus; //for the status bar
var float durLeft;

var Window ItemIconWindow; //current icon display

//for ease of configuration:
//if listFont is set to something smaller
//you'll be able to fit 10 entries without a scroll bar easily
//though you'll need to adjust the button alignment as it's
//hardcoded
var Font listFont;
var Font descFont;
var Font descFont2;

var bool bThrottle;
var bool bSpaceDown;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();
	bTickEnabled=true;
}

//CreateControls() does pretty much all of the GUI setup
//with the exception of populating lstItems
//and adding HUDVendingMachineButtons to winItemsClipWin

function CreateControls()
{
	local MenuUIScrollAreaWindow winScroll;
	local MenuUILabelWindow newLabel;
	local TextWindow txt;
	local ComputerWindow cmp;
	Super.CreateControls();

	CloseButton = winButtonBar.AddButton(ButtonLabelClose, HALIGN_Right);
	PurchaseButton  = winButtonBar.AddButton(ButtonLabelPurchase,  HALIGN_Right);

	winScroll = CreateScrollAreaWindow(winClient); //this is the big display win
	winScroll.SetPos(5-4/*+48*/, 60-30-1); //it's scrollable and holds the item list and the buttons
	winScroll.SetSize(/*285+78+5*//*310+78-10+20*/400+3, 350); //as there's no convenient way to use windows in ListWindow
	winScroll.AutoHideScrollbars(false);

	lstItemsClipWin = TabGroupWindow(winScroll.clipWindow.NewChild(Class'TabGroupWindow'));
	lstItemsClipWin.bSizeParentToChildren=true;
	lstItemsClipWin.bSizeChildrenToParent=false;

	lstItems = MenuUIListWindow(lstItemsClipWin.NewChild(Class'MenuUIListWindow'));

	/*
	 * a lot of these width, height and pos vars were found via a rather inefficient
	 * system of trial and error, thus the horrible added and subtracted vals
	 * I blame the completely undocumented and largely native gui code
	 * for the messiness :p
	 * 
	 * if you want to streamline these my advice would be to make a test window that logs
	 * coordinates on click and use those vals, but these are all (believe it or not) 
	 * aligned properly
	 * 
	 * NVShacker 9/24/06
	 */

	lstItems.SetSize(/*285+78-59+5*//*300+20+24*/330, 550); //product name and price list
	lstItems.SetPos(11+48-5, /*60*/0);

	lstItems.fontText=Font'FontMenuExtraLarge';
	lstItems.InitWindow(); //reinit the window to set the font

	lstItems.EnableMultiSelect(False);
	lstItems.EnableAutoExpandColumns(False);
	lstItems.EnableHotKeys(False);
	lstItems.SetNumColumns(3); //3rd col is index

	lstItems.SetColumnWidth(0, /*200+20+9*/230);
	lstItems.SetColumnWidth(1, /*80+20+15*/100);
	lstItems.SetColumnAlignment(1, HALIGN_Right);
	lstItems.SetSortColumn(0, bSortByName);
	lstItems.HideColumn(2);
	lstItems.SetColumnType(2, COLTYPE_Float);
	lstItems.SetFieldMargins(4, 10);

	winScroll = CreateScrollAreaWindow(winClient); //scroll area for the description window
	winScroll.SetPos(305+78+30, 60);
	winScroll.SetSize(340-30+25, 320);

	if(bScrollDescText)
	{
		winItemDesc = winScroll.ClipWindow.NewChild(Class'ComputerWindow');
		cmp = ComputerWindow(winItemDesc);
		cmp.SetTextSize(37, 8);
		cmp.SetTextFont(descFont2, 8, 40, player.ThemeManager.GetCurrentMenuColorTheme().GetColorFromName('MenuColor_ListText'));
		cmp.SetTextTiming(0.02);
		cmp.SetFadeSpeed(0.75);
		cmp.EnableWordWrap(true);
	}
	else
	{
		winItemDesc = winScroll.ClipWindow.NewChild(Class'MenuUINormalLargeTextWindow');
		txt=TextWindow(winItemDesc);
		txt.SetTextMargins(4, 1);
		txt.SetWordWrap(True);
		txt.SetTextAlignments(HALIGN_Left, VALIGN_Top);
		txt.setFont(descFont);
	}

	PlayerCreditsWindow = CreateSmallMenuLabel(15, 5, "Credits:"@"c"$player.Credits, winClient);
	PlayerCreditsWindow.setFont(descFont);

	newLabel = CreateMenuLabel(310+78+30, 25+1, "Name:", winClient); //name and cost labels
	newLabel.setFont(descFont);

	newLabel = CreateMenuLabel(310+78+30, 39+1, "Cost:", winClient);
	newLabel.setFont(descFont);

	ItemIconWindow = NewChild(Class'Window'); //current item icon display
	ItemIconWindow.SetPos(/*395+64+78*/688, 39);     //texture artist should note these coords
	ItemIconWindow.SetWidth(64);		  //as it'd be ideal to have a box area in the texture for the icon
	ItemIconWindow.setBackgroundStyle(DSTY_Masked);

	ItemNameWindow    = CreateSmallMenuLabel( 350+78+30+20, 25, "", winClient);	//dummy labels for displaying cur sel
	ItemNameWindow.setFont(descFont);						//name and cost, these aren't appended
	ItemCostWindow      = CreateSmallMenuLabel(350+78+30+20, 39, "", winClient);	//to the labels so they can be aligned
	ItemCostWindow.setFont(descFont);		      				//like so:

	/***
		Item:	Name
		Price:  Price
		(Note: "Name" and "Cost" which are the actual labels used are the same length
		but the font isn't fixed with)
	***/
}

//this differs in usage slightly from design specs
//because TNMVendingMachine now subclasses Computers
//to use NetworkTerminalVendingMachine
//this gives more extensibility and lets this class inherit from ComputerUIWindow
//init's functionality is still the same, however.
//it populates lstItems and adds the clickable buttons (32x32 scaled belticons)

function init(TNMVendingMachine inMachine)
{
	local int i;
	local HUDVendingMachineButton btn;

	machine = inMachine;

	for ( i = 0; i < 10 && machine.Products[i].DispensedClass != none; i++)
	{
		AddItem(machine.Products[i].DispensedClass, machine.Products[i].Cost, i);
		//make the clickable icon
		btn=HUDVendingMachineButton(lstItemsClipWin.NewChild(Class'HUDVendingMachineButton', False));
		btn.SetPos(18, 8+i*49);
		btn.ItemIcon=machine.Products[i].DispensedClass.Default.Icon;
		btn.index=i;
		btn.Show();
	}

	Title = machine.Description;
	if(Title!="")
		winTitle.titleText=Title;

	lstItems.setHeight(i*50);
	SelectIndex(0);
}

//just a quick inline type function
function AddItem(class<inventory> product, int cost, int index)
{
	lstItems.AddRow( GetName(product) $ ";c" $ cost $ ";" $ index );
}

//hack
//gets the ItemName for the inventory item in question
//with a case by case override for long names
function string GetName(class<inventory> product)
{
	if(ClassIsChildOf(product, Class'WeaponLAM'))
		return "LAM";
	if(ClassIsChildOf(product, Class'WeaponEMPGrenade'))
		return "EMP Grenade";
	if(ClassIsChildOf(product, Class'WeaponMod')) //cuts out the mod name in parentheses
		return mid(product.Default.ItemName, instr(product.Default.ItemName, "(")+1,
			len(product.Default.ItemName)-instr(product.Default.ItemName, "(")-2) @ "Mod";
	return product.Default.ItemName;
}

//when the terminal is set, call init on our vending machine
//getting it from the terminal
//(it's called AFTER CreateControls, thus you can't get the machine from within there)

function SetNetworkTerminal(NetworkTerminal newTerm)
{
	Super.SetNetworkTerminal(newTerm);
	init(TNMVendingMachine(NetworkTerminalVendingMachine(winTerm).CompOwner));

	//special options would be easy to add
	//as well as hacking if they were so desired
/*	if (winTerm.AreSpecialOptionsAvailable())
	{
		btnSpecial = winButtonBar.AddButton(ButtonLabelSpecial, HALIGN_Left);
		CreateLeftEdgeWindow();
	}*/
	return;
}

//selects given index
//setfocusrow is probably the only call needed in actuality
//was just attempting to highlight a col

function SelectIndex(int inIndex)
{
	//unfortunately there is no SetCol, so the little highlight around the item name can't be made
	lstItems.SetRow(lstItems.IndexToRowId(inIndex), True);
	lstItems.SetFocusRow(lstItems.IndexToRowId(inIndex), True);
	lstItems.ShowFocusRow();
}

//updates description, name, cost and icon with selection change

event bool ListSelectionChanged(window list, int numSelections, int focusRowId)
{
	local int itemInfoIndex;

	local string tmp;
	local ComputerWindow comp;
	local int index;

	CurrentSelection = Int(lstItems.GetField(focusRowId, 2));

	ItemNameWindow.SetText(GetName(Machine.Products[CurrentSelection].DispensedClass));
	ItemCostWindow.SetText("c" $ Machine.Products[CurrentSelection].Cost);
	ItemIconWindow.SetBackground( Machine.Products[CurrentSelection].DispensedClass.Default.Icon );

	// Process the body
	if(bScrollDescText)
	{
		comp = ComputerWindow(winItemDesc);
		comp.ClearScreen();

		//this bit simply prints "------(vendingmachinedescription)------"
		//centered, it's just a bit of an odd way of doing it

		tmp="-";
		while(len(tmp)<comp.textCols)
			tmp = tmp $ tmp; //quickly build a string of "-" greater than comp.textCols
		tmp=left(tmp, comp.textCols); //truncate it into comp.textCols
		//get half of the "-" string minus half the description len
		//add the description string and the entire "-" string
		//and truncate it back into comp.textCols length, centering the string
//		log(comp.textCols);
//		comp.print(left(left(tmp, (len(tmp)-len(title))/2) $ title $ tmp, comp.textCols-1), true);

		tmp=Machine.Products[CurrentSelection].DispensedClass.Default.Description;
		comp.textRows=len(tmp)/comp.textCols+4;
		comp.SetTextSize(comp.textCols,comp.textRows);
		index=InStr(tmp, "|n");
		while(index!=-1)
		{
			comp.textRows++;
			comp.SetTextSize(comp.textCols,comp.textRows);
			comp.Print(left(tmp, index), true);
			tmp=right(tmp, len(tmp)-index-2);
			index=InStr(tmp, "|n");
		}
		comp.Print(tmp);
	}
	else
		TextWindow(winItemDesc).SetText(Machine.Products[CurrentSelection].DispensedClass.Default.Description);
}

//try to buy the item selected

function AttemptPurchase() 
{
	local string tmp;
	if ( player.Credits >= machine.Products[CurrentSelection].Cost )
	{
		player.Credits -= machine.Products[CurrentSelection].Cost;
		machine.SpawnProduct(CurrentSelection);
		tmp = machine.Products[CurrentSelection].DispensedClass.Default.ItemName
		@ "purchased."
		@ "c"
		$ String(machine.Products[CurrentSelection].Cost)
		@ "deducted.";
		StatusMessage(tmp, 3.0);
		PlayerCreditsWindow.SetText("Credits:"@"c"$player.Credits);
	}
	else
	{
		//Play a sound?
		tmp = "Not enough credits for"
		@ "c"
		$ String(machine.Products[CurrentSelection].Cost)
		@ machine.Products[CurrentSelection].DispensedClass.Default.ItemName
		$ ". You need"
		@ (machine.Products[CurrentSelection].Cost - player.Credits)
		@ "more credits.";
		StatusMessage(tmp, 3.0);
	}	
}

//just updates text color
event StyleChanged()
{
	super.StyleChanged();
	if(bScrollDescText)
		ComputerWindow(winItemDesc).SetTextFont(descFont2, 8, 20,
			player.ThemeManager.GetCurrentMenuColorTheme().GetColorFromName('MenuColor_ListText'));
}

//shows msg for duration secs then clears the status display
//also sends the player msg

function StatusMessage(string msg, float duration)
{
	//statustextbox is fubar for some reason
	//instead its functionality is coded into the window
	winStatus.SetText(msg);
	durLeft=duration;
	bCheckStatus=true;
	player.ClientMessage(msg);
}

//handles the buttons presses
//purchasebutton -> AttemptPurchase
//closebutton -> closescreen
//any HUDVendingMachineButton -> select its index

function bool ButtonActivated( Window buttonPressed )
{
	local HUDVendingMachineButton button;

	if (ButtonPressed == PurchaseButton)
	{
		AttemptPurchase();
		return true;
	}
	else if(ButtonPressed == CloseButton)
	{
		CloseScreen("LOGOUT");
		return true;
	}
	else
	{
		button = HUDVendingMachineButton(buttonpressed);
		if (button != none)
		{
			SelectIndex(button.index);
			return true;
		}
	}
		
	return Super.ButtonActivated(buttonPressed);
}

//this is another hacked function
//it intercepts setcompowner so it can
//safely set winStatus to a null string
//and change its fonts, preparing it for
//use as the status bar

function SetCompOwner(ElectronicDevices newCompOwner)
{
	compOwner = newCompOwner;

	if (winStatus != None)
	{
		winStatus.SetText("");
		winStatus.SetFont(Font'FontLocation');
	}
}

//clears the status bar if its
//duration has been exceeded
//(added)also handles spacebar throttle behavior

function Tick(float deltaTime)
{
	if(bCheckStatus)
	{
		durLeft-=deltaTime;
		if(durLeft <= 0)
		{
			winStatus.SetText("");
			bCheckStatus=false;
		}
	}

	if(!bScrollDescText)
		return;

	if(!bSpaceDown && IsKeyDown(IK_Space))
	{
		ThrottleUp();
		bSpaceDown=true;
	}
	else if(bSpaceDown && !IsKeyDown(IK_Space))
	{
		ThrottleDown();
		bSpaceDown=false;
	}
}

function ThrottleUp()
{
	if(!bScrollDescText)
		return;
	if(!bThrottle)
	{
		bThrottle=true;
		ComputerWindow(winItemDesc).SetThrottle(5.0);
	}
}

function ThrottleDown()
{
	if(!bScrollDescText)
		return;
	if(bThrottle)
	{
		bThrottle=false;
		ComputerWindow(winItemDesc).ResetThrottle();
	}
}

//if user clicks the description window, speed up its display
event bool MouseButtonPressed(float pointX, float pointY, EInputKey button,
                              int numClicks)
{
	local float relX, relY;
	ConvertCoordinates(Self, pointX, pointY, winItemDesc, relX, relY);
	if(button == IK_LeftMouse && winItemDesc.IsPointInWindow(relX, relY))
	{
		ThrottleUp();
		return true;
	}
	return super.MouseButtonPressed(pointx, pointy, button, numClicks);  // don't handle
}

//if user is throttling and lets go, go to normal speed
event bool MouseButtonReleased(float pointX, float pointY, EInputKey button,
                               int numClicks)
{
	if(button == IK_LeftMouse && bThrottle)
	{
		ThrottleDown();
		return true;
	}
	return super.MouseButtonReleased(pointx, pointy, button, numClicks);  // don't handle
}

function ShowStatus(String statusMessage)
{
	return; //hack
}

defaultproperties
{
     bSortByName=True
     bScrollDescText=True
     ButtonLabelClose="|&Close"
     ButtonLabelPurchase="|&Purchase"
     listFont=Font'DeusExUI.FontMenuExtraLarge'
     descFont=Font'DeusExUI.FontLocation'
     descFont2=Font'DeusExUI.FontFixedWidthSmall_DS'
     escapeAction="LOGOUT"
     Title="Vending Machine"
     ClientWidth=768
     ClientHeight=412
     clientTextures(0)=Texture'TNMGUI.UI.TNMVendingMenu01'
     clientTextures(1)=Texture'TNMGUI.UI.TNMVendingMenu02'
     clientTextures(2)=Texture'TNMGUI.UI.TNMVendingMenu03'
     clientTextures(3)=Texture'TNMGUI.UI.TNMVendingMenu04'
     clientTextures(4)=Texture'TNMGUI.UI.TNMVendingMenu05'
     clientTextures(5)=Texture'TNMGUI.UI.TNMVendingMenu06'
     textureRows=2
     textureCols=3
     statusPosY=384
     defaultStatusLeftOffset=18
     ComputerNodeFunctionLabel="Login"
}
