class LightsOutButton extends ButtonWindow;

var Texture texNormal, texFocused;
var Color colOn, colOff;
var bool bOn;

event InitWindow()
{
	Super.InitWindow();
	StyleChanged();
}

event DrawWindow(GC gc)
{
	gc.SetStyle(DSTY_Normal);

	if(bOn)
		gc.SetTileColor(colOn);
	else
		gc.SetTileColor(colOff);

	if (bButtonPressed)
		gc.DrawStretchedTexture(0,0, width, height, 0, 0, /*25+1, 27+1,*/128,128, texNormal);
	else
		gc.DrawStretchedTexture(0,0, width, height, 0, 0, 128, 128, texFocused);
}

event StyleChanged()
{
	local ColorTheme theme;

	theme = DeusExPlayer(GetRootWindow().parentPawn).ThemeManager.GetCurrentMenuColorTheme();

	colOn = theme.GetColorFromName('MenuColor_ButtonTextNormal');
	colOff = theme.GetColorFromName('MenuColor_ButtonTextDisabled');

	while(colOn.R+colOn.G+colOn.B<128)
	{
		colOn.R=colOn.R*2+8;
		colOn.G=colOn.G*2+8;
		colOn.B=colOn.B*2+8;
	}

	if(colOff.R+colOff.G+colOff.B>96)
	{
		colOff.R=colOff.R*0.35;
		colOff.G=colOff.G*0.35;
		colOff.B=colOff.B*0.35;
	}

	if(colOff.R+colOff.G+colOff.B<64)
	{
		colOff.R=colOff.R+16;
		colOff.G=colOff.G+16;
		colOff.B=colOff.B+16;
	}
}

defaultproperties
{
     texNormal=Texture'TNMDeco.Skins.Button1_Grey_Blank'
     texFocused=Texture'TNMDeco.Skins.Button1_Grey_BlankA'
}
