class LightsOutWindow extends ComputerUIWindow;

var LightsOutButton 		buttons[36];

var MenuUIActionButtonWindow 	btnLogout;
var MenuUIActionButtonWindow 	btnReturn;

function CreateControls()
{
	local int row,col;

	super.CreateControls();

	btnReturn=winButtonBar.AddButton("|&Return", HALIGN_Right);
	btnLogout=winButtonBar.AddButton("|&Logout", HALIGN_Right);

	for(row=0;row<6;row++)
		for(col=0;col<6;col++)
		{
			buttons[row*6+col]=LightsOutButton(winClient.NewChild(Class'LightsOutButton'));
			buttons[row*6+col].SetSize(76,76);
			buttons[row*6+col].SetPos(col*78,row*78);
		}

	Generate();
}

function bool ButtonActivated( Window buttonPressed )
{
	local int i;

	for(i=0;i<36;i++)
		if(buttonPressed==buttons[i])
		{
			ToggleSurrounding(i);
			return true;
		}

	if(buttonPressed == btnLogout)
	{
		CloseScreen("LOGOUT");
		return true;
	}

	if(buttonPressed == btnReturn)
	{
		CloseScreen("RETURN");
		return true;
	}

	return super.ButtonActivated(buttonPressed);
}

function ToggleSurrounding(int i)
{
	local int row, col;
	row=i/6;
	col=i%6;
	Toggle(row,col);
	Toggle(row-1,col);
	Toggle(row+1,col);
	Toggle(row,col-1);
	Toggle(row,col+1);
	CheckVictory();
}

function Toggle(int row, int col)
{
	if(row>=0&&row<6 && col>=0&&col<6)
		buttons[row*6+col].bOn=!buttons[row*6+col].bOn;
}

function CheckVictory()
{
	local int i;

	for(i=0;i<36;i++)
		if(buttons[i].bOn)
			return;

	Victory();
}

function Victory()
{
	Trestkon(GetPlayerPawn()).GameHighScoreLightsOut++;
	Generate();
}

function Disqualify(out int choices[36],int row,int col)
{
	if(row>=0&&row<6&&col>=0&&col<6)
		choices[row*6+col]=-1;
}

function Generate()
{
	local int choices[36];
	local int on_count;
	local int row;
	local int col;
	local int i;

	on_count=4+rand(6);

	while(on_count>0)
	{
		row=rand(6);
		col=rand(6);
		if(choices[row*6+col]==0)
		{
			choices[row*6+col]=1;
			Disqualify(choices,row-1,col);
			Disqualify(choices,row+1,col);
			Disqualify(choices,row,col-1);
			Disqualify(choices,row,col+1);
			on_count--;
		}
	}

	for(i=0;i<36;i++)
		buttons[i].bOn=false;

	for(i=0;i<36;i++)
		if(choices[i]==1)
			ToggleSurrounding(i);
}

event InitWindow()
{
	Super.InitWindow();
	bTickEnabled=true;
}


function Tick(float deltaTime)
{
	Trestkon(GetPlayerPawn()).AddGameTimePlayed("LIGHTSOUT",deltaTime);
//	log(Trestkon(GetPlayerPawn()).GameTimePlayedLightsOut);
}

defaultproperties
{
     escapeAction="RETURN"
     Title="Lights Out"
     ClientWidth=466
     ClientHeight=466
     bUsesStatusWindow=False
     statusPosY=383
     ComputerNodeFunctionLabel="LightsOut"
}
