/******
Because I wanted to.
	NVShacker 4/12/07
*******/
class PongWindow extends ComputerUIWindow;

#exec new TrueTypeFontFactory Name="TestTrueTypeFont" FontName="Xenotron Broadstroke" Height=16 AntiAlias=1 XPad=2 CharactersPerPage=64 Chars="0123456789"

var MenuUIActionButtonWindow btnStart;
var MenuUIActionButtonWindow btnReturn;
var MenuUIActionButtonWindow btnLogout;
var MenuUISmallLabelWindow   lblPlayer1Score;
var MenuUISmallLabelWindow   lblPlayer2Score;

//lots of vars related to the pong game itself
var bool bStarted;

var float boardX;
var float boardY;
var float boardW;
var float boardH;

var float ballW;
var float ballH;
var float paddleW;
var float paddleH;

var float ballX;
var float ballY;
var float ballVX;
var float ballVY;
var float ballSpeed;

var float p1X;
var float p1Y;
var float p1speed;
var int   p1score;

var float p2X;
var float p2Y;
var float p2speed;
var int   p2score;

var float AIdest;
var bool  bAIsearch;

var float AI2dest;
var bool  bAI2search;

var bool  bDXStyle;
var bool  bAIonly;
var float AIspeed;

//referenced textures/sounds
var Texture drawTexture; //used for drawing plain white lines and boxes. woo
var Texture ballTexture;
var Texture paddleTexture;
var Sound   beepSound;
var Sound   boomSound;

event InitWindow()
{
	Super.InitWindow();
	bTickEnabled=true;
}

function SetNetworkTerminal(NetworkTerminal newTerm)
{
	winTerm = newTerm;
	if(!winTerm.IsA('tnmPongNetworkTerminal'))
		btnReturn=winButtonBar.AddButton("Return", HALIGN_Right);

	if(PongArcade(winTerm.CompOwner)!=None && PongArcade(winTerm.CompOwner).bAltGraphics)
		if(Trestkon(GetPlayerPawn()).FlagBase.GetBool('HAS_NVShackerProgram'))
			bDXStyle=true;
	SetupGame();
}

function CreateControls()
{
	Super.CreateControls();
	btnStart=winButtonBar.AddButton("S|&tart", HALIGN_Right);
	btnLogout=winButtonBar.AddButton("Logout", HALIGN_Right);

	lblPlayer1Score=CreateSmallMenuLabel( 40,  15, "0", winClient);
	lblPlayer2Score=CreateSmallMenuLabel( 595, 15, "0", winClient);

	lblPlayer1Score.SetFont(Font'TestTrueTypeFont');
	lblPlayer2Score.SetFont(Font'TestTrueTypeFont');
}

function SetCompOwner(ElectronicDevices newCompOwner)
{
	compOwner = newCompOwner;

	if (winStatus != None)
		winStatus.SetText("");
}

function StartGame()
{
	if(!bStarted)
		bStarted=true;
	SetupGame();
}

function SetupGame()
{
	if(bDXStyle)
	{
		ballW=Default.ballW*2;
		ballH=Default.ballH*2;
		paddleW=Default.paddleW*1.5;
		SetSoundVolume(0.5);
	}

	p1X=0;
	p1Y=boardH/2-paddleH/2;
	p2X=boardW-paddleW;
	p2Y=p1Y;

	p1score=0;
	p2score=0;
	lblPlayer1Score.SetText("0");
	lblPlayer2Score.SetText("0");

	AIdest  = p1Y;
	AI2dest = p2y;

	ResetBall();
}

function ResetBall()
{
	ballX=boardW/2-ballW;
	ballY=boardH/2-ballH;

	ballVX=FRand()*0.5+0.5;
	ballVY=sqrt(1-ballVX*ballVX);

	if(FRand()<0.5)
		ballVX=-ballVX;
	if(FRand()<0.5)
		ballVY=-ballVY;
	ballSpeed=1.5;

	bAIsearch  = true;
	bAI2search = true;
}

function Tick(float deltaTime)
{
	local float newX, newY, AItime1, AItime2, AIpos, AImult, tmp;
	local int AIfubar;
	local bool bUpdateBall;

	if(!bStarted)
		return;

	Trestkon(GetPlayerPawn()).GameTimePlayedPong+=deltaTime;

	deltaTime*=150; //semi-arbitrary speed factor

	//ai searches for dest
	if(bAIsearch)
	{
		if(ballVX<0)
		{
			AItime1=(paddleW-ballX)/ballVX; //get time to reach ai's side
			AIdest=ballY+ballVY*AItime1;
			AImult=1;
			AIpos=ballY;
			AIfubar=0;

			//loop through to project the final y velocity
			while((AIdest<0 || AIdest>boardH-paddleH) && AIfubar<10)
			{
				//find the collision
				if(AImult*ballVY<0)
				{
					AItime2=-AIpos/ballVY*AImult;
					AIpos=0;
				}
				else
				{
					AItime2=(boardH-AIpos)/ballVY*AImult;
					AIpos=boardH-ballH;
				}

				//alter the projection based on this location
				AItime1-=AItime2;
				AImult*=-1;
				AIdest=AIpos + ballVY * AItime1 *AImult;
				AIfubar++;
			}
			if(AIdest-paddleH/2>0) //center paddle
				AIdest-=paddleH/2;
		}
		if(AIfubar<10)
			bAIsearch=false;
//		else
//			log("warning: pong ai was unable to calculate ball destination. will retry next tick.");
	}
	else if(ballVX>0)
		AIdest=ballY;

	//ai approaches its dest
	p1speed=0;
	if(abs(p1Y-AIdest)>3)
	{
		if(p1Y>AIDest)
			p1speed=-AIspeed;
		else
			p1speed=AIspeed;
	}

	//paddle movement shit. ai
	newY=p1Y+p1speed*deltaTime;
	if(newY>=0 && newY<=boardH-paddleH)
		p1Y=newY;

	if(!bAIonly)
	{
		//player input
		if(IsKeyDown(IK_Up) || IsKeyDown(IK_W))
			p2speed=-3;
		else if(IsKeyDown(IK_Down) || IsKeyDown(IK_S))
			p2speed=3;
		else
			p2speed=0;
	
		//paddle movement shit. player
		newY=p2Y+p2speed*deltaTime;
		if(newY>=0 && newY<=boardH-paddleH)
			p2Y=newY;
	}
	else
	{
		//ai searches for dest
		if(bAI2search)
		{
			if(ballVX>0)
			{
				AItime1=(p2X-ballX)/ballVX; //get time to reach ai's side
				AI2dest=ballY+ballVY*AItime1;
				AImult=1;
				AIpos=ballY;
				AIfubar=0;
	
				//loop through to project the final y velocity
				while((AI2dest<0 || AI2dest>boardH-paddleH) && AIfubar<10)
				{
					//find the collision
					if(AImult*ballVY<0)
					{
						AItime2=-AIpos/ballVY*AImult;
						AIpos=0;
					}
					else
					{
						AItime2=(boardH-AIpos)/ballVY*AImult;
						AIpos=boardH-ballH;
					}
	
					//alter the projection based on this location
					AItime1-=AItime2;
					AImult*=-1;
					AIdest=AIpos + ballVY * AItime1 *AImult;
					AIfubar++;
				}
				if(AIdest-paddleH/2>0) //center paddle
					AIdest-=paddleH/2;
			}
			if(AIfubar<10)
				bAI2search=false;
		}
		else if(ballVX<0)
			AI2dest=ballY;
	
		//ai approaches its dest
		p2speed=0;
		if(abs(p2Y-AI2dest)>3)
		{
			if(p2Y>AI2Dest)
				p2speed=-AIspeed;
			else
				p2speed=AIspeed;
		}
	
		//paddle movement shit. ai
		newY=p2Y+p2speed*deltaTime;
		if(newY>=0 && newY<=boardH-paddleH)
			p2Y=newY;		
	}

	//default (non collision) ball behavior
	bUpdateBall=true;

	newX=ballX+ballVX*deltaTime*ballSpeed;
	newY=ballY+ballVY*deltaTime*ballSpeed;

	//collision detection
	if(newY<0 || newY+ballW>boardH)
	{
		ballVY=-ballVY;	
		if(bDXStyle)
			PlaySound(beepSound);
		if(ballVX<0)
			bAIsearch=true; //just to be thorough
		else
			bAI2search=true;
		bUpdateBall=false;
	}

	if(newX<=paddleW && newY<=p1Y+paddleH && newY+ballH>=p1Y)
	{
		ballX=paddleW+1;
		ballVX=-ballVX;
		ballSpeed*=1.1;
		bAI2search=true;
		if(bDXStyle)
			PlaySound(beepSound);
		bUpdateBall=false;
	}

	if(newX+ballW>=p2X && newY<=p2Y+paddleH && newY+ballH>=p2Y)
	{
		ballX=p2X-ballW-1;
		ballVX=-ballVX;
		ballSpeed*=1.1;
		bAIsearch=true;
		if(bDXStyle)
			PlaySound(beepSound);
		bUpdateBall=false;
	}

	//handles default behavior and collision for scoring
	if(bUpdateBall)
	{
		ballX=newX;
		ballY=newY;
		if(ballX<=0)
		{
			if(bDXStyle)
				PlaySound(boomSound);
			p2score++;
			if(Trestkon(player).GameHighScorePong<p2score)
				Trestkon(player).GameHighScorePong=p2score;
			lblPlayer2Score.SetText(""$p2score);
//			log(p2score);
			ResetBall();
		}
		else if(ballX+ballW>=boardW)
		{
			if(bDXStyle)
				PlaySound(boomSound);
			p1score++;
			lblPlayer1Score.SetText(""$p1score);
//			log(p1score);
			ResetBall();
		}
	}
}

event DrawWindow(GC gc)
{
	local float X1, X2, Y1, Y2, W;
	super.DrawWindow(gc);

	W=3;

	X1=boardX-W*2;
	X2=boardX+boardW+W;

	Y1=boardY-W*2;
	Y2=boardY+boardH+W;

	//border box
	gc.SetStyle		(DSTY_Normal);
	DrawVerticalLine	(GC, X1, Y1, Y2,   W);
	DrawVerticalLine	(GC, X2, Y1, Y2,   W);
	DrawHorizontalLine	(GC, Y1, X1, X2,   W);
	DrawHorizontalLine	(GC, Y2, X1, X2+W, W);

	//paddles and ball
	gc.SetStyle		(DSTY_Masked);
	if(bDXStyle)
	{
		DrawPaddle	(GC, p1X+boardX,   p1Y+boardY,   paddleW, paddleH);
		DrawPaddle	(GC, p2X+boardX,   p2Y+boardY,   paddleW, paddleH);
		DrawBall	(GC, ballX+boardX, ballY+boardY, ballW,   ballH  );
	}
	else
	{
		DrawRect	(GC, p1X+boardX,   p1Y+boardY,   paddleW, paddleH);
		DrawRect	(GC, p2X+boardX,   p2Y+boardY,   paddleW, paddleH);
		DrawRect	(GC, ballX+boardX, ballY+boardY, ballW,   ballH  );
	}
}

function DrawVerticalLine(GC gc, int x, int y1, int y2, float thickness)
{
	local int y,len;
	if(y1>y2)
	{
		len=y1-y2;
		y=y2;
	}
	else
	{
		len=y2-y1;
		y=y1;
	}
	gc.DrawStretchedTexture(x,y,thickness,len,0,0,8,8,drawTexture);
}

function DrawHorizontalLine(GC gc, int y, int x1, int x2, float thickness)
{
	local int x,len;
	if(x1>x2)
	{
		len=x1-x2;
		x=x2;
	}
	else
	{
		len=x2-x1;
		x=x1;
	}
	gc.DrawStretchedTexture(x,y,len,thickness,0,0,8,8,drawTexture);
}

function DrawRect(GC gc, float X, float Y, float W, float H)
{
	gc.DrawStretchedTexture(X,Y,W,H,0,0,8,8,drawTexture);
}

function DrawBall(GC gc, float X, float Y, float W, float H)
{
	gc.DrawStretchedTexture(X,Y,W,H,0,0,32,32,ballTexture);
}

function DrawPaddle(GC gc, float X, float Y, float W, float H)
{
	gc.DrawStretchedTexture(X,Y,W,H,0,0,64,128,paddleTexture);
}

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;

	bHandled = True;

	switch( buttonPressed )
	{
		case btnStart:
			StartGame();
			break;

		case btnReturn:
			CloseScreen("RETURN");
			break;

		case btnLogout:
			CloseScreen("LOGOUT");
			break;

		default:
			bHandled = False;
			break;
	}

	if (bHandled)
		return True;
	else
		return Super.ButtonActivated(buttonPressed);
}

event bool VirtualKeyPressed(EInputKey key, bool bRepeat)
{
	local bool bKeyHandled;

	bKeyHandled = True;

	switch(key)
	{
		case IK_T:
			btnStart.PressButton();
			break;

		//reserve keys that are checked in Tick
		case IK_Up:
		case IK_Down:
		case IK_W:
		case IK_S:
			bKeyHandled=!bAIonly;
			break;

		default:
			bKeyHandled = False;
			break;
	}

	if (!bKeyHandled)
		return Super.VirtualKeyPressed(key, bRepeat);
	else
		return bKeyHandled;
}

defaultproperties
{
     boardX=40.000000
     boardY=55.000000
     boardW=580.000000
     boardH=420.000000
     ballW=8.000000
     ballH=8.000000
     paddleW=12.000000
     paddleH=48.000000
     AIspeed=2.000000
     DrawTexture=Texture'Extension.Solid'
     ballTexture=Texture'DeusExUI.Icons.BeltIconLAM'
     paddleTexture=Texture'DeusExDeco.Skins.CrateUnbreakableSmallTex1'
     beepSound=Sound'DeusExSounds.Generic.Beep4'
     boomSound=Sound'DeusExSounds.Weapons.LAMExplode'
     escapeAction="RETURN"
     Title="Pong!"
     ClientWidth=640
     ClientHeight=480
     statusPosY=383
     ComputerNodeFunctionLabel="Pong"
}
