/****
For single texture resizable components used in ResizableWindows
	Shacker 3/22/07
*****/
class ResizableComponentWindow extends ResizableWindow;

var Texture		displayTexture;
var TextureRescale	displayTextureRescale;

function CalculateTextureOffsets()
{
	displayTextureRescale.old.X=0;
	displayTextureRescale.old.Y=0;
	displayTextureRescale.old.W=textureWidth;
	displayTextureRescale.old.H=textureHeight;

	displayTextureRescale.new.X=0;
	displayTextureRescale.new.Y=0;
	displayTextureRescale.new.W=textureWidth*scaleFactorX;
	displayTextureRescale.new.H=textureHeight*scaleFactorY;
}

event DrawWindow(GC gc)
{
	super.DrawWindow(gc);
	DrawScaledTexture(gc, displayTexture, displayTextureRescale);
}

defaultproperties
{
}
