/****
Window capable of being scaled dynamically capable of holding other ResizableWindows
	NVShacker 3/22/07
*****/
class ResizableControlWindow extends ResizableWindow;

//all background textures are assumed to be 256*256
//listed in such a fashion that
//	0 1 2
//	3 4 5
//would be {0, 1, 2, 3, 4, 5}
var Texture		backgroundTextures[16];
var TextureRescale	backgroundTextureRescales[16];

//rows*cols must be <= 16 or bad things will happen, should never be a problem
var int			backgroundTextureRows;
var int			backgroundTextureCols;

//overridden to rescale children
event ConfigurationChanged()
{
	super.ConfigurationChanged();
	AddTimer(0.01, false, , 'ResizeChildren'); //log spam prevention ftw
}

function ResizeChildren()
{
	local Window w;
	local ResizableWindow r;

	w=getBottomChild();
	while(w!=None)
	{
		r=ResizableWindow(w);
		if(r!=None)
			r.Resize(scaleFactorX, scaleFactorY);
		w=w.getHigherSibling();
	}
}

//for the record, coding this made me want to die -Nick
//stores background texture offsets so they don't need to be calculated every time DrawWindow is called
function CalculateTextureOffsets()
{
	//readability/sanity vars
	local int rows;
	local int cols;

	local float bgW;
	local float bgH;

	local int index;

	local TextureAlignment O;
	local TextureAlignment N;
	//----

	//logic vars
	local int r;
	local int c;
	//----

	//readability var init	
	rows=backgroundTextureRows;
	cols=backgroundTextureCols;

	bgW=textureWidth;
	bgH=textureHeight;
	//----

	for(c=0;c<cols;c++)
	{
		for(r=0;r<rows;r++)
		{
			index=rows*c+r;

			O=backgroundTextureRescales[index].old;
			N=backgroundTextureRescales[index].new;

			O.X=0;
			O.Y=0;
			O.W=min(bgW - 256 * r, 256);
			O.H=min(bgH - 256 * c, 256);

			N.X=256*r*scaleFactorX;
			N.Y=256*c*scaleFactorY;
			N.W=O.W * scaleFactorX;
			N.H=O.H * scaleFactorY;

			backgroundTextureRescales[index].old=O;
			backgroundTextureRescales[index].new=N;

			/*
			log("ResizableWindow row"@r@"col"@c);
			log("  O.X:"@O.X);
			log("  O.Y:"@O.Y);
			log("  O.W:"@O.W);
			log("  O.H:"@O.H);
			log("  N.X:"@N.X);
			log("  N.Y:"@N.Y);
			log("  N.W:"@N.W);
			log("  N.H:"@N.H);
			*/
		}
	}
}

function ResizableWindow AddScaledChild(Class<ResizableWindow> type)
{
	local ResizableWindow child;
	child=ResizableWindow(NewChild(type));
	if(child!=None)
		child.Resize(scaleFactorX, scaleFactorY);
	return child;
}

event DrawWindow(GC gc)
{
	local int i;
	super.DrawWindow(gc);
	for(i=0;i<16 && backgroundTextures[i]!=None;i++)
		DrawScaledTexture(gc, backgroundTextures[i], backgroundTextureRescales[i]);
}

defaultproperties
{
}
