/********
Moved from AIPuzzleGrid as it's pretty generic to improve readability/extensibility

Essentially works as a client window that can be resized to any resolution, resizing its background automatically and
offering a method to convert to/from relative coordinates
	NVShacker 3/21/07
*********/
class ResizableWindow extends Window
	abstract;

//structures for rescaling the bg tex to fit varying dimensions
struct TextureAlignment
{
	var float		X;
	var float		Y;
	var float		W;
	var float		H;	
};

struct TextureRescale
{
	var TextureAlignment	old;
	var TextureAlignment	new;
};

//component unscaled texture size
var float		textureWidth;
var float		textureHeight;

//scale difference factors
var float		scaleFactorX;
var float		scaleFactorY;

event ConfigurationChanged()
{
	CalculateScaleFactors();
	CalculateTextureOffsets();
}

function CalculateScaleFactors()
{
	scaleFactorX=width/textureWidth;
	scaleFactorY=height/textureHeight;
}

function Resize(float scaleX, float scaleY)
{
	scaleFactorX=scaleX;
	scaleFactorY=scaleY;
	SetSize(scaleFactorX*textureWidth, scaleFactorY*textureHeight);
	SetScaledPos(x,y);
}

function SetScaledPos(float X, float Y)
{
	ScaleCoordinates(X,Y);
	SetPos(X,Y);
}

function ScaleCoordinates(out float X, out float Y)
{
	X*=scaleFactorX;
	Y*=scaleFactorY;
}

function UnscaleCoordinates(out float X, out float Y)
{
	X/=scaleFactorX;
	Y/=scaleFactorY;
}

//for use in subclasses
function CalculateTextureOffsets()
{
}

//for use in subclasses
function DrawScaledTexture(GC gc, Texture tex, TextureRescale scale)
{
	gc.DrawStretchedTexture(scale.new.X, scale.new.Y, scale.new.W, scale.new.H,
				scale.old.X, scale.old.Y, scale.old.W, scale.old.H,
				tex);	
}

defaultproperties
{
     scaleFactorX=1.000000
     scaleFactorY=1.000000
}
