//10x18 grid
class TetrisWindow extends ComputerUIWindow;

#exec TEXTURE IMPORT NAME=TetrisBlock FILE=Textures\tetris_block.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2
#exec AUDIO IMPORT NAME=Tetris_RemoveLine FILE=Sounds\tetris-linebreak.wav GROUP=UI
#exec AUDIO IMPORT NAME=Tetris_Rotate FILE=Sounds\tetris-piececounterwise.wav GROUP=UI
#exec AUDIO IMPORT NAME=Tetris_Fall FILE=Sounds\tetris-piecefall.wav GROUP=UI
#exec AUDIO IMPORT NAME=Tetris_Land FILE=Sounds\tetris-piecelock.wav GROUP=UI

//I have NO IDEA why these are different structs
struct 				Coord2D
{
	var() int 		X, Y;
};

struct 				Size2D
{
	var() int 		X, Y;
};

struct 				BlockPos
{
	var() int 		X, Y;
};

struct 				Block
{
	var() Color 		color;
	var() BlockPos		location;
	var() bool		bOccupied;
	var() bool		bFalling;
};

struct				PlayerBlock
{
	var() Color 		color;
	var() BlockPos		location, relative_location;
};

struct				Shape
{
	var() BlockPos		positions[10];
	var() int		positionsLength, width, height;
};

var Texture			BlockTexture;
var Size2D			BlockSize;

var Shape			ShapeList[10];
var int				ShapeListLength;

var Color			ColorList[20];
var int				ColorListLength;

var Coord2D 			BoardPos;
//var Size2D			BoardSize;
var Block			Blocks[180];

var PlayerBlock			PlayerBlocks[10];
var int				PlayerBlocksLength;

var bool			bStarted;
var int				CurrentLevel;
var int				LinesLeft;
var float			CurrentSpeed;
var float			TimeLeft;
var float			FallTimeLeft;
var float			KeyTimeLeft;

var bool			KeyDownSpeed;
var bool			KeyDownRotate;
var bool			KeyUpRotate;
var bool			KeyDownLeft;
var bool			KeyDownRight;

var int				LinesPerLevel;
var float			SpeedBase;
var float			SpeedLevelIncrease;
var float			SpeedKeyMultiplier;
var int				score;

var float		scoreboardX,
			scoreboardY,
			scoreboardW,
			scoreboardSpacer;
var Font		scoreboardHeaderFont,
			scoreboardFont;
var localized string	scoreboardHeaderStr,
			scoreboardLevelStr,
			scoreboardScoreStr;

var MenuUIActionButtonWindow 	btnStart;
var MenuUIActionButtonWindow 	btnReturn;
var MenuUIActionButtonWindow 	btnLogout;

function Draw(GC gc, Color col, Coord2D dstArea, Size2D dstSize, Coord2D srcArea, Size2D srcSize, Texture tex)
{
	gc.SetTileColor(col);
	gc.DrawStretchedTexture(dstArea.X,dstArea.Y,dstSize.X,dstSize.Y,
				srcArea.X,srcArea.Y,srcSize.X,srcSize.Y,
				tex);
}

function Coord2D ToCoord(BlockPos pos)
{
	local Coord2D ret;
	ret.X=(pos.X+1)*BlockSize.X+BoardPos.X;
	ret.Y=(pos.Y+1)*BlockSize.Y+BoardPos.Y;
	return ret;
}

function DrawBlock(GC gc, Block block)
{
	local Coord2D pos;
	local Size2D size;

	pos.X=0;
	pos.Y=0;

	size.X=32;
	size.Y=32;

	if(block.location.X>=0 && block.location.X<10 && block.location.Y>=0 && block.location.Y<18 && block.bOccupied)
		Draw(gc, block.color, ToCoord(block.location), BlockSize, pos, size, BlockTexture);
}

function DrawGrayBlock(GC gc, int X, int Y)
{
	local Coord2D pos,pos2;
	local Size2D size;
	local Color col;

	col.R=48;
	col.G=48;
	col.B=48;

	pos.X=X;
	pos.Y=Y;

	pos2.X=0;
	pos2.Y=0;

	size.X=32;
	size.Y=32;

	Draw(gc, col, pos, BlockSize, pos2, size, BlockTexture);
}

function int PlayerPosX(int index)
{
	return PlayerBlocks[index].location.X + PlayerBlocks[index].relative_location.X;
}

function int PlayerPosY(int index)
{
	return PlayerBlocks[index].location.Y + PlayerBlocks[index].relative_location.Y;
}

function BlockPos PlayerPos(PlayerBlock p)
{
	local BlockPos ret;
	ret.X=p.location.X + p.relative_location.X;
	ret.Y=p.location.Y + p.relative_location.Y;
	return ret;
}

function DrawPlayerBlock(GC gc, PlayerBlock block)
{
	local Coord2D pos;
	local Size2D size;

	pos.X=0;
	pos.Y=0;

	size.X=32;
	size.Y=32;

	if(block.location.X>=0 && block.location.X<10 && block.location.Y>=0 && block.location.Y<18)
		Draw(gc, block.color, ToCoord(PlayerPos(block)), BlockSize, pos, size, BlockTexture);
}

event DrawWindow(GC gc)
{
	local int i;
	local Window parent;
	local float sX,sY,sW,sH;
	local string str;

	super.DrawWindow(gc);

	for(i=0;i<=10;i++)
	{
		DrawGrayBlock(gc,11+i*24,24);
		DrawGrayBlock(gc,11+i*24,480);
	}

	for(i=0;i<19;i++)
	{
		DrawGrayBlock(gc,11,24+i*24);
		DrawGrayBlock(gc,275,24+i*24);
	}
	DrawGrayBlock(gc,275,24+i*24);

	for(i=0;i<180;i++)
		DrawBlock(gc, Blocks[i]);

	for(i=0;i<PlayerBlocksLength;i++)
		DrawPlayerBlock(gc, PlayerBlocks[i]);

	parent=winParent.winParent;
	gc=parent.GetGC();

	ConvertCoordinates(Self,width,0,parent,sX,sY);
	sX+=scoreboardX;
	sY+=scoreboardY;

	gc.SetFont(scoreboardHeaderFont);
	gc.SetTextColorRGB(0,0,255);
	str=scoreboardHeaderStr;
	gc.GetTextExtent(scoreboardW,sW,sH,str);
	gc.DrawText(sX,sY,sW,sH,str);
	sY+=sH*1.25+scoreboardSpacer;

	gc.SetFont(scoreboardFont);
	gc.SetTextColorRGB(255,255,255);
	str=sprintf(scoreboardLevelStr,CurrentLevel);
	gc.GetTextExtent(scoreboardW,sW,sH,str);
	gc.DrawText(sX,sY,sW,sH,str);
	sY+=sH+scoreboardSpacer;

	gc.SetFont(scoreboardFont);
	gc.SetTextColorRGB(255,255,255);
	str=sprintf(scoreboardScoreStr,score);
	gc.GetTextExtent(scoreboardW,sW,sH,str);
	gc.DrawText(sX,sY,sW,sH,str);
	sY+=sH+scoreboardSpacer;
	sY+=sH+scoreboardSpacer;

	parent.ReleaseGC(gc);	
}

function int BlockIndex(int row, int col)
{
	return row*10+col;
}

event InitWindow()
{
	Super.InitWindow();
	bTickEnabled=true;
}

event bool VirtualKeyPressed(EInputKey key, bool bRepeat)
{
	local bool bKeyHandled;

	bKeyHandled = True;

	switch(key)
	{
		case IK_T:
			btnStart.PressButton();
			break;

		//reserve keys that are checked in Tick
		case IK_Up:
		case IK_Down:
		case IK_Left:
		case IK_Right:
		case IK_W:
		case IK_S:
		case IK_A:
		case IK_D:
			break;

		default:
			bKeyHandled = False;
			break;
	}

	if (!bKeyHandled)
		return Super.VirtualKeyPressed(key, bRepeat);
	else
		return bKeyHandled;
}


function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;

	bHandled = True;

	switch( buttonPressed )
	{
		case btnStart:
			bStarted=!bStarted;
			break;

		case btnLogout:
			CloseScreen("LOGOUT");
			break;

		case btnReturn:
			CloseScreen("RETURN");
			break;

		default:
			bHandled = False;
			break;
	}

	if (bHandled)
		return True;
	else
		return Super.ButtonActivated(buttonPressed);
}

function GameOver()
{
	local int i;
	for(i=0;i<180;i++)
		Blocks[i].bOccupied=false;
	PlayerBlocksLength=0;
	CurrentSpeed=0.0;
	bStarted=false;
	score=0;
	CurrentLevel=1;
}

function Tick(float deltaTime)
{
	local float multiplier;
	local int i, c, offset, fallLevel;
	local BlockPos tmp, tmp2, tmp3;
	local bool lineCheck, removeLine, moveRight, moveLeft, startFalling, bSoundLand, bSoundLine;
	local int newShape;
	local int newColor;

	if(!bStarted)
		return;

	Trestkon(GetPlayerPawn()).AddGameTimePlayed("TETRIS",deltaTime);

	KeyDownSpeed=IsKeyDown(IK_Down) || IsKeyDown(IK_S);
	KeyDownRotate=IsKeyDown(IK_Up) || IsKeyDown(IK_W);
	KeyUpRotate=KeyUpRotate||!KeyDownRotate;
	KeyDownRotate=KeyDownRotate&&KeyUpRotate;
	KeyDownLeft=IsKeyDown(IK_Left) || IsKeyDown(IK_A);
	KeyDownRight=IsKeyDown(IK_Right) || IsKeyDown(IK_D);

	KeyTimeLeft-=deltaTime;
	if(KeyTimeLeft<=0 && PlayerBlocks[i].location.Y>=0)
	{
		if(KeyDownRotate)
			KeyUpRotate=false;

		offset=0;

		for(i=0;KeyDownRotate && i<PlayerBlocksLength;i++)
		{
			tmp=PlayerBlocks[i].relative_location;
			if(tmp.y>offset)
				offset=tmp.y;
		}
	
		for(i=0;KeyDownRotate && i<PlayerBlocksLength;i++)
		{
			tmp=PlayerBlocks[i].relative_location;
			tmp2.x=offset-tmp.y;
			tmp2.y=tmp.x;
			tmp3=PlayerBlocks[i].location;
	
			KeyDownRotate=KeyDownRotate && tmp3.x+tmp2.x>=0 && tmp3.x+tmp2.x<10 && tmp3.y+tmp2.y>=0 && tmp3.y+tmp2.y<18 &&
				!Blocks[BlockIndex(tmp3.y+tmp2.y,tmp3.x+tmp2.x)].bOccupied;
		}
	
		for(i=0;KeyDownRotate && i<PlayerBlocksLength;i++)
		{
			tmp=PlayerBlocks[i].relative_location;
			tmp2.x=offset-tmp.y;
			tmp2.y=tmp.x;
			PlayerBlocks[i].relative_location=tmp2;
		}

		if(KeyDownRotate)
			PlaySound(Sound'Tetris_Rotate', 1.0);
	
		offset=10;
		for(i=0;KeyDownLeft&&i<PlayerBlocksLength;i++)
		{
			tmp=PlayerPos(PlayerBlocks[i]);
			if(tmp.x<offset)
				offset=tmp.x;
		}
		moveLeft=KeyDownLeft&&offset>0;
	
		offset=0;
		for(i=0;KeyDownRight&&i<PlayerBlocksLength;i++)
		{
			tmp=PlayerPos(PlayerBlocks[i]);
			if(tmp.x>offset)
				offset=tmp.x;
		}
		moveRight=KeyDownRight&&offset<9;
	
		for(i=0;i<PlayerBlocksLength;i++)
		{
			if(moveLeft&&Blocks[BlockIndex(PlayerPosY(i),PlayerPosX(i)-1)].bOccupied)
				moveLeft=false;
	
			if(moveRight&&Blocks[BlockIndex(PlayerPosY(i),PlayerPosX(i)+1)].bOccupied)
				moveRight=false;
		}
	
		for(i=0;i<PlayerBlocksLength;i++)
		{
			if(moveLeft)
				PlayerBlocks[i].location.X--;
	
			if(moveRight)
				PlayerBlocks[i].location.X++;
		}
		KeyTimeLeft=0.08;

	}

	multiplier=SpeedBase+CurrentSpeed;
	if(KeyDownSpeed && multiplier<SpeedKeyMultiplier)
		multiplier=SpeedKeyMultiplier;
	TimeLeft-=deltaTime*multiplier;

	if(TimeLeft<=0)
	{
		lineCheck=PlayerBlocksLength==0;

		for(i=0;i<PlayerBlocksLength;i++)
		{
			if(!lineCheck && PlayerPosY(i)+1>=0 && (PlayerPosY(i)==17 ||
				Blocks[BlockIndex(PlayerPosY(i)+1,PlayerPosX(i))].bOccupied))
			lineCheck=true;
		}

		for(i=0;i<PlayerBlocksLength;i++)
		{
			if(lineCheck)
			{
				if(PlayerPosY(i)<0)
				{
					GameOver();
					return;
				}
				Blocks[BlockIndex(PlayerPosY(i),PlayerPosX(i))].bFalling=false;
				Blocks[BlockIndex(PlayerPosY(i),PlayerPosX(i))].bOccupied=true;
				Blocks[BlockIndex(PlayerPosY(i),PlayerPosX(i))].color=PlayerBlocks[i].color;
				Blocks[BlockIndex(PlayerPosY(i),PlayerPosX(i))].location=PlayerPos(PlayerBlocks[i]);
			}
			else
				PlayerBlocks[i].location.Y++;
		}

		if(lineCheck)
		{
			KeyDownLeft=false;
			KeyDownRight=false;
			KeyDownSpeed=false;
			newShape=Rand(ShapeListLength);
			newColor=Rand(ColorListLength);
			PlayerBlocksLength=shapeList[newShape].positionsLength;
			for(i=0;i<PlayerBlocksLength;i++)
			{

				playerBlocks[i].relative_location=shapeList[newShape].positions[i];
//				playerBlocks[i].location=shapeList[newShape].positions[i];

//				playerBlocks[i].location.X+=5-shapeList[newShape].width/2;
//				playerBlocks[i].location.Y*=-1;
//				playerBlocks[i].location.Y+=shapeList[newShape].height-1;

				playerBlocks[i].location.X=5-shapeList[newShape].width/2;
				playerBlocks[i].location.Y=-1*shapeList[newShape].height;

				playerBlocks[i].color=ColorList[newColor];
			}
			bSoundLand=true;
		}

		offset=0;
		for(i=1;i<=18;i++)
		{
			removeLine=true;
			for(c=0;c<10;c++)
			{
				if(Blocks[BlockIndex(18-i,c)].bOccupied)
				{
//					Blocks[BlockIndex(18-i,c)].location.Y+=offset;
					Blocks[BlockIndex(18-i,c)].bOccupied=false;
//					Blocks[BlockIndex(18-i+offset,c)]=Blocks[BlockIndex(18-i,c)];
					Blocks[BlockIndex(18-i+offset,c)].location.Y=Blocks[BlockIndex(18-i,c)].location.Y+offset;
					Blocks[BlockIndex(18-i+offset,c)].location.X=Blocks[BlockIndex(18-i,c)].location.X;
					Blocks[BlockIndex(18-i+offset,c)].color=Blocks[BlockIndex(18-i,c)].color;
					Blocks[BlockIndex(18-i+offset,c)].bOccupied=true;
					Blocks[BlockIndex(18-i+offset,c)].bFalling=false;
				}
				else if(removeLine)
					removeLine=false;
			}
	
			if(removeLine)
			{
				score+=LinesLeft*10*CurrentLevel;
				if(Trestkon(player).GameHighScoreTetris<score)
					Trestkon(player).GameHighScoreTetris=score;
				log(Trestkon(player).GameHighScoreTetris);

				bSoundLine=true;
				for(c=0;c<10;c++)
					Blocks[BlockIndex(18-i+offset,c)].bOccupied=false;
				offset++;
				if(!startFalling)
				{
					startFalling=true;
					fallLevel=18-i;
				}
			}
		}

		for(i=fallLevel;startFalling && i>0;i--)
			for(c=0;c<10;c++)
				Blocks[BlockIndex(i,c)].bFalling=true;

		if(offset>=LinesLeft)
		{
			offset-=LinesLeft;
			LinesLeft=LinesPerLevel-offset;
			CurrentSpeed+=SpeedLevelIncrease;
			CurrentLevel++;
//			log(CurrentLevel);
		}
		else
			LinesLeft-=offset;
		TimeLeft=1.0;
		KeyDownRotate=false;

		if(bSoundLine)
			PlaySound(Sound'Tetris_RemoveLine', 1.0);
		else if(bSoundLand)
			PlaySound(Sound'Tetris_Land', 1.0);
//		else
//			PlaySound(Sound'Tetris_Fall', 1.0);
	}

	FallTimeLeft-=deltaTime;
	if(FallTimeLeft<=0)
	{
		for(i=16;i>0;i--)
			for(c=0;c<10;c++)
			{
				if(Blocks[BlockIndex(i,c)].bOccupied && Blocks[BlockIndex(i,c)].bFalling && !Blocks[BlockIndex(i+1,c)].bOccupied)
				{
					Blocks[BlockIndex(i,c)].bOccupied=false;
					Blocks[BlockIndex(i+1,c)].location.Y=Blocks[BlockIndex(i,c)].location.Y+1;
					Blocks[BlockIndex(i+1,c)].location.X=Blocks[BlockIndex(i,c)].location.X;
					Blocks[BlockIndex(i+1,c)].color=Blocks[BlockIndex(i,c)].color;
					Blocks[BlockIndex(i+1,c)].bOccupied=true;
				}
			}
		FallTimeLeft=0.1;
	}
}



function AddPosition(int pos, int x, int y)
{
	local BlockPos tmp;

	tmp.x=x;
	tmp.y=y;

	ShapeList[pos].positions[ShapeList[pos].positionsLength++]=tmp;

	if(pos+1>ShapeListLength)
		ShapeListLength=pos+1;
	if(x+1>ShapeList[pos].width)
		ShapeList[pos].width=x+1;
	if(y+1>ShapeList[pos].height)
		ShapeList[pos].height=y+1;
}

function DefaultShapes()
{
	AddPosition(0,0,0);
	AddPosition(0,1,0);
	AddPosition(0,2,0);
	AddPosition(0,3,0);

	AddPosition(1,0,0);
	AddPosition(1,1,0);
	AddPosition(1,2,0);
	AddPosition(1,0,1);

	AddPosition(2,2,1);
	AddPosition(2,0,0);
	AddPosition(2,1,0);
	AddPosition(2,2,0);

	AddPosition(3,0,0);
	AddPosition(3,1,0);
	AddPosition(3,0,1);
	AddPosition(3,1,1);

	AddPosition(4,0,0);
	AddPosition(4,1,0);
	AddPosition(4,1,1);
	AddPosition(4,2,1);

	AddPosition(5,0,0);
	AddPosition(5,1,0);
	AddPosition(5,1,1);
	AddPosition(5,2,0);

	AddPosition(6,0,1);
	AddPosition(6,1,0);
	AddPosition(6,1,1);
	AddPosition(6,2,0);
}

function CreateControls()
{
	Super.CreateControls();
	btnStart=winButtonBar.AddButton("S|&tart", HALIGN_Right);
	btnReturn=winButtonBar.AddButton("Return", HALIGN_Right);
	btnLogout=winButtonBar.AddButton("Logout", HALIGN_Right);
	DefaultShapes();
	LinesLeft=LinesPerLevel;
}

defaultproperties
{
     BlockTexture=Texture'TNMGUI.UI.TetrisBlock'
     BlockSize=(X=24,Y=24)
     ColorList(0)=(R=255)
     ColorList(1)=(R=255,G=128)
     ColorList(2)=(R=255,G=255)
     ColorList(3)=(G=255)
     ColorList(4)=(G=255,B=255)
     ColorList(5)=(B=255)
     ColorList(6)=(R=255,B=255)
     ColorListLength=7
     BoardPos=(X=11,Y=24)
     CurrentLevel=1
     LinesPerLevel=10
     SpeedBase=1.500000
     SpeedLevelIncrease=0.500000
     SpeedKeyMultiplier=16.000000
     scoreboardX=8.000000
     scoreboardY=32.000000
     scoreboardW=221.000000
     scoreboardSpacer=3.000000
     scoreboardHeaderFont=Font'DeusExUI.FontMenuExtraLarge'
     scoreboardFont=Font'DeusExUI.FontFixedWidthLocation'
     scoreboardHeaderStr="TETRIS"
     scoreboardLevelStr=" Level: %i"
     scoreboardScoreStr=" Score: %i"
     escapeAction="RETURN"
     Title="Tetris"
     ClientWidth=287
     ClientHeight=480
     bUsesStatusWindow=False
     ComputerNodeFunctionLabel="Login"
}
