class TextBasedGameInterface extends TextConsoleInterface;

var bool 	bGetFirstName;
var bool 	bGetLastName;
var bool	bGetAge;
var bool 	bConfirm;
var bool	bNewGameCheck;
var bool	bDone;
var string 	first_name;
var string	last_name;
var int 	age;
var int  	moves_left;

function bool Parse(string command, string args[256], int argc, string raw_text, string raw_args)
{
	local bool bhandled;
	local string tmp;

	if(bDone)
		return true;

	bhandled=true;
	ConsoleMessage(">"$raw_text);

	if(bGetFirstName)
	{
		first_name=raw_text;
		bGetFirstName=false;
		PromptLastName();
		return true;
	}

	if(bGetLastName)
	{
		last_name=raw_text;
		bGetLastName=false;
		PromptAge();
		return true;
	}

	if(bGetAge)
	{
		age=int(raw_text);
		if(age<0)
		{
			ConsoleMessage("You probably can't have a negative age. Give it another shot.");
			return true;
		}
		bGetAge=false;
		Confirm();
		return true;
	}

	if(bConfirm)
	{
		if(caps(raw_text)~="YES")
		{
			moves_left=rand(6)+3;
			bConfirm=false;

			ConsoleMessage("It is dark. You are likely to be eaten by a grue.");

			if(caps(first_name)=="HELLEN"&&caps(last_name)=="KELLER")
			{
				ConsoleMessage("You are Hellen Keller. You are eaten by a grue.");
				DeathMessage();
				PromptNewGame();
			}
			else if(age<12)
			{
				ConsoleMessage("You are young and weak. You are eaten by a grue.");
				DeathMessage();
				PromptNewGame();
			}
			else if(age>60)
			{
				ConsoleMessage("You are old and frail. You are eaten by a grue.");
				DeathMessage();
				PromptNewGame();
			}
			else
				ConsoleMessage("Use 'help' to see a list of commands.");

			return true;
		}

		if(caps(raw_text)~="NO")
		{
			bConfirm=false;
			PromptFirstName();
			return true;
		}

		ConsoleMessage("It's a 'yes' or 'no' question. Try giving it a 'yes' or 'no' answer.");
		return true;
	}

	if(bNewGameCheck)
	{
		if(caps(raw_text)~="YES")
		{
			bNewGameCheck=false;
			PromptFirstName();
			return true;
		}

		if(caps(raw_text)~="NO")
		{
			ConsoleMessage("SHUTTING DOWN...");
			bDone = true;
			return true;
		}

		ConsoleMessage("It's a 'yes' or 'no' question. Try giving it a 'yes' or 'no' answer.");
		return true;
	}

	if(caps(raw_text)~="FUCK YOU"||caps(raw_text)~="SCREW YOU"||caps(raw_text)~="BITCH"||caps(raw_text)~="DIE"||caps(raw_text)~="YOU SUCK")
	{
		command="";
		moves_left=0;
		Insult();
	}

	switch(caps(command))
	{
	case "MOVE":
		if(argc==0)
			ConsoleMessage("Which direction?");
		AttemptMove(args[0]);
		break;
	case "INFO":
		if(argc==1&&caps(args[0])~="GRUE")
			ConsoleMessage("Grues camp the shade in every single map they play in. And they eat you.");
		else
			ConsoleMessage("You don't know anything about anything other than grues.");
		break;
	case "ATTACK":
		ConsoleMessage("You comically attempt to attack something in the darkness, failing miserably.");
		moves_left--;
		break;
	case "INVENTORY":
		if(argc==1&&caps(args[0])~="CLOTHES")
			ConsoleMessage("They are damp and uncomfortable.");
		else
		{
			ConsoleMessage("Your inventory:");
			ConsoleMessage("1) Clothes");
		}
		break;
	case "CRY":
		ConsoleMessage("You sob in the darkness. It looks pretty pathetic.");
		moves_left--;
		break;
	case "EAT":
		if(argc==1&&(args[0]~="SELF"||args[0]~="ME"||args[0]~="LIMB"||args[0]~="HAND"))
		{
			ConsoleMessage("You contemplate eating your hand for a little while, until you realize you have nothing with which you can sever said hand.");
			moves_left--;
		}
		else if(argc>0)
			CommandBad(caps(command));
		else
			ConsoleMessage("You have no food. This hinders eating somewhat.");
		break;
	case "SLEEP":
		ConsoleMessage("You go to sleep. This is no doubt a cunning move.");
		moves_left=0;
		break;
	case "FUCK":
	case "SHIT":
	case "DAMMIT":
	case "DAMN":
		Profanity();
		moves_left--;
		break;
	case "LOOK":
	case "LISTEN":
		ConsoleMessage("It is pitch black. You don't see or hear anything.");
		moves_left--;
		break;
	case "EXAMINE":
	case "SEARCH":
		if(argc==0)
			CommandBad(caps(command));
		else if(args[0]=="CLOTHES"||args[0]=="SHIRT"||args[0]=="PANTS")
		{
			ConsoleMessage("Your clothes are uncomfortable and damp. There is nothing else of note about them or held within them.");
			moves_left--;
		}
		else
		{
			ConsoleMessage("It is dark, why would you expect to be able to discern anything about"@args[0]$"?");
			moves_left--;
		}
		break;
	default:
		bhandled=false;
	}

	if(moves_left==0)
	{
		Eaten();
		DeathMessage();
		PromptNewGame();
		bhandled=true;
	}

	return bhandled||super.parse(command,args,argc,raw_text,raw_args);
}

function Profanity()
{
	if(rand(2)==0)
		ConsoleMessage("You swear. This probably attracts any nearby grues.");
	else
		ConsoleMessage("You utter a curse. Your situation hasn't improved and you have been heard.");
}

function Insult()
{
	ConsoleMessage("Oh yeah?");
}

function AttemptMove(string dir)
{
	local bool valid;

	valid=true;

	switch(caps(dir))
	{
	case "N":
	case "NORTH":
		dir="north";
		break;
	case "NE":
	case "NORTHEAST":
		dir="north-east";
		break;
	case "E":
	case "EAST":
		dir="east";
		break;
	case "SE":
	case "SOUTHEAST":
		dir="south-east";
		break;
	case "S":
	case "SOUTH":
		dir="south";
		break;
	case "SW":
	case "SOUTHWEST":
		dir="south-west";
		break;
	case "W":
	case "WEST":
		dir="west";
		break;
	case "NW":
	case "NORTHWEST":
		dir="north-west";
		break;
	default:
		valid=false;
	}

	if(valid)
	{
		ConsoleMessage("You move"@dir$". At least, you think it's"@dir$".");
		moves_left--;
	}
	else if(caps(dir)~="LIGHT")
		ConsoleMessage("It is pitch black. Given this fact, moving towards a light source, while probably prudent, is definitely not happening.");
	else
		CommandBad("MOVE");
}

function CommandNotFound(string command)
{
	switch(rand(10))
	{
	case 0:
		ConsoleMessage(command$"? Well you totally could, since this is a very sophisticated game but... well, no, it doesn't understand.");
		break;
	case 1:
		ConsoleMessage("Yeah... you've stumped the extremely sophisticated text parser.");
		break;
	case 2:
		ConsoleMessage("The engine would get right on that, but... "@command$"? It has no clue.");
		break;
	case 3:
		ConsoleMessage("Not happening, sorry.");
		break;
	case 4:
		ConsoleMessage(command$"?"@command$"?! Absolutely no command listed for it!");
		break;
	case 5:
		ConsoleMessage("Hey, look, a Grue! Sorry but I've got no idea what to do.");
		break;
	case 6:
		ConsoleMessage("You probably wanted the engine to understand that, huh?");
		break;
	case 7:
		ConsoleMessage("I took input. I attempted to parse it. I... failed.");
		break;
	case 8:
		ConsoleMessage("Let me give you a rough quantum probability of the bit representing that being understood: 0.");
		break;
	case 9:
		ConsoleMessage("The parser didn't understand that command. Maybe you should 'cry' about it.");
		break;
	}
}

function CommandBad(string command)
{
	switch(rand(10))
	{
	case 0:
		ConsoleMessage("I tried to figure out what you wanted to do. Something about the"@command@"command I think. Then I gave up.");
		break;
	case 1:
		ConsoleMessage(command$"... the parser is crying now. That's right, you made the parser CRY. It's inconsolable.");
		break;
	case 2:
		ConsoleMessage("Couldn't figure out how you were trying to use that command.");
		break;
	case 3:
		ConsoleMessage("That usage of"@command@"makes no sense to me.");
		break;
	case 4:
		ConsoleMessage("If the engine thought that was a valid usage of that command, you wouldn't be reading this right now.");
		break;
	case 5:
		ConsoleMessage("Try again with"@command$". This time, do it right.");
		break;
	case 6:
		ConsoleMessage("Your command has been eaten by the text parser.");
		ConsoleMessage("BURP");
		break;
	case 7:
		ConsoleMessage("As if that makes sense!");
		break;
	case 8:
		ConsoleMessage("Racecar is a palindrome. Also, you misused that command.");
		break;
	case 9:
		ConsoleMessage("The magic 8 ball says: I'm not actually a magic 8 ball and that's not actually the right usage of"@command$".");
		break;
	}
}

function PromptFirstName()
{
	ConsoleMessage("Enter your character's first name:");
	bGetFirstName=true;
}

function PromptLastName()
{
	ConsoleMessage("Enter your character's last name:");
	bGetLastName=true;
}

function PromptAge()
{
	ConsoleMessage("Enter your character's age:");
	bGetAge=true;
}

function Confirm()
{
	ConsoleMessage("Are you sure you want to be"@first_name@last_name$", age"@age$"?");
	ConsoleMessage("Type 'yes' to start or 'no' to recreate your character.");
	bConfirm=true;
}

function PromptNewGame()
{
	ConsoleMessage("Start a new game?");
	ConsoleMessage("Type 'yes' to start a new game or 'no' to quit");
	bNewGameCheck=true;
}

function Eaten()
{
	ConsoleMessage("You have been eaten by a grue.");
}

function DeathMessage()
{
	ConsoleMessage(first_name@"has died.");
}

function Init(TextConsole c)
{
	super.init(c);
	ConsoleMessage("THE NAMELESS TEXT ADVENTURE 0.1 RUNNING...");
	PromptFirstName();
}

defaultproperties
{
     command_list(0)="move"
     command_list(1)="info"
     command_list(2)="attack"
     command_list(3)="inventory"
     command_list(4)="cry"
     command_list(5)="eat"
     command_list(6)="sleep"
     command_help(0)="move in a compass direction N, S, E or W"
     command_help(1)="get information about a given subject"
     command_help(2)="attacks the specified object"
     command_help(3)="lists your possessions"
     command_help(4)="probably prudent, given how utterly screwed you are"
     command_help(5)="eat food you have in your inventory"
     command_help(6)="go to sleep"
}
