//a console that can be embedded into a dx style window
//	Nicholas 'NVShacker' Van Sickle 7/11/07
class TextConsole extends Window;

var TextConsoleInterface	interface; //parses the commands
var ConsoleInputWindow		input; //command bar
var TextConsoleOutput		output; //log
var Font			consoleFont;
var BorderWindow		winBorder;
var Window			winContainer;
var MenuUIScrollAreaWindow 	winScroll;

event InitWindow()
{
	local MenuUIInfoButtonWindow btnInfo;
	local ClipWindow             clipName;

	super.InitWindow();
	SetSize(600,400);

//	CreateBorder();

	btnInfo = MenuUIInfoButtonWindow(/*winContainer.*/NewChild(Class'MenuUIInfoButtonWindow'));
	btnInfo.SetPos(4, 400-23);
	btnInfo.SetWidth(600-4-4);
	btnInfo.SetSensitivity(False);

	clipName = ClipWindow(/*winContainer.*/newChild(Class'ClipWindow'));
	clipName.SetWidth(600 - 8-4);
	clipName.ForceChildSize(False, True);
	clipName.SetPos(4 +4, 400-23 + 4);

	input = ConsoleInputWindow(clipName.NewChild(Class'ConsoleInputWindow'));
	input.SetMaxSize(256);
	input.fontText=consoleFont; //should reinit if I want to change fonts

	winScroll = MenuUIScrollAreaWindow(NewChild(Class'MenuUIScrollAreaWindow'));
	winScroll.SetPos(8, 7);
	winScroll.SetSize(600-8, 400-23-7);
	winScroll.EnableScrolling(false,true);
	winScroll.AutoHideScrollbars(true);

	output=TextConsoleOutput(winScroll.clipWindow.NewChild(Class'TextConsoleOutput'));
	output.SetSize(600-16,400-23-11);
	output.minHeight=400-23-11;
	output.winScroll=winScroll;
	output.SetPos(0,0);
	output.fnt=consoleFont;
	output.addtimer(0.1,,,'CalcHeight');

//	SetBackground(Texture'Solid');
//	SetBackgroundStyle(DSTY_Normal);
//	StyleChanged();
}

function message(string text)
{
	output.pushln(text);
}

event bool EditActivated(window edit, bool bModified)
{
	if(interface==None)
		return false;

	if(input.GetText()!="")
	{
		input.PushHistory(input.GetText());
		interface.ParseRaw(input.GetText());
		input.SetText("");
	}
	return true;
}

function TextConsoleInterface Init(class<TextConsoleInterface> interface_class)
{
	interface=new(None) interface_class;
	interface.Init(self);
	return interface;
}

/*
event StyleChanged()
{
	local ColorTheme theme;
	local color bg;

	theme = DeusExPlayer(GetRootWindow().parentPawn).ThemeManager.GetCurrentMenuColorTheme();

	bg=theme.GetColorFromName('MenuColor_Background');
	bg.R=bg.R*0.5;
	bg.G=bg.G*0.5;
	bg.B=bg.B*0.5;
	SetTileColor(bg);

	bg=theme.GetColorFromName('MenuColor_Background');
	bg.R=bg.R*0.9+0.1*256;
	bg.G=bg.G*0.9+0.1*256;
	bg.B=bg.B*0.9+0.1*256;
	winBorder.SetTileColor(bg);
//	winBorder.SetTileColorRGB(255,255,255);
}

function CreateBorder()
{
	winBorder = BorderWindow(NewChild(Class'BorderWindow'));
	winBorder.SetWindowAlignments(HALIGN_Full, VALIGN_Full);

	winBorder.SetBorders(Texture'ToolWindowBorder_TL', Texture'ToolWindowBorder_TR', 
					     Texture'ToolWindowBorder_BL', Texture'ToolWindowBorder_BR',
					     Texture'ToolWindowBorder_L',  Texture'ToolWindowBorder_R',
					     Texture'ToolWindowBorder_T',  Texture'ToolWindowBorder_B');
	winBorder.SetBorderStyle(DSTY_Normal);
	winBorder.BaseMarginsFromBorder(True);

	winContainer = winBorder.NewChild(Class'Window');
}*/

defaultproperties
{
     consoleFont=Font'DeusExUI.FontMenuSmall'
}
