class TextConsoleIRCInterface extends TextConsoleInterface
	abstract;

var TextConsoleIRC 	console_irc;
var string		nick;
var string		server;
var string		channel;
var LinkedList		users;
var LinkedList 		users_bak;
var bool		bConnected;
var bool		bInChannel;
var bool		bNoRetry;

function Init(TextConsole c)
{
	super.init(c);
	users=new(None) Class'LinkedList';
	console_irc=TextConsoleIRC(c);
}

function AddUser(string name,string prefix)
{
	local int priority;
	switch(prefix)
	{
	case "@":
		priority=3;
		break;
	case "%":
		priority=2;
		break;
	case "+":
		priority=1;
		break;
	default:
		priority=0;
	}
	console_irc.users.AddRow(prefix$name$";"$priority);
}

function RebuildUsers()
{
	local LinkedListNode n;
	local IRCUser u;

	console_irc.users.DeleteAllRows();
	if(!bInChannel)
		return;

	for(n=users.first;n!=None;n=n.next)
	{
		u=IRCUser(n.data);
		AddUser(u.name,u.prefix);
	}
}

function NewUser(string user)
{
	local LinkedListNode n;
	local IRCUser u;

	for(n=users.first;n!=None;n=n.next)
	{
		u=IRCUser(n.data);
		if(u.name==user)
			return;
	}

	u=new(None) class'IRCUser';
	u.name=user;
	users.Add(u);

	UpdateUsers();
	RebuildUsers();
}

function Join(string user)
{
	if(user!=nick)
		ConsoleMessage("*"@user@"has joined"@channel);
	else
		bInChannel=true;
	NewUser(user);
}

function UserQuit(string user, string reason)
{
	local IRCUser u;
	local LinkedListNode n;
	if(user==nick)
		return;
	ConsoleMessage("*"@user@"has quit irc (Reason:"@reason$").");
	for(n=users.first;n!=None;n=n.next)
	{
		u=IRCUser(n.data);
		if(u.name==user)
		{
			users.Remove(n);
			break;
		}
	}
	RebuildUsers();
}

function Part(string user)
{
	local IRCUser u;
	local LinkedListNode n;
	if(user==nick)
		ConsoleMessage("* You have left"@channel);
	else
		ConsoleMessage("*"@user@"has left"@channel);
	for(n=users.first;n!=None;n=n.next)
	{
		u=IRCUser(n.data);
		if(u.name==user)
		{
			users.Remove(n);
			break;
		}
	}
	RebuildUsers();
}

function Kick(string user, string kicker, optional string reason)
{
	local IRCUser u;
	local LinkedListNode n;
	if(reason=="")
		reason=user;
	if(user==nick)
		ConsoleMessage("* You have been kicked by"@kicker@"(Reason:"@reason$")");
	else
		ConsoleMessage("*"@user@"has been kicked by"@kicker@"(Reason:"@reason$")");
	for(n=users.first;n!=None;n=n.next)
	{
		u=IRCUser(n.data);
		if(u.name==user)
		{
			users.Remove(n);
			break;
		}
	}
	if(user==nick)
	{
		Kicked();
		return;
	}
	RebuildUsers();
}

function Connect()
{
	ConsoleMessage("* Connecting to"@server$"...");
	if(!AttemptConnect())
	{
		if(bNoRetry)
			return;
		ConsoleMessage("* Attempting to reconnect.");
		Connect();
		return;
	}
	ConsoleMessage("* Joining"@channel);	
	if(JoinChannel())
	{
		UpdateUsers();
		RebuildUsers();
		JoinedChannel();
	}
}

function Kicked()
{
	ConsoleMessage("* Attempting to rejoin"@channel);
	bInChannel=false;
	UpdateUsers();
	RebuildUsers();
	if(JoinChannel())
	{
		UpdateUsers();
		RebuildUsers();
		JoinedChannel();
	}
}

function SetMode(string user, string modestring)
{
	ConsoleMessage("*"@user@"sets mode:"@modestring);
	UpdateUsers();
	RebuildUsers();
}

function SetTopic(string user, string topic)
{
	ConsoleMessage("*"@user@"sets topic:"@"'"$topic$"'");
}

function Talk(string user, string text)
{
	ConsoleMessage("<"$user$">"@text);
}

function PrivateText(string Nick, string Text)
{
	ConsoleMessage("*"$Nick$"*"@text);
}

function Action(string user, string text)
{
	ConsoleMessage("*"@user@text);
}

function string GetTimeStamp()
{
	local string hour,minute;
	if(!class'tnmTime'.static.IsEnabled())
		return "";
	hour="0"$class'tnmTime'.static.GetHour();
	minute="0"$class'tnmTime'.static.GetMinute();
	return "["$right(hour,2)$":"$right(minute,2)$"] ";
}

function ConsoleMessage(string text)
{
	super.ConsoleMessage(GetTimeStamp()$text);
}

function ChangedNick(string OldNick, string NewNick)
{
	local LinkedListNode n;
	local IRCUser u;

	for(n=users.first;n!=None;n=n.next)
	{
		u=IRCUser(n.data);
		if(u.name==OldNick)
		{
			u.name=NewNick;
			break;
		}
	}

	if(OldNick==nick)
	{
		ConsoleMessage("* You are now know as"@NewNick);		
		nick=NewNick;
	}
	else
		ConsoleMessage("*"@OldNick@"is now know as"@NewNick);
	RebuildUsers();
}

function ChangeOp(string Nick, bool bOp)
{
	local LinkedListNode n;
	local IRCUser u;

	for(n=users.first;n!=None;n=n.next)
	{
		u=IRCUser(n.data);
		if(u.name==Nick)
		{
			if(bOp)
				u.prefix="@";
			else
				u.prefix="";
			break;
		}
	}

	RebuildUsers();
}

function ChangeHalfOp(string Nick, bool bHalfOp)
{
	local LinkedListNode n;
	local IRCUser u;

	for(n=users.first;n!=None;n=n.next)
	{
		u=IRCUser(n.data);
		if(u.name==Nick)
		{
			if(bHalfOp)
				u.prefix="%";
			else
				u.prefix="";
			break;
		}
	}

	RebuildUsers();
}

function ChangeVoice(string Nick, bool bVoice)
{
	local LinkedListNode n;
	local IRCUser u;

	for(n=users.first;n!=None;n=n.next)
	{
		u=IRCUser(n.data);
		if(u.name==Nick)
		{
			if(bVoice)
				u.prefix="+";
			else
				u.prefix="";
			break;
		}
	}

	RebuildUsers();
}

function UpdateUsers()
{
	/*if(!bInChannel && users_bak==None) 
	{
		users_bak=users;
		users=new(None) class'LinkedList';
	}
	else if(bInChannel && users_bak!=None)
	{
		users=users_bak;
		users_bak=None;
	}*/
}

function JoinedChannel()
{
	Join(nick);
	ConsoleMessage("* Now talking in"@channel);
	if(GetTopic()!="")
	{
		ConsoleMessage("* Topic is: '"$GetTopic()$"'");
		ConsoleMessage("* Set by:"@GetTopicUser()@"on"@GetTopicTime());
	}
	ConsoleMessage("* Channel modes:"@GetChannelModes());
}

function Disconnected(string reason)
{
	ConsoleMessage("* Disconnected (Reason:"@reason$")");
	bInChannel=false;
	UpdateUsers();
	ConsoleMessage("* Attempting to reconnect.");
	Connect();
}

function UserSetTopic(string user, string topic)
{
	if(user==nick)
		ConsoleMessage("* You set the topic to: '"$topic$"'.");
	else
		ConsoleMessage("*"@user@"sets the topic to: '"$topic$"'.");
}

function bool AttemptConnect();
function bool JoinChannel();
function string GetTopic();
function string GetTopicUser();
function string GetTopicTime();
function string GetChannelModes();
function DestroyIRC();

defaultproperties
{
}
