//the interface for TextConsole command processing
// Nicholas 'NVShacker' Van Sickle 7/11/07
class TextConsoleInterface extends Object
	abstract;

var TextConsole		console;		//owner

var string 		command_prefix; 	//prefix before commands
var string 		command_default;	//if the prefix isn't detected, attempt command_default <text>
var string		command_list[256];	//list of commands
var string		command_help[256];	//help text for commands

final function ParseRaw(string text)
{
	local string raw;
	local string raw_args;
	local string cmd;
	local string args[256];
	local string tmp;
	local bool first;
	local tnmregex regex;
	local int i,z,y;

	raw=text;

	if(command_prefix!="")
	{
		if(left(text,len(command_prefix)) ~= command_prefix)
			text=right(text,len(text)-len(command_prefix));
		else
			text=command_default@text;
	}

	regex=new(none) class'tnmregex';
	foreach regex.regex_search(text,"((?:[^\"]*\")?(?:[^\\s\"]*\"[^\"]*\")|(?:[^\\s\"]+))\\s*",tmp) //hell yes
	{
		if(!first)
		{
			cmd=regex.str_replace(regex.subgroup_search(1),"\"","");
			raw_args=right(text,len(text)-len(tmp));
			first=true;
		}
		else
		{
			args[i++]=regex.str_replace(regex.subgroup_search(1),"\"","");
		}
	}

	if(!Parse(cmd,args,i,raw,raw_args))
		CommandNotFound(cmd);
}

function ConsoleMessage(string text)
{
	console.message(text);
}

function CommandNotFound(string command)
{
	ConsoleMessage("Unable to find command"@command$". Use 'help' to get a list of commands.");
}

function CommandBad(string command)
{
	ConsoleMessage("Improper usage of"@command$". Try 'help"@command$"'.");
}

function bool Parse(string command, string args[256], int argc, string raw_text, string raw_args)
{
	local int i;

	if(caps(command)=="HELP")
	{
		if(argc>0)
		{
			if(caps(args[0])=="HELP")
			{
				ConsoleMessage("HELP - lists commands or explains the usage of a specific command");
				return true;
			}

			for(i=0;i<256&&command_list[i]!="";i++)
				if(caps(command_list[i])==caps(args[0]))
				{
					if(command_help[i]=="")
						break;
					ConsoleMessage(caps(args[0])@"-"@command_help[i]);
					return true;
				}
			ConsoleMessage("No help entry found for"@args[0]);
		}
		else
		{
			ConsoleMessage("Command list:");
			for(i=0;i<256&&command_list[i]!="";i++)
				ConsoleMessage(caps(command_list[i]));
		}
		return true;
	}

	return false;
}

function Init(TextConsole c)
{
	console=c;
}

defaultproperties
{
}
