class TextConsoleOutput extends Window;

var string	lines[65536];
var int 	top;
var int 	next;
var Font	fnt;

var float 	minHeight;
var bool	bCalcHeight; //hack

var scrollareawindow winScroll;

event DrawWindow(GC gc)
{
	local float cx,cy,cw,ch;
	local int i;
	local string s;

	super.DrawWindow(gc);
	gc.SetFont(fnt);
	gc.EnableWordWrap(true);
	gc.SetTextColorRGB(255,255,255);

	cx=0;
	cy=height;

	for(i=0;i<arraycount(lines);i++)
	{
		s=lines[(arraycount(lines)+top-i)%arraycount(lines)];

		if(s=="")
			break;

		gc.GetTextExtent(width,cw,ch,s);
		cy-=ch;
		if(cy<0)
			break;

		gc.DrawText(cx,cy,cw,ch,s);
	}
}

function Push(string str)
{
	lines[--next]=lines[next++]$str; //hooray gratuitous unary operators
}

function PushLn(string line)
{
	top=next;
	lines[next++]=line;
	if(next==arraycount(lines))
		next=0;

	if(bCalcHeight)
		UpdateHeight();
}

//major gross hack
//can't acquire gc during window creation so wait about 100 ms before trying that shit
function CalcHeight()
{
	bCalcHeight=true;
	UpdateHeight();
}

function UpdateHeight()
{
	local float cw,ch,nh;
	local int i;
	local string s;
	local gc gc;

	nh=0;
	gc=getgc();
	gc.SetFont(fnt);
	gc.EnableWordWrap(true);
	for(i=0;i<arraycount(lines);i++)
	{
		s=lines[(arraycount(lines)+top-i)%arraycount(lines)];

		if(s=="")
			break;

		gc.GetTextExtent(width,cw,ch,s);
		nh+=ch;
	}
	if(nh<minHeight)
		nh=minHeight;
	releasegc(gc);
	if(height==minHeight)
		return;
	setheight(nh);
	winScroll.vScale.MoveThumb(MOVETHUMB_End);
}

defaultproperties
{
     fnt=Font'DeusExUI.FontMenuSmall'
}
