class dxigFile extends Object
	transient abstract;

var string name;
var dxigInterface env;
var dxigFolder folder;
var bool bInUse;
var bool bReadOnly;
var transient tnmRegex regex;

function print (string str)
{
	env.ConsoleMessage(str);
}

final function Init(dxigInterface i, string n, optional string params)
{
	env=i;
	name=n;
	regex=new(none) class'tnmRegex';
	Setup(params);
}

function Setup(string params)
{
}

function MoveTo(dxigFolder f)
{
	if(folder!=none)
		folder.removefile(self);
	folder=f;
	folder.addfile(self);
}

function string PathString()
{
	if(folder!=none)
		return folder.PathString()$"\\"$name;
	return "DELETED";
}

function Delete()
{
	if(InUse())
	{
		print(name@"is in use by another process. Access is denied.");
		return;
	}

	if(bReadOnly)
	{
		print(name@"is read only. Access is denied.");
		return;
	}

	folder.removefile(self);
	folder=none;
}

function SetInterface(dxigInterface i)
{
	env=i;
}

function bool InUse()
{
	return bInUse;
}