class dxigFolder extends dxigFile;

var LinkedList files;
var int access_level;

final preoperator dxigFile * (LinkedListNode n)
{
	return dxigFile(n.data);
}

function Setup(string params)
{
	files=new(None) class'LinkedList';
	if(params!="")
		access_level=int(params);
}

function string PathString()
{
	local string path;
	local dxigFolder f;

	if(folder==None)
		return "DELETED";

	path=name;
	f=folder;
	while(!f.IsA('dxigRootFolder'))
	{
		path=f.name$"\\"$path;
		f=f.folder;
	}
	path=f.name$":\\"$path;
	return path;
}

function RemoveFile(dxigFile f)
{
	local LinkedListNode n;
	for(n=files.first;n!=none;n=n.next)
		if(*n==f)
			files.remove(n);
}

function AddFile(dxigFile f)
{
	files.add(f);
}

function bool HasFile(dxigFile f)
{
	local LinkedListNode n;
	for(n=files.first;n!=none;n=n.next)
		if(*n==f)
			return true;
	return false;
}

function dxigFile FindFile(string fn)
{
	local LinkedListNode n;
	for(n=files.first;n!=none;n=n.next)
		if((*n).name~=fn)
			return *n;
	return None;
}

function LinkedList FindFiles(string expr)
{
	local LinkedListNode n;
	local LinkedList ret;

	ret=new(None) class'LinkedList';

	for(n=files.first;n!=none;n=n.next)
		if(regex.regex_match((*n).name,expr))
			ret.add(*n);
	return ret;
}

function bool InUse()
{
	local LinkedListNode n;

	if(bInUse)
		return true;

	for(n=files.first;n!=none;n=n.next)
		if((*n).InUse())
			return true;

	return false;
}

function SetInterface(dxigInterface i)
{
	local LinkedListNode n;

	env=i;

	for(n=files.first;n!=none;n=n.next)
		(*n).setinterface(i);
}

function Delete()
{
	if(InUse())
	{
		print(name@"is in use by another process. Access is denied.");
		return;
	}

	if(bReadOnly)
	{
		print(name@"is read only. Access is denied.");
		return;
	}

	folder.removefile(self);
	folder=none;

	//todo: handle folder deletion
	print("Access is denied.");
}

defaultproperties
{
	access_level=0
}