class dxigInterface extends TextConsoleInterface;

var dxigRootFolder root;
var dxigFolder cur;
var dxigFolder cmds;

var string curUser;
var int permissions;

var tnmregex regex;

var dxigInfo info;

final operator(10) dxigFolder << (dxigFolder folder, dxigFile file)
{
//	log(file.name);
	file.moveto(folder);
	return folder;
}

final preoperator dxigFile readonly (dxigFile f)
{
	f.bReadOnly=true;
	return f;
}

function dxigFile file(string name, class<dxigFile> type, optional string params)
{
	local dxigFile ret;
	ret=new(None) type;
	ret.init(self,name,params);
	return ret;
}

function dxigFolder folder(string name)
{
	return dxigFolder(file(name,class'dxigFolder'));
}

function dxigFolder pFolder(string name, int level)
{
	return dxigFolder(file(name,class'dxigFolder',""$level));
}

function dxigFile get_file(dxigFolder f, string fn)
{
	switch(fn)
	{
	case "..":
		if(f.folder!=None)
			return f.folder;
	case ".":
		return f;
	default:
		return f.findFile(fn);
	}
}

function LinkedList resolve_files(string str)
{
}

function dxigFile resolve_file(string str)
{
	local string tmp;
	local string fn;
	local dxigFolder f;
	local bool folder;
	local bool first;

	str=regex.str_replace(str,"/","\\");
	fn=str;

	if(regex.regex_match(str,"^root:"))
		f=root;
	else
		f=cur;

	foreach regex.regex_search(str,"([^\\\\]+)(\\\\*)",tmp)
	{
		folder=false;
		fn=regex.subgroup_search(1);
		if(regex.subgroup_search(2)!="")
			folder=true;
		else
			break;

		if(!first && fn~="root:")
			continue;
		first=true;

		f=dxigFolder(get_file(f,regex.subgroup_search(1)));
		if(f==None)
			return None;
	}

	log(fn);
	log(f.name);

	if(fn~="root:")
		return root;
	if(folder)
		return dxigFolder(get_file(f,fn));
	return get_file(f,fn);
}

function bool Parse(string command, string args[256], int argc, string raw_text, string raw_args)
{
	local bool bhandled;
	local dxigFileExe cmd;
	local string new_args[256];
	local int i;

	bhandled=true;
	ConsoleMessage(cur.pathstring()$">"$raw_text);

	if(raw_text~="cd..")
	{
		args[0]="..";
		raw_text="cd ..";
		command="cd";
		raw_args="..";
	}

	cmd=dxigFileExe(cur.findfile(command));
	if(cmd==none) cmd=dxigFileExe(cur.findfile(command$".com"));
	if(cmd==none) cmd=dxigFileExe(cur.findfile(command$".exe"));
	if(cmd==none) cmd=dxigFileExe(cur.findfile(command$".bat"));
	if(cmd==none) cmd=dxigFileExe(cmds.findfile(command));
	if(cmd==none) cmd=dxigFileExe(cmds.findfile(command$".com"));
	if(cmd==none) cmd=dxigFileExe(cmds.findfile(command$".exe"));
	if(cmd==none) cmd=dxigFileExe(cmds.findfile(command$".bat"));

	if(cmd!=none)
	{
		new_args[0]=command;
		for(i=1;i<256;i++)
			new_args[i]=args[i-1];
		cmd.bInUse=true;
		cmd.execute(argc+1,new_args,raw_args);
		cmd.bInUse=false;
	}
	else
		bhandled=false;

	return bhandled||super.parse(command,args,argc,raw_text,raw_args);
}

function Init(TextConsole c)
{
	local trestkon a;

	super.init(c);

	regex=new(none) class'tnmregex';

	ConsoleMessage("GSI Command Line [Version 1.0]");
	ConsoleMessage("NOTE: GUI update coming Q4 2003");

	a=trestkon(console.getplayerpawn());
	foreach a.allactors(class'dxigInfo',info)
		break;
	if(info!=none)
	{
		root=info.root;
		cmds=info.cmds;
		info.env=self;
		cur=root;
		root.SetInterface(self);
		ConsoleMessage(cur.pathstring()$">");
		return;
	}
	info=a.spawn(class'dxigInfo');

	root=new(None) class'dxigRootFolder';
	root.init(self,"root");
	cur=root;
	ConsoleMessage(cur.pathstring()$">");

//	root << (folder("test") << file("hello.txt",class'dxigFileTxt',"Hello, world!") 
//		<< file("goodbye.txt",class'dxigFileTxt',"I don't know why you say goodbye|nI say hello."))
//		<< (folder("test2") << file("nick",class'dxigFileTxt',"rocks"));

	root << (folder("archived_emails")
		<< readonly file("README",class'dxigTxtParsed',"dxig_TextFile11")
		<< readonly file("070612fragmaster_fargo.txt",class'dxigTxtParsed',"dxig_TextFile01")
		);

	root << (folder("doc")
			<< (folder("gwog_notes") 
			<< file("note01",class'dxigTxtParsed',"dxig_TextFile07")
			<< file("note02",class'dxigTxtParsed',"dxig_TextFile08")			
			<< file("note03",class'dxigTxtParsed',"dxig_TextFile10")
			<< file("note04",class'dxigTxtParsed',"dxig_TextFile04")
			<< file("note05",class'dxigTxtParsed',"dxig_TextFile05")
			<< file("note06",class'dxigTxtParsed',"dxig_TextFile06")
			)
			<< (folder("plan")
			<< file("vents.txt",class'dxigTxtParsed',"dxig_TextFile09")
			)
		);

	root << (pFolder("logs",1)
		<< readonly file("ips.log",class'dxigTxtParsed',"dxig_TextFile03")
		<< readonly file("setup.log",class'dxigTxtParsed',"dxig_TextFile02")
		);

	cmds=pFolder("sys",2);
	cmds.bReadOnly=true;
	root << (cmds
		<< readonly file("cd.com",class'dxigExeCD')
		<< file("del.com",class'dxigExeDel')
		<< readonly file("dir.com",class'dxigExeDir')
		<< readonly file("read.com",class'dxigExeRead')
		<< file("echo.exe",class'dxigExeEcho')
		<< readonly file("help.exe",class'dxigExeHelp')
		<< file("core.sys",class'dxigFileSys')
		<< file("important_file.sys",class'dxigFileSys')
		<< file("kernel.sys",class'dxigFileSys')
		);

	if(a.flagbase.getbool('ALLIED_WC'))
		root << readonly file("trestkonsucks.exe",class'dxigExeThreads',"WC");
	else
		root << readonly file("delthreads.exe",class'dxigExeThreads',"PDX");

	info.root=root;
	info.cmds=cmds;
	info.env=self;
}

function SetUser(string user)
{
	curUser=user;
	switch(caps(curUser))
	{
	case "CONTRACTOR":
		permissions=0;
		break;
	case "FARGO":
		permissions=1;
		break;
	case "SRVRADM":
		permissions=2;
		break;
	}
}

function Shutdown()
{
	root.SetInterface(none);
}

defaultproperties
{
     command_prefix=""
}
