class dxigTxtParsed extends dxigFileTxt;

var string contents;

function Setup(string p)
{
	local DeusExTextParser parser;

	super.setup(p);

	// Create the text parser
	parser = new(None) Class'DeusExTextParser';

	// Attempt to find the text object
	if (parser.OpenText(env.console.stringtoname(text),"TNMText"))
	{
		while(parser.ProcessText())
			ProcessTextTag(parser);

		parser.CloseText();
	}

	CriticalDelete(parser);
}

function ProcessTextTag(DeusExTextParser parser)
{
	local String str;
	local byte tag;
	local Name fontName;
	local String textPart;
	local String fileStringName;
	local String fileStringDesc;

	tag  = parser.GetTag();

	switch(tag)
	{
		case 0:				// TT_Text:
			str = parser.GetText();

			if(contents=="")
				contents=str;
			else
				contents=contents$"|n"$str;
			break;

		case 1:				// TT_File (graphic, baby!)
			parser.GetFileInfo(fileStringName, fileStringDesc);
			break;

		// Bold
		case 19:
			break;

		case 13:				// TT_LeftJustify:
			break;

		case 12:				// TT_CenterText:
			break;
	}
}

function string GetText()
{
	return contents;
}