/*********
Optional hacking game for locking the thread in DXI
Simulates a basic command prompt
-Nick (05/10/08)
**********/
class dxigWindow extends ComputerUIWindow;

var TextConsole console;

var MenuUIActionButtonWindow 	btnLogout;
var MenuUIActionButtonWindow 	btnReturn;

function CreateControls()
{
	super.CreateControls();

	btnReturn=winButtonBar.AddButton("|&Return", HALIGN_Right);
	btnLogout=winButtonBar.AddButton("|&Logout", HALIGN_Right);


	console=TextConsole(winClient.NewChild(Class'TextConsole'));
	console.Init(Class'dxigInterface');
}

function SetNetworkTerminal(NetworkTerminal newTerm)
{
	super.setnetworkterminal(newTerm);
	dxigInterface(console.interface).SetUser(winTerm.username);
//	log(winTerm.username);
}

function bool ButtonActivated( Window buttonPressed )
{
	if(buttonPressed == btnLogout)
	{
		CloseScreen("LOGOUT");
		return true;
	}

	if(buttonPressed == btnReturn)
	{
		CloseScreen("RETURN");
		return true;
	}

	return super.ButtonActivated(buttonPressed);
}

event InitWindow()
{
	Super.InitWindow();
	bTickEnabled=true;
}

event DestroyWindow()
{
	dxigInterface(console.interface).Shutdown();
}

defaultproperties
{
     escapeAction="RETURN"
     Title="Command Prompt"
     ClientWidth=600
     ClientHeight=400
     clientTextures(0)=Texture'TNMGUI.UI.TNTABackground01'
     clientTextures(1)=Texture'TNMGUI.UI.TNTABackground02'
     clientTextures(2)=Texture'TNMGUI.UI.TNTABackground03'
     clientTextures(3)=Texture'TNMGUI.UI.TNTABackground04'
     clientTextures(4)=Texture'TNMGUI.UI.TNTABackground05'
     clientTextures(5)=Texture'TNMGUI.UI.TNTABackground06'
     textureRows=2
     textureCols=3
     bUsesStatusWindow=False
     ComputerNodeFunctionLabel="TextGame"
}