class tnm2DtestNetworkTerminal extends tnmNetworkTerminal;

var float staticTime;
var float staticBlinkTime;
var bool bShowStatic;
var bool bStaticBlinking;
var tnmStaticWindow winStatic;

function CloseScreen(String action)
{
	if (action == "PONG")
	{
		Class'PongWindow'.Default.bDXStyle=false;
		ShowScreen(Class'PongWindow');
	}
	else if (action == "DXPONG")
	{
		Class'PongWindow'.Default.bDXStyle=true;
		ShowScreen(Class'PongWindow');
	}
	else if (action == "APGPUZZLE")
		ShowScreen(Class'APGPuzzleWindow');
	else if	(action == "AIPUZZLE")
		ShowScreen(Class'AIPuzzleWindow');
	else if (action == "TETRIS")
		ShowScreen(Class'TetrisWindow');
	else if (action == "BREAKOUT")
		ShowScreen(Class'BreakoutWindow');
	else if (action == "LIGHTSOUT")
		ShowScreen(Class'LightsOutWindow');
	else if (action == "FAKEIRC")
		ShowScreen(Class'tnmFakeIRCWindow');
	else if (action == "TEXTGAME")
		ShowScreen(Class'tnmTextGameWindow');
	else if (action == "REALIRC")
		ShowScreen(Class'tnmIRCWindow');
	else if (action == "STATIC")
		ShowStatic();
	else if (action == "RETURN")
		ShowFirstScreen();
	else if (action == "LOGOUT")
		Super.CloseScreen("EXIT");
	else
		Super.CloseScreen(action);
}

function ShowStatic()
{
	local int i;
	if (winComputer != None)
	{
		winComputer.Destroy();
		winComputer = None;
	}

	winStatic = tnmStaticWindow(NewChild(Class'tnmStaticWindow'));
	winStatic.SetWindowAlignments(HALIGN_Full, VALIGN_Full);
	bShowStatic=true;
	staticTime=2.0;
	staticBlinkTime=0.5;
}

function Tick(float deltaTime)
{
	local int i;
	super.Tick(deltaTime);
	if(bShowStatic)
	{
		staticTime-=deltaTime;
		if(staticTime<=0)
		{
			bStaticBlinking=true;
			bShowStatic=false;
			winStatic.SetWindowAlignments(HALIGN_Full, VALIGN_Center);
		}
	}
	if(bStaticBlinking)
	{
		staticBlinkTime-=deltaTime;
		winStatic.SetSize(width, height*staticBlinkTime/0.5);
		if(staticBlinkTime<=0)
		{
			winStatic.Destroy();
			bStaticBlinking=false;
			CloseScreen("EXIT");
		}
	}
}

function ComputerHacked()
{
	bHacked = True;

	AIPuzzleWindow(winComputer).puzzleHacked();
}

function HackDetected(optional bool bDamageOnly)
{
	return;
}

defaultproperties
{
     FirstScreen=Class'TNMGUI.tnm2DtestWindow'
     bUsesHackWindow=False
}
