class tnm2DtestWindow extends ComputerUIWindow;

var MenuUIActionButtonWindow btnPong;
var MenuUIActionButtonWindow btnDXPong;
var MenuUIActionButtonWindow btnAPGPuzzle;
var MenuUIActionButtonWindow btnAIPuzzle;
var MenuUIActionButtonWindow btnTetris;
var MenuUIActionButtonWindow btnBreakout;
var MenuUIActionButtonWindow btnLightsOut;
var MenuUIActionButtonWindow btnFakeIRC;
var MenuUIActionButtonWindow btnTextGame;
var MenuUIActionButtonWindow btnRealIRC;
var MenuUIActionButtonWindow btnExit;

var int buttonLeftMargin;
var int firstButtonPosY;
var int specialOffsetY;
var int statusPosYOffset;
var int TopTextureHeight;
var int MiddleTextureHeight;
var int BottomTextureHeight;

function CreateControls()
{
	local MenuUIActionButtonWindow buttons[32];
	local int i;
	Super.CreateControls();

	btnExit = winButtonBar.AddButton("E|&xit", HALIGN_Right);

	btnPong = MenuUIChoiceButton(winClient.NewChild(Class'MenuUIChoiceButton'));
	btnPong.SetButtonText("|&Pong");
	buttons[0]=btnPong;

	btnDXPong = MenuUIChoiceButton(winClient.NewChild(Class'MenuUIChoiceButton'));
	btnDXPong.SetButtonText("|&DXPong");
	buttons[1]=btnDXPong;

	btnAPGPuzzle = MenuUIChoiceButton(winClient.NewChild(Class'MenuUIChoiceButton'));
	btnAPGPuzzle.SetButtonText("|&APG Puzzle");
	buttons[2]=btnAPGPuzzle;

	btnAIPuzzle = MenuUIChoiceButton(winClient.NewChild(Class'MenuUIChoiceButton'));
	btnAIPuzzle.SetButtonText("A|&I Puzzle");
	buttons[3]=btnAIPuzzle;

	btnTetris = MenuUIChoiceButton(winClient.NewChild(Class'MenuUIChoiceButton'));
	btnTetris.SetButtonText("T|&etris");
	buttons[4]=btnTetris;

	btnBreakout = MenuUIChoiceButton(winClient.NewChild(Class'MenuUIChoiceButton'));
	btnBreakout.SetButtonText("Break|&out");
	buttons[5]=btnBreakout;

	btnLightsOut = MenuUIChoiceButton(winClient.NewChild(Class'MenuUIChoiceButton'));
	btnLightsOut.SetButtonText("Lights O|&ut");
	buttons[6]=btnLightsOut;

	btnFakeIRC = MenuUIChoiceButton(winClient.NewChild(Class'MenuUIChoiceButton'));
	btnFakeIRC.SetButtonText("Fake I|&RC");
	buttons[7]=btnFakeIRC;

	btnTextGame = MenuUIChoiceButton(winClient.NewChild(Class'MenuUIChoiceButton'));
	btnTextGame.SetButtonText("|&Text Game");
	buttons[8]=btnTextGame;

	btnRealIRC = MenuUIChoiceButton(winClient.NewChild(Class'MenuUIChoiceButton'));
	btnRealIRC.SetButtonText("Real IR|&C");
	buttons[9]=btnRealIRC;

	for(i=0;buttons[i]!=None;i++)
	{
		buttons[i].SetPos(buttonLeftMargin, firstButtonPosY + (i * MiddleTextureHeight));
		buttons[i].SetWidth(273);
	}
	
	ComputerUIScaleClientWindow(winClient).SetNumMiddleTextures(i);
	statusPosY = statusPosYOffset + TopTextureHeight + (MiddleTextureHeight * i);
	AskParentForReconfigure();
}

function CreateClientWindow()
{
	Super.CreateClientWindow();

	if (winClient != None)
		ComputerUIScaleClientWindow(winClient).SetTextureHeights(TopTextureHeight, MiddleTextureHeight, BottomTextureHeight);
}

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;

	bHandled = True;

	switch( buttonPressed )
	{
		case btnPong:
			CloseScreen("PONG");
			break;

		case btnDXPong:
			CloseScreen("DXPONG");
			break;

		case btnAPGPuzzle:
			CloseScreen("APGPUZZLE");
			break;

		case btnAIPuzzle:
			CloseScreen("AIPUZZLE");
			break;

		case btnTetris:
			CloseScreen("TETRIS");
			break;

		case btnBreakout:
			CloseScreen("BREAKOUT");
			break;

		case btnLightsOut:
			CloseScreen("LIGHTSOUT");
			break;

		case btnFakeIRC:
			CloseScreen("FAKEIRC");
			break;

		case btnTextGame:
			CloseScreen("TEXTGAME");
			break;

		case btnRealIRC:
			CloseScreen("REALIRC");
			break;

		case btnExit:
			CloseScreen("EXIT");
			break;

		default:
			bHandled = False;
			break;
	}

	if (bHandled)
		return True;
	else
		return Super.ButtonActivated(buttonPressed);
}

function SetCompOwner(ElectronicDevices newCompOwner)
{
	compOwner = newCompOwner;

	if (winStatus != None)
		winStatus.SetText("shacker rocks!");
}

event bool VirtualKeyPressed(EInputKey key, bool bRepeat)
{
	local bool bKeyHandled;

	bKeyHandled = True;

	switch(key)
	{
		case IK_P:
			btnPong.PressButton();
			break;
		case IK_D:
			btnDXPong.PressButton();
			break;
		case IK_A:
			btnAPGPuzzle.PressButton();
			break;
		case IK_I:
			btnAIPuzzle.PressButton();
			break;
		case IK_E:
			btnTetris.PressButton();
			break;
		case IK_O:
			btnBreakout.PressButton();
			break;
		case IK_U:
			btnLightsOut.PressButton();
			break;
		case IK_X:
			btnExit.PressButton();
			break;
		case IK_R:
			btnFakeIRC.PressButton();
			break;
		case IK_T:
			btnTextGame.PressButton();
			break;
		case IK_C:
			btnRealIRC.PressButton();
			break;
		default:
			bKeyHandled = False;
			break;
	}

	if (!bKeyHandled)
		return Super.VirtualKeyPressed(key, bRepeat);
	else
		return bKeyHandled;
}

defaultproperties
{
     buttonLeftMargin=25
     firstButtonPosY=17
     specialOffsetY=16
     statusPosYOffset=50
     TopTextureHeight=12
     MiddleTextureHeight=30
     BottomTextureHeight=75
     classClient=Class'DeusEx.ComputerUIScaleClientWindow'
     Title="2D Game Selector"
     ClientWidth=331
     clientTextures(0)=Texture'DeusExUI.UserInterface.ComputerSpecialOptionsBackgroundTop_1'
     clientTextures(1)=Texture'DeusExUI.UserInterface.ComputerSpecialOptionsBackgroundTop_2'
     clientTextures(2)=Texture'DeusExUI.UserInterface.ComputerSpecialOptionsBackgroundMiddle_1'
     clientTextures(3)=Texture'DeusExUI.UserInterface.ComputerSpecialOptionsBackgroundMiddle_2'
     clientTextures(4)=Texture'DeusExUI.UserInterface.ComputerSpecialOptionsBackgroundBottom_1'
     clientTextures(5)=Texture'DeusExUI.UserInterface.ComputerSpecialOptionsBackgroundBottom_2'
     textureCols=2
     bAlwaysCenter=True
     ComputerNodeFunctionLabel="Login"
}
