class tnmComputerScreenGames extends ComputerUIWindow;

var MenuUIActionButtonWindow btnGames[5];
var string		     gameActions[5];

var MenuUIActionButtonWindow btnLogout;
var MenuUIActionButtonWindow btnReturn;

var int buttonLeftMargin;
var int firstButtonPosY;
var int specialOffsetY;
var int statusPosYOffset;
var int TopTextureHeight;
var int MiddleTextureHeight;
var int BottomTextureHeight;

function CreateControls()
{
	Super.CreateControls();

	btnReturn = winButtonBar.AddButton("Return", HALIGN_Right);
	btnLogout = winButtonBar.AddButton("Logout", HALIGN_Right);
}

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;
	local int i;

	bHandled = True;

	for(i=0;i<5;i++)
		if(buttonPressed==btnGames[i])
		{
			CloseScreen(gameActions[i]);
			return true;
		}

	switch( buttonPressed )
	{
		case btnLogout:
			CloseScreen("LOGOUT");
			break;

		case btnReturn:
			CloseScreen("RETURN");
			break;

		default:
			bHandled = False;
			break;
	}

	if (bHandled)
		return True;
	else
		return Super.ButtonActivated(buttonPressed);
}

function SetCompOwner(ElectronicDevices newCompOwner)
{
	local TNMComputers tnmcomp;
	local int i;
	compOwner = newCompOwner;
	tnmcomp=TNMComputers(compOwner);
	if(tnmcomp!=None)
	{
		for(i=0;i<5 && tnmcomp.games[i]!=0;i++)
		{
			btnGames[i]=MenuUIChoiceButton(winClient.NewChild(Class'MenuUIChoiceButton'));
			switch(int(tnmcomp.games[i]))
			{
			case 1: //pong	
				btnGames[i].SetButtonText("Pong");
				gameActions[i]="PONG";
				break;
			case 2: //tetris
				btnGames[i].SetButtonText("Tetris");
				gameActions[i]="TETRIS";
				break;
			case 3: //breakout
				btnGames[i].SetButtonText("Breakout");
				gameActions[i]="BREAKOUT";
				break;
			case 4: //lights out
				btnGames[i].SetButtonText("Lights Out");
				gameActions[i]="LIGHTSOUT";
				break;
			case 5: //text game
				btnGames[i].SetButtonText("The Nameless Text Adventure");
				gameActions[i]="TEXTGAME";
				break;
			case 6: //irc
				btnGames[i].SetButtonText("IRC Client");
				gameActions[i]="REALIRC";
				break;
			case 7: //fake irc
				btnGames[i].SetButtonText("NRC Client");
				gameActions[i]="FAKEIRC";
				break;
			case 8: //dxi game
				btnGames[i].SetButtonText("Command Prompt");
				gameActions[i]="DXIGAME";
				break;
			}
			btnGames[i].SetPos(buttonLeftMargin, firstButtonPosY + (i * MiddleTextureHeight));
			btnGames[i].SetWidth(273);
		}

		ComputerUIScaleClientWindow(winClient).SetNumMiddleTextures(i);
		statusPosY = statusPosYOffset + TopTextureHeight + (MiddleTextureHeight * i);
		AskParentForReconfigure();
	}
}

function CreateClientWindow()
{
	Super.CreateClientWindow();

	if (winClient != None)
		ComputerUIScaleClientWindow(winClient).SetTextureHeights(TopTextureHeight, MiddleTextureHeight, BottomTextureHeight);
}

defaultproperties
{
     buttonLeftMargin=25
     firstButtonPosY=17
     specialOffsetY=16
     statusPosYOffset=50
     TopTextureHeight=12
     MiddleTextureHeight=30
     BottomTextureHeight=75
     classClient=Class'DeusEx.ComputerUIScaleClientWindow'
     escapeAction="RETURN"
     Title="Applications"
     ClientWidth=331
     clientTextures(0)=Texture'DeusExUI.UserInterface.ComputerSpecialOptionsBackgroundTop_1'
     clientTextures(1)=Texture'DeusExUI.UserInterface.ComputerSpecialOptionsBackgroundTop_2'
     clientTextures(2)=Texture'DeusExUI.UserInterface.ComputerSpecialOptionsBackgroundMiddle_1'
     clientTextures(3)=Texture'DeusExUI.UserInterface.ComputerSpecialOptionsBackgroundMiddle_2'
     clientTextures(4)=Texture'DeusExUI.UserInterface.ComputerSpecialOptionsBackgroundBottom_1'
     clientTextures(5)=Texture'DeusExUI.UserInterface.ComputerSpecialOptionsBackgroundBottom_2'
     textureCols=2
     bAlwaysCenter=True
     ComputerNodeFunctionLabel="Login"
}
