//=============================================================================
// ComputerScreenHackAccounts
//=============================================================================
class tnmComputerScreenHackAccounts extends ComputerScreenHackAccounts;

function SetCompOwner(ElectronicDevices newCompOwner)
{
	local int compIndex;
	local int rowId;
	local int userRowIndex;
	local int offset;

	compOwner = Computers(newCompOwner);

	// Loop through the names and add them to our listbox
	for (compIndex=0; compIndex<compOwner.NumUsers(); compIndex++)
	{
		if (winTerm!=none && compOwner.GetAccessLevel(compIndex) > winTerm.GetSkillLevel())
		{
			offset++;
			continue;			
		}
		lstAccounts.AddRow(Caps(compOwner.GetUserName(compIndex)));

		if (Caps(winTerm.GetUserName()) == Caps(compOwner.GetUserName(compIndex)))
			userRowIndex = compIndex - offset;
	}

	// Select the row that matches the current user
	rowId = lstAccounts.IndexToRowId(userRowIndex);
	lstAccounts.SetRow(rowId, True);
}

function ChangeSelectedAccount()
{
	local int userIndex;

	userIndex = lstAccounts.RowIdToIndex(lstAccounts.GetSelectedRow());

	if (winTerm != None)
		if ( compOwner.GetAccessLevel(userIndex) <= winTerm.GetSkillLevel() )
			winTerm.ChangeAccount(userIndex);
		else
			;//some sort of console output maybe?
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     texBackground=Texture'DeusExUI.UserInterface.ComputerHackAccountsBackground'
     texBorder=Texture'DeusExUI.UserInterface.ComputerHackAccountsBorder'
     ChangeAccountButtonLabel="|&Change Account"
     AllAccountsHeader="All User Accounts"
     CurrentAccountHeader="Current User"
     backgroundWidth=188
     backgroundHeight=181
     backgroundPosX=6
     backgroundPosY=9
}
