//=============================================================================
// ComputerScreenSpecialOptions
//=============================================================================

class tnmComputerScreenSpecialOptions expands ComputerScreenSpecialOptions;

var MenuUIActionButtonWindow btnGames;

struct LogoutInfo
{
	var() bool bLogout;
	var() MenuUIChoiceButton btn;
};

var LogoutInfo bLogoutList[4];

function CreateOptionButtons()
{
	local int specialIndex;
	local int numOptions;
	local MenuUIChoiceButton winButton;
	local bool bavailable, bgray;
	local FlagBase flags;
	local deusexplayer player;

	// Figure out how many special options we have

	numOptions = 0;
	for (specialIndex=0; specialIndex<ArrayCount(Computers(compOwner).specialOptions); specialIndex++)
	{
		if ((Computers(compOwner).specialOptions[specialIndex].userName == "") || (Caps(Computers(compOwner).specialOptions[specialIndex].userName) == winTerm.GetUserName()))
		{
			if (Computers(compOwner).specialOptions[specialIndex].Text != "")
			{
				bavailable = true;
				bgray=false;
				if (tnmComputers(compOwner).specialOptionflags[specialIndex].specialoptionflag != '')
				{
					player = deusexplayer(getplayerpawn()); //there is a better way of doing this I'm sure
					bavailable = false;
					if (player != none)
					{
						flags = player.flagbase;
						if(tnmComputers(compOwner).specialOptionflags[specialIndex].specialOptionflag != '')
						{
							if(flags.GetBool(tnmComputers(compOwner).specialOptionflags[specialIndex].specialOptionflag)==tnmComputers(compOwner).specialOptionflags[specialIndex].bDesiredValue)
							{
								bavailable = true;
							}
							else if(tnmComputers(compOwner).specialOptionflags[specialIndex].bVisibleInactive)
								bgray=true;
						}
						else
								bavailable = true;
					}
				}
				
				if(bavailable||bgray)
				{		
					// Create the button
					winButton = MenuUIChoiceButton(winClient.NewChild(Class'MenuUIChoiceButton'));
					winButton.SetPos(buttonLeftMargin, firstButtonPosY + (numOptions * MiddleTextureHeight));
					winButton.SetButtonText(Computers(compOwner).specialOptions[specialIndex].Text);
					winButton.SetSensitivity(!bgray&&!Computers(compOwner).specialOptions[specialIndex].bAlreadyTriggered);
					winButton.SetWidth(273);

					bLogoutList[numOptions].bLogout=tnmComputers(compOwner).specialOptionlogout[specialIndex].bLogout;
					bLogoutList[numOptions].btn=winButton;
	
					optionButtons[numOptions].specialIndex = specialIndex;
					optionButtons[numOptions].btnSpecial   = winButton;

					numOptions++;				
				}
			}
		}
	}

	ComputerUIScaleClientWindow(winClient).SetNumMiddleTextures(numOptions);

	// Update the location of the Special Info window and the Status window
	winSpecialInfo.SetPos(10, specialOffsetY + TopTextureHeight + (MiddleTextureHeight * numOptions));
	statusPosY = statusPosYOffset + TopTextureHeight + (MiddleTextureHeight * numOptions);
	AskParentForReconfigure();
}

function bool ButtonActivated( Window buttonPressed )
{
	if(buttonPressed==btnGames)
	{
		CloseScreen("GAMES");
		return true;
	}
	return super.ButtonActivated(buttonPressed);
}

function ActivateSpecialOption(MenuUIChoiceButton buttonPressed)
{
	local int i;
	local bool bLogout;

	super.ActivateSpecialOption(buttonPressed);

	for(i=0; i<arrayCount(optionButtons); i++)
		if(bLogoutList[i].btn==buttonPressed)
		{
			bLogout=bLogoutList[i].bLogout;
			break;
		}

	// Loop through the buttons and find a Match!
	for(i=0; i<arrayCount(optionButtons); i++)
	{
		if(optionButtons[i].btnSpecial==None)
			continue;
		optionButtons[i].btnSpecial.Hide();
		optionButtons[i].btnSpecial.DisableWindow();
		optionButtons[i].btnSpecial=None;
	}
	CreateOptionButtons();

	if(bLogout)
		CloseScreen("EXIT");
}

//combines things from super and super.super function with new class names
function SetNetworkTerminal(NetworkTerminal newTerm)
{
	winTerm = newTerm;

	if (winTerm.IsA('tnmNetworkTerminalPersonal'))
		btnReturn = winButtonBar.AddButton(EmailButtonLabel, HALIGN_Left);
	else if (winTerm.IsA('tnmNetworkTerminalSecurity'))
		btnReturn = winButtonBar.AddButton(SecurityButtonLabel, HALIGN_Left);

	if (btnReturn != None)
		CreateLeftEdgeWindow();
}

function SetCompOwner(ElectronicDevices newCompOwner)
{
	if(TNMComputers(newCompOwner).bHasGames)
		btnGames = winButtonBar.AddButton("Applications", HALIGN_Left);
	Super.SetCompOwner(newCompOwner);
}

defaultproperties
{
}
