class tnmConsole extends WindowConsole;

//#exec new TrueTypeFontFactory Name="BigConsoleFont" FontName="Impact" Height=32 AntiAlias=1 XPad=2 CharactersPerPage=32
//#exec new TrueTypeFontFactory Name="SmallConsoleFont" FontName="Adobe Garamond Pro" Height=18 AntiAlias=1 XPad=2 CharactersPerPage=64

event PostRender( canvas C )
{
	super.PostRender(C);

	RenderUWindow(C);
}

function HideConsole()
{
	super.HideConsole();

	if(Root != None)
		Root.CloseActiveWindow();
}

function DrawLevelAction( canvas C )
{
	local string BigMessage;

	// DEUS_EX AJY - don't want to print any text 
	// if the game is paused because we're in a menu
	if (Viewport.Actor.bShowMenu )
	{
		BigMessage = "";
		return;
	}
	if ( (Viewport.Actor.Level.Pauser != "") && (Viewport.Actor.Level.LevelAction == LEVACT_None) )
	{
		C.Font = C.LargeFont;	
		C.Style = 1;
		C.DrawColor.R = 255;
		C.DrawColor.G = 255;
		C.DrawColor.B = 255;

		BigMessage = PausedMessage; // Add pauser name?
		PrintActionMessage(C, BigMessage);

		return;
	}
	else if ( Viewport.Actor.Level.LevelAction == LEVACT_Loading )
		BigMessage = LoadingMessage;
	else if ( Viewport.Actor.Level.LevelAction == LEVACT_Saving )
		BigMessage = SavingMessage;
	else if ( Viewport.Actor.Level.LevelAction == LEVACT_Connecting )
		BigMessage = ConnectingMessage;
	else if ( Viewport.Actor.Level.LevelAction == LEVACT_Precaching )
		BigMessage = PrecachingMessage;
	
	if ( BigMessage != "" )
	{
		C.Style = 3;
		C.DrawColor.R = 255;
		C.DrawColor.G = 255;
		C.DrawColor.B = 255;
		C.Font = C.LargeFont;		
		PrintActionMessage(C, BigMessage);
		if ( Viewport.Actor.Level.LevelAction == LEVACT_Loading )
		{
			C.Font = C.BigFont;	
			PrintQuoteMessage(C);
		}
	}
}

function PrintQuoteMessage( Canvas C )
{
	local float XL, YL;
	local string quotemessage;
	local DeusExTextParser parser;
	local string lst[4096];
	local int i;
	local name quotesFile;

	if(trestkon(viewport.actor.getplayerpawn()).bLoadingQuotes)
		quotesFile='TNMQuotesMenu';
	else
		quotesFile='TNMHintsMenu';

	parser = new(None) Class'DeusExTextParser';

	if (parser.OpenText(quotesFile,"tnmText"))
	{
		while(parser.ProcessText())
		{
			if(parser.GetText()!="")
				lst[i++]=parser.GetText();
		}
		parser.CloseText();
	}

	CriticalDelete(parser);

	QuoteMessage=lst[rand(i)];
	log(quotemessage,'Quote');

	C.bCenter = false;
	C.StrLen( QuoteMessage, XL, YL );
	C.SetPos(FrameX/2 - XL/2, FrameY*3/4 - YL/2);
	C.DrawText( QuoteMessage, false );
}	

event bool KeyEvent( EInputKey Key, EInputAction Action, FLOAT Delta )
{
	local byte k;
	k = Key;
	switch(Action)
	{
	case IST_Press:
		switch(k)
		{
		/*case EInputKey.IK_B:
			Root.CreateWindow(Class'UBrowser.UBrowserMainWindow',0,0,300,300);
			return true;
		case EInputKey.IK_Escape:
			if (bLocked)
				return true;

			bQuickKeyEnable = False;
			LaunchUWindow();
			return true;*/
		case ConsoleKey:
			if (bLocked)
				return true;

			bQuickKeyEnable = True;
			LaunchUWindow();
			if(!bShowConsole)
				ShowConsole();
			return true;
		}
		break;
	}

	return False; 
}

defaultproperties
{
     RootWindow="TNMGUI.tnmUWindowRootWindow"
     ConsoleClass=Class'TNMGUI.tnmUMenuConsoleWindow'
}
