class tnmFakeIRCWindow extends ComputerUIWindow;

#exec TEXTURE IMPORT NAME=IRCABackground01 FILE=Textures\IRCABackground01.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2
#exec TEXTURE IMPORT NAME=IRCABackground02 FILE=Textures\IRCABackground02.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2
#exec TEXTURE IMPORT NAME=IRCABackground03 FILE=Textures\IRCABackground03.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2
#exec TEXTURE IMPORT NAME=IRCABackground04 FILE=Textures\IRCABackground04.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2
#exec TEXTURE IMPORT NAME=IRCABackground05 FILE=Textures\IRCABackground05.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2
#exec TEXTURE IMPORT NAME=IRCABackground06 FILE=Textures\IRCABackground06.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2

var TextConsole console;

var MenuUIActionButtonWindow 	btnLogout;
var MenuUIActionButtonWindow 	btnReturn;
var FakeIRCInterface		interface;
var int				irca;

function CreateControls()
{
	super.CreateControls();

	btnReturn=winButtonBar.AddButton("|&Return", HALIGN_Right);
	btnLogout=winButtonBar.AddButton("|&Logout", HALIGN_Right);

//	btnReturn.SetSelectability(false);
//	btnLogout.SetSelectability(false);

	console=TextConsole(winClient.NewChild(Class'TextConsoleIRC'));
	interface=FakeIRCInterface(console.Init(Class'FakeIRCInterface'));
	if(!Trestkon(player).bFakeIRCSeen)
	{
		IRCTimer(2.0); //start the log!
		Trestkon(player).bFakeIRCSeen=true; //only see this once per playthrough
		Trestkon(player).flagBase.SetBool('NARC_IRC',true,,0);
	}
	else
	{
		interface.ConsoleMessage("SYSTEM: Error starting process: NARCISSUS//NRC");
		interface.ConsoleMessage("SYSTEM: Exiting due to error...");
	}
//	console.Init(Class'consoleinterfacetest');
}

function IRCTimer(float time)
{
	AddTimer(time,,,'IRCUpdate');
}

//if only uscript had preprocessor macros...
function talk(string name,string text,float time)
{
	interface.Talk(name,text);
	IRCTimer(time);
}

function act(string name,string text,float time)
{
	interface.Action(name,text);
	IRCTimer(time);
}

function kick(string name,string kicker,string reason,float time)
{
	interface.kick(name,kicker,reason);
	IRCTimer(time);
}

function mode(string name,string mode,float time)
{
	interface.setmode(name,mode);
	IRCTimer(time);
}

function topic(string name,string topic,float time)
{
	interface.settopic(name,topic);
	IRCTimer(time);
}

function join(string name,float time)
{
	interface.join(name);
	IRCTimer(time);
}

function part(string name,float time)
{
	interface.part(name);
	IRCTimer(time);
}

function IRCUpdate()
{
	switch(irca++)
	{
	case 0:
		talk("Lawrence","So...",3.1);
		break;
	case 1:
		talk("Lawrence","We can't make a game without a radish launcher.",2.7);
		break;
	case 2:
		talk("Jonas","Dammit Larry!",4.9);
		break;
	case 3:
		talk("Jonas","We need to determine our setting before we come up with the weapons! It should be a single streaming world, like Oblivion! Only bigger!",2.8);
		break;
	case 4:
		talk("Shane","but we only have one mapper...",3.2);
		break;
	case 5:
		talk("Jonas","Exactly: One mapper, one map",3.4);
		break;
	case 6:
		talk("Jim","Okay, I just finished the editor for my engine.",1.2);
		break;
	case 7:
		talk("Nicholas","Larry: is Trestkon your laptop or something?",4.2);
		break;
	case 8:
		talk("Jonas","I'm thinking it should be a huge city, kinda cyberpunkish",3.5);
		break;
	case 9:
		talk("Jonas","lll---------------------------------helpmehesahorriblepersonhemistr*********-",2.2);
		break;
	case 10:
		talk("Jonas","Sorry, cat.",2.7);
		break;
	case 11:
		talk("Nicholas","schrodinger's?",2.2);
		break;
	case 12:
		talk("Chris","i only do futuristic corridors and industrial areas",2.9);
		break;
	case 13:
		talk("Jonas","Okay, a space station then!",3.1);
		break;
	case 14:
		talk("Phasmatis","we should make a game about guiding tiny kittens into a bowl of food :)",3.4);
		break;
	case 15:
		talk("Shane","lol, that's sort of gay, phas",2.8);
		break;
	case 16:
		talk("Phasmatis","but girls will love it :D",2.1);
		break;
	case 17:
		talk("Shane","and jonas",2.5);
		break;
	case 18:
		talk("Phasmatis","that's what I'm saying :P",2.7);
		break;
	case 19:
		talk("Nicholas","kittens? we'd need a fur subsystem",1.3);
		break;
	case 20:
		kick("Phasmatis","Jonas","I hate you guys.",0.2);
		break;
	case 21:
		join("Phasmatis",1.7);
		break;
	case 22:
		talk("Phasmatis","lol :P",2.2);
		break;
	case 23:
		talk("Jim","I just coded HDR support into the engine.",3.4);
		break;
	case 24:
		interface.opphas();
		talk("Nicholas","Wait... Jim, why don't we just write our physics engine based on subatomic particles? I could write a model exporter for it.",4.4);
		break;
	case 25:
		talk("Lawrence","Let's make a game where you have to farm radishes, except that the radishes will mutate into deadly Rambies (Radish + Zombies) halfway through if you don't treat them with respect! And then you spend the second half of the game hoeing them to death!",6.6);
		break;
	case 26:
		talk("Jonas","Larry, I'm the lead designer, why don't you leave the ideas to me, okay?",3.6);
		break;
	case 27:
		talk("Lawrence","Hey, I'm the project leader, I decide who lives or dies.",2.7);
		break;
	case 28:
		talk("Lawrence","*I decide what sort of game we make.",0.9);
		break;
	case 29:
		talk("Lawrence","Typo.",1.76);
		break;
	case 30:
		talk("Jim","Finished recreating the physics system.",2.3);
		break;
	case 31:
		talk("Jonas","That's nice Jim",2.2);
		break;
	case 32:
		talk("Nicholas","jim update the cvs",2.7);
		break;
	case 33:
		talk("Shane","we have cvs?",2.7);
		break;
	case 34:
		talk("Jonas","What about a game where you play a cat and you have to sneak around kinda like in Splinter Cell to avoid dogs and stuff?",3.2);
		break;
	case 35:
		talk("Gelo","I like that idea :)",1.9);
		break;
	case 36:
		talk("Chris","that's a terrible idea, you nubs",2.2);
		break;
	case 37:
		talk("Jonas","What do you know, you're just a level designer!",0.9);
		break;
	case 38:
		act("Chris","slaps Jonas around a bit with a large trout",1.65);
		break;
	case 39:
		talk("Chris","stfu foo'",3.7);
		break;
	case 40:
		talk("Nicholas","uh, I just did a whois on trestkon, he's not larry... who is he?",2.0);
		break;
	case 41:
		talk("Jonas","That's a great question.",2.2);
		break;
	case 42:
		talk("Lawrence","someone stole trestkon from me?!",1.4);
		break;
	case 43:
		mode("Lawrence","+b Trestkon!*@*",0.5);
		break;
	case 44:
		kick("Trestkon","Lawrence","Goodbye. Have a radish.",1.5);
		break;
	case 45:
		talk("Nicholas","nice ban larry :p",2.1);
		break;
	case 46:
		talk("Lawrence","Do not mock my banning abilities!!",1.75);
		break;
	case 47:
		talk("Nicholas","Too late :p",3.0);
		break;
	case 48:
		mode("Nicholas","+b *!Trestkon@*",0.5);
		break;
	case 49:
		interface.bbanned=true;
		kick("Trestkon","Nicholas","Private channel. Also, don't impersonate Larry.",1.5);
		break;
	case 50:
		interface.Disconnected("Ghosted by sys-op: NARCISSUS");
		IRCTimer(2.5);
		break;
	case 51:
		interface.ConsoleMessage("SYSTEM: Process halted by remote administrator (USER_NARCISSUS)");
		break;
	}
}

function bool ButtonActivated( Window buttonPressed )
{
	if(buttonPressed == btnLogout)
	{
		CloseScreen("LOGOUT");
		return true;
	}

	if(buttonPressed == btnReturn)
	{
		CloseScreen("RETURN");
		return true;
	}

	return super.ButtonActivated(buttonPressed);
}

defaultproperties
{
     escapeAction="RETURN"
     Title="Narcissus Relay Chat"
     ClientWidth=600
     ClientHeight=400
     clientTextures(0)=Texture'TNMGUI.UI.IRCABackground01'
     clientTextures(1)=Texture'TNMGUI.UI.IRCABackground02'
     clientTextures(2)=Texture'TNMGUI.UI.IRCABackground03'
     clientTextures(3)=Texture'TNMGUI.UI.IRCABackground04'
     clientTextures(4)=Texture'TNMGUI.UI.IRCABackground05'
     clientTextures(5)=Texture'TNMGUI.UI.IRCABackground06'
     textureRows=2
     textureCols=3
     bUsesStatusWindow=False
     ComputerNodeFunctionLabel="NRC"
}
