class tnmIRCInterface extends TextConsoleIRCInterface;

var bool bPromptNick;
var tnmIRCLink link;
var string topic;
var string topic_user;
var string topic_time;
var string modes;
var bool bQuit;

function ChangedNick(string OldNick, string NewNick)
{
	super.ChangedNick(OldNick,NewNick);
	if(link.NickName==OldNick)
		link.NickName=NewNick;
}

function UpdateUsers()
{
	if(!bInChannel)
	{
		users.first=none;
		users.last=none;
	}
	super.UpdateUsers();
}

function bool Parse(string command, string args[256], int argc, string raw_text, string raw_args)
{
	local bool bHandled;

	if(bPromptNick)
	{
		nick=raw_text;
		bPromptNick=false;
		Connect();
		return true;
	}

	if(caps(command)=="NICK")
	{
		link.SendCommandText("NICK"@raw_args);
		return true;
	}
	else if(caps(command)=="SERVER")
	{
		bQuit=true;
		link.SendCommandText("QUIT"@link.DisconnectReason);
		link.Close();
//		Disconnected(link.DisconnectReason);
		bQuit=false;
		server=args[0];
		channel="";
		Connect();
	}
	else if(caps(command)=="SWITCH"||caps(command)=="JOIN"||caps(command)=="J")
	{
		if(bInChannel)
			link.PartChannel(channel);
		channel=args[0];
		link.JoinChannel(channel);
	}

	if(!bInChannel)
	{
		ConsoleMessage("Not in channel.");
		return super.Parse(command,args,argc,raw_text,raw_args);
	}

	bHandled=true;

	switch(caps(command))
	{
	case "SAY":
		link.SendChannelText(channel,raw_args);
		break;
	case "ME":
		link.SendChannelAction(channel,raw_args);
		break;
	case "MSG":
	case "PRIVMSG":
		if(argc<2)
			CommandBad(command);
		else if(caps(args[0])~=caps(channel))
			link.SendChannelText(channel,right(raw_args,len(raw_args)-InStr(raw_args," ")));
		else
			link.SendPrivateText(args[0],right(raw_args,len(raw_args)-InStr(raw_args," ")));
		break;
	case "QUIT":
		bQuit=true;
		if(argc==0)
			raw_args=link.DisconnectReason;
		link.SendCommandText("QUIT"@raw_args);
		break;
	case "MJOIN":
	case "MULTIJOIN":
		channel=args[0];
		command="JOIN";
		bHandled=false;
		break;
	case "MSWITCH":
	case "MULTISWITCH":
		channel=args[0];
		break;
	case "HOP":
		link.PartChannel(channel);
		link.JoinChannel(channel);
		break;
	/*case "NOTICE":
	case "KILL":
	case "CTCP":
	case "KICK":
	case "MODE":
		link.SendCommandText(command@raw_args);
		break;*/
	default:
		bHandled=false;
	}

	if(!bHandled)
		link.SendCommandText(command@raw_args);

	return true;
}

function Part(string user)
{
	if(user==nick)
		return;
	super.Part(user);
}

function bool AttemptConnect()
{
	link.Connect(Self);
	return true;
}

function bool JoinChannel()
{
	return true;
}

function string GetTopic()
{
	return topic;
}

function string GetTopicUser()
{
	return topic_user;
}

function string GetChannelModes()
{
	return modes;
}

function PromptNick()
{
	ConsoleMessage("Enter your desired nickname:");
	bPromptNick=true;
}

function Init(TextConsole c)
{
	super.init(c);
	link=console.GetPlayerPawn().Spawn(Class'tnmIRCLink');
	PromptNick();
}

function DestroyIRC()
{
	super.DestroyIRC();
	link.DestroyLink();
}

function Connect()
{
	ConsoleMessage("* Connecting to"@server$"...");
	AttemptConnect();
}

function ConnectFailed()
{
	if(bNoRetry)
	{
		ConsoleMessage("* IRC shutting down...");
		return;
	}
	ConsoleMessage("* Attempting to reconnect.");
	Connect();
}

function Disconnected(string reason)
{
	if(bQuit)
	{
		ConsoleMessage("* Disconnected (Reason:"@reason$")");
		ConsoleMessage("* IRC shutting down...");
		return;
	}
	super.Disconnected(reason);
}

function string GetTopicTime()
{
	return topic_time;
}

//ok, so maybe this was a little bit excessive
function SetTopicTime(int t)
{
	local int year;
	local int day;
	local int hour;
	local int minute;
	local int second;

	local int month;
	local int date;
	local int dayofweek;

	local int temp;

	local bool bLeap;
	local bool bDone;

	topic_time="";

	year=t/365.25/24/60/60;
	t=t%(365.25*24*60*60);
	year+=1970;
	bLeap=year%4==0&&(year%100!=0||year%400==0);

	day=t/24/60/60;
	t=t%(24*60*60);
	dayofweek=(4+year+day)%7;
	date=day;
	while(!bDone)
	{
		switch(++month)
		{
		case 1:
		case 3:
		case 5:
		case 7:
		case 8:
		case 10:
		case 12:
			temp=31;
			break;
		case 4:
		case 6:
		case 9:
		case 11:
			temp=30;
			break;
		case 2:
			temp=28+int(bLeap);
			break;
		}

		if(temp-date<0)
			date-=temp;
		else
		{
			date++;
			bDone=true;
		}
	}

	hour=t/60/60;
	t=t%(60*60);
	minute=t/60;
	t=t%60;
	second=t;

	switch(dayofweek)
	{
	case 0:
		topic_time="Sun";
		break;
	case 1:
		topic_time="Mon";
		break;
	case 2:
		topic_time="Tue";
		break;
	case 3:
		topic_time="Wed";
		break;
	case 4:
		topic_time="Thu";
		break;
	case 5:
		topic_time="Fri";
		break;
	case 6:
		topic_time="Sat";
		break;
	}

	switch(month)
	{
	case 1:
		topic_time=topic_time@"Jan";
		break;
	case 2:
		topic_time=topic_time@"Feb";
		break;
	case 3:
		topic_time=topic_time@"Mar";
		break;
	case 4:
		topic_time=topic_time@"Apr";
		break;
	case 5:
		topic_time=topic_time@"May";
		break;
	case 6:
		topic_time=topic_time@"Jun";
		break;
	case 7:
		topic_time=topic_time@"Jul";
		break;
	case 8:
		topic_time=topic_time@"Aug";
		break;
	case 9:
		topic_time=topic_time@"Sep";
		break;
	case 10:
		topic_time=topic_time@"Oct";
		break;
	case 11:
		topic_time=topic_time@"Nov";
		break;
	case 12:
		topic_time=topic_time@"Dec";
		break;
	}

	topic_time=
		topic_time
		@ right("0"$date,2)
		@ right("0"$hour,2)$":"
		$ right("0"$minute,2)$":"
		$ right("0"$second,2);
}

defaultproperties
{
     Server="irc.gamesurge.net"
     Channel="#otp"
     command_prefix="/"
     command_default="say"
     command_list(0)="msg"
     command_list(1)="me"
     command_list(2)="mode"
     command_list(3)="topic"
     command_list(4)="hop"
}
