//=============================================================================
// MenuSelectDifficulty
//=============================================================================

class tnmMenuScreenCustomDifficulty expands MenuUIScreenWindow;

#exec texture IMPORT NAME=MenuCustomDifficulty01 FILE=Textures\MenuCustomDifficulty01.pcx GROUP=UI FLAGS= Mips=off
#exec texture IMPORT NAME=MenuCustomDifficulty02 FILE=Textures\MenuCustomDifficulty02.pcx GROUP=UI FLAGS= Mips=off
#exec texture IMPORT NAME=MenuCustomDifficulty03 FILE=Textures\MenuCustomDifficulty03.pcx GROUP=UI FLAGS= Mips=off
#exec texture IMPORT NAME=MenuCustomDifficultySlider FILE=Textures\MenuCustomDifficultySlider.pcx GROUP=UI FLAGS= Mips=off

var bool bunrealistic; //not sure if there's any point carrying this across, but hey
var float savedDiff;
var float savedPwnHl; //convenience, so people swapping between diff menu and here can keep their custom settings
var int savedEnApp;
var int savedItApp;

var string NPCHealthLevels[4];
var string PCHealthLevels[4];
var string ItemAmtLevels[4];
var string NPCAmtLevels[4];

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();
}

function ProcessAction(String actionKey)
{
	switch(actionKey)
	{
		case "DONE":
			bUnrealistic = false;
			InvokeNewGameScreen(savedDiff, savedPwnHl, savedEnApp, savedItApp);
			break;
	}
}

// ----------------------------------------------------------------------
// InvokeNewGameScreen()
// ----------------------------------------------------------------------

function InvokeNewGameScreen(float difficulty, float pawnHealth, int EnemyAppear, float ItemAppear)
{
	local tnmMenuScreenNewGame newGame;

//	log(difficulty @ pawnHealth @ EnemyAppear @ ItemAppear);

	newGame = tnmMenuScreenNewGame(root.InvokeMenuScreen(Class'tnmMenuScreenNewGame'));

	if (newGame != None)
	{
		newGame.SetDifficulty(difficulty);
		newGame.SetPawnHealth(pawnHealth);
		newgame.SetEnemyAppear(EnemyAppear);
		newGame.SetItemAppear(ItemAppear);
		newgame.bunrealistic = bunrealistic;
	}
}

function SetDifficulty(int newDifficulty)
{
	switch(newDifficulty)
	{
	case 0:
		savedDiff=1.0;
		break;
	case 1:
		savedDiff=1.5;
		break;
	case 2:
		savedDiff=2.0;
		break;
	case 3:
		savedDiff=4.0;
		break;
	}
}

function SetPawnHealth(int NewpawnHealth)
{
	switch(NewPawnHealth)
	{
	case 0:
		SavedPwnHl = 1.33;
		break;
	case 1:
		SavedPwnHl = 1.0;
		break;
	case 2:
		SavedPwnHl = 0.66;
		break;
	case 3:
		SavedPwnHl = 0.5;
		break;
	}
}

function SetEnemyAppear(int NewEnemyAppear)
{
	SavedEnApp = newEnemyAppear;
}

function SetItemAppear(int NewItemAppear)
{
	SavedItApp = newItemAppear;
}
/*
function ToggleNPCHealth()
{
    //gah!  I should just cast to ints and then cast back later, but fuck it
    if(savedPwnHl == 1.33)
        SetPawnHealth(1.0);
    else if(savedPwnHl == 1.0)
        SetPawnHealth(0.66);
    else if(savedPwnHl == 0.66)
        SetPawnHealth(0.5);
    else if(savedPwnHl == 0.5)
        SetPawnHealth(1.33);
    else                   //something went wrong!
        SetPawnHealth(1.0);
}

function ToggleHealth()
{
    if(savedDiff == 1.0)
        SetDifficulty(1.5);
    else if(savedDiff == 1.5)
        SetDifficulty(2.0);
    else if(savedDiff == 2.0)
        SetDifficulty(4.0);
    else if(savedDiff == 4.0)
        SetDifficulty(1.0);
    else
        setdifficulty(1.5);
}

function ToggleItems()
{
    savedItApp++;

    if(SavedItApp > 3)
      SavedItApp = 0;

    setItemAppear(SavedItApp);
}

function TogglePawns()
{
    savedEnApp++;

    if(SavedEnApp > 3)
      SavedEnApp = 0;

    setEnemyAppear(SavedEnApp);
}*/

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     savedDiff=1.500000
     savedPwnHl=1.000000
     savedEnApp=1
     savedItApp=1
     NPCHealthLevels(0)="Push-over"
     NPCHealthLevels(1)="Normal"
     NPCHealthLevels(2)="High"
     NPCHealthLevels(3)="Nigh Immortal"
     PCHealthLevels(0)="Tank"
     PCHealthLevels(1)="Normal"
     PCHealthLevels(2)="Vulnerable"
     PCHealthLevels(3)="Fragile"
     ItemAmtLevels(0)="Abundant"
     ItemAmtLevels(1)="Normal"
     ItemAmtLevels(2)="Sparse"
     ItemAmtLevels(3)="Rare"
     NPCAmtLevels(0)="Understaffed"
     NPCAmtLevels(1)="Normal"
     NPCAmtLevels(2)="Crowded"
     NPCAmtLevels(3)="Horde"
     choices(0)=Class'TNMGUI.DifficultySlider_PCHealth'
     choices(1)=Class'TNMGUI.DifficultySlider_NPCHealth'
     choices(2)=Class'TNMGUI.DifficultySlider_ItemAmt'
     choices(3)=Class'TNMGUI.DifficultySlider_NPCAmt'
     actionButtons(0)=(Align=HALIGN_Right,Action=AB_Cancel)
     actionButtons(1)=(Align=HALIGN_Right,Action=AB_Other,Text="|&Done",Key="DONE")
     actionButtons(2)=(Action=AB_Reset)
     Title="Custom Difficulty Settings"
     ClientWidth=544
     ClientHeight=224
     clientTextures(0)=Texture'TNMGUI.UI.MenuCustomDifficulty01'
     clientTextures(1)=Texture'TNMGUI.UI.MenuCustomDifficulty02'
     clientTextures(2)=Texture'TNMGUI.UI.MenuCustomDifficulty03'
     textureRows=1
}
