class tnmMenuSelectDifficulty expands MenuUIMenuWindow;

#exec TEXTURE IMPORT FILE="Textures\TNMMenuDifficulty01.pcx"	NAME="TNMMenuDifficulty01"	GROUP="UI"
#exec TEXTURE IMPORT FILE="Textures\TNMMenuDifficulty02.pcx"	NAME="TNMMenuDifficulty02"	GROUP="UI"
#exec TEXTURE IMPORT FILE="Textures\TNMMenuDifficulty03.pcx"	NAME="TNMMenuDifficulty03"	GROUP="UI"

var bool bunrealistic;
var float savedDiff;
var float savedPwnHl; //convenience, so people swapping between custom and here can keep their custom settings
var int savedEnApp;
var int savedItApp;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();
}

// ----------------------------------------------------------------------
// WindowReady()
// ----------------------------------------------------------------------

event WindowReady()
{
	// Set focus to the Medium button
	SetFocusWindow(winButtons[1]);
}

function CreateMenuButtons()
{
	local int buttonIndex;

	for(buttonIndex=0; buttonIndex<7; buttonIndex++)
	{
		if (ButtonNames[buttonIndex] != "")
		{
			winButtons[buttonIndex] = MenuUIMenuButtonWindow(winClient.NewChild(Class'MenuUIMenuButtonWindow'));
			winButtons[buttonIndex].SetButtonText(ButtonNames[buttonIndex]);
			winButtons[buttonIndex].SetPos(buttonXPos, buttonDefaults[buttonIndex].y);
			winButtons[buttonIndex].SetWidth(buttonWidth);
		}
		else
		{
			break;
		}
	}

//  winButtons[6] = MenuUIMenuButtonWindow(winClient.NewChild(Class'MenuUIMenuButtonWindow'));
//	winButtons[6].SetButtonText(ButtonNames[6]);
//	winButtons[6].SetPos(buttonXPos, buttonDefaults[6].y);
//	winButtons[6].SetWidth(buttonWidth);

	if (trestkon(player).counteggs() == 16)
	{
		winButtons[6].setSensitivity(true);
	}
	else
	{
		winButtons[6].setSensitivity(false);
	}
}

/*

Mr. Waever's chosen defaults

Easy (PC Dmg=Easy, NPC Health=Medium, Enemies=Easy, Items=Easy)

Normal (PC Dmg=Medium, NPC Health=Medium, Enemies=Medium, Items=Medium)

Hard (PC Dmg=Hard, NPC Health=Medium, Enemies=Hard, Items=Hard)

Realistic (PC Dmg=Realistic, NPC Health=Medium, Enemies=Realistic, Items=Realistic)

*/

// ----------------------------------------------------------------------
// ProcessCustomMenuButton()
// ----------------------------------------------------------------------

function ProcessCustomMenuButton(string key)
{
	switch(key)
	{
		case "EASY":
			bunrealistic = false;
			InvokeNewGameScreen(1.0, 1.33, 0, 0);
			break;

		case "MEDIUM":
			bunrealistic = false;
			InvokeNewGameScreen(1.5, 1.0, 1, 1);
			break;

		case "HARD":
			bunrealistic = false;
			InvokeNewGameScreen(2.0, 1.0, 1, 1);
			break;

		case "REALISTIC":
			bunrealistic = false;
			InvokeNewGameScreen(4.0, 1.0, 2, 2);
			break;

		case "UNREALISTIC":
			bunrealistic = true;
			InvokeNewGameScreen(1.0, 1.0, 0, 1);
			break;

		case "CUSTOM":
			bUnrealistic = false;
			InvokeCustomDifficultyScreen(savedDiff, savedPwnHl, savedEnApp, savedItApp);
			break;
	}
}

// ----------------------------------------------------------------------
// InvokeNewGameScreen()
// ----------------------------------------------------------------------

function InvokeNewGameScreen(float difficulty, float pawnHealth, int EnemyAppear, float ItemAppear)
{
	local tnmMenuScreenNewGame newGame;

	newGame = tnmMenuScreenNewGame(root.InvokeMenuScreen(Class'tnmMenuScreenNewGame'));

	if (newGame != None)
	{
		newGame.SetDifficulty(difficulty);
		newGame.SetPawnHealth(pawnHealth);
		newgame.SetEnemyAppear(EnemyAppear);
		newGame.SetItemAppear(ItemAppear);
		newgame.bunrealistic = bunrealistic;
	}
}

function InvokeCustomDifficultyScreen(float difficulty, float pawnHealth, int EnemyAppear, float ItemAppear)
{
	local tnmMenuScreenCustomDifficulty newDiff;

	newDiff = tnmMenuScreenCustomDifficulty(root.InvokeMenuScreen(Class'tnmMenuScreenCustomDifficulty'));

	if (newDiff != None)
	{
		newDiff.SetDifficulty(difficulty);
		newDiff.SetPawnHealth(pawnHealth);
		newDiff.SetEnemyAppear(EnemyAppear);
		newDiff.SetItemAppear(ItemAppear);
		newDiff.bunrealistic = bunrealistic;
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     savedDiff=1.500000
     savedPwnHl=1.000000
     savedEnApp=1
     savedItApp=1
     ButtonNames(0)="Harmless"
     ButtonNames(1)="Challenging"
     ButtonNames(2)="Painful"
     ButtonNames(3)="Punishing"
     ButtonNames(4)="Custom"
     ButtonNames(5)="Previous Menu"
     ButtonNames(6)="Radish Adventure"
     buttonXPos=7
     buttonWidth=245
     buttonDefaults(0)=(Y=13,Action=MA_Custom,Key="EASY")
     buttonDefaults(1)=(Y=49,Action=MA_Custom,Key="MEDIUM")
     buttonDefaults(2)=(Y=85,Action=MA_Custom,Key="HARD")
     buttonDefaults(3)=(Y=121,Action=MA_Custom,Key="REALISTIC")
     buttonDefaults(4)=(Y=193,Action=MA_Custom,Key="CUSTOM")
     buttonDefaults(5)=(Y=251,Action=MA_Previous)
     buttonDefaults(6)=(Y=157,Action=MA_Custom,Key="UNREALISTIC")
     Title="Select Combat Difficulty"
     ClientWidth=258
     ClientHeight=285
     clientTextures(0)=Texture'TNMGUI.UI.TNMMenuDifficulty01'
     clientTextures(1)=Texture'DeusExUI.UserInterface.MenuDifficultyBackground_2'
     clientTextures(2)=Texture'TNMGUI.UI.TNMMenuDifficulty02'
     clientTextures(3)=Texture'TNMGUI.UI.TNMMenuDifficulty03'
     textureCols=2
}
