class tnmNetworkTerminal extends NetworkTerminal;

var bool bBlackIce;
var bool bNarcissus;

//move CreateHackWindow to SetCompOwner
function SetCompOwner(ElectronicDevices newCompOwner)
{
	super.SetCompOwner(newCompOwner);
	CreateHackWindow();
}

event InitWindow()
{
	Super(DeusExBaseWindow).InitWindow();

	SetWindowAlignments(HALIGN_Full, VALIGN_Full);

	// Draw a black background for now
	SetBackgroundStyle(DSTY_Normal);
	SetBackground(Texture'Solid');
	SetTileColorRGB(0, 0, 0);

	SetMouseFocusMode(MFOCUS_Click);

	root.ShowHUD(False);

	bTickEnabled = True;
}

function CreateHackAccountsWindow()
{
	if ((bHacked) && (winHackAccounts == None) && (Computers(compOwner).NumUsers() > 1))
	{
		// First create the shadow window
		winHackAccountsShadow = ShadowWindow(NewChild(Class'ShadowWindow'));

		winHackAccounts = ComputerScreenHackAccounts(NewChild(Class'tnmComputerScreenHackAccounts'));
		winHackAccounts.SetNetworkTerminal(Self);
		winHackAccounts.SetCompOwner(compOwner);
		winHackAccounts.AskParentForReconfigure();
	}
}

function CreateHackWindow()
{
	local Float hackTime;
	local Float skillLevelValue;
	local Computers comp;
	local int minSkill;
	local int i;

	skillLevelValue = player.SkillSystem.GetSkillLevelValue(class'SkillComputer');
	skillLevel      = player.SkillSystem.GetSkillLevel(class'SkillComputer');
	
	comp = computers(compOwner);
	if(comp!=none)
	{
		minSkill = int(comp.userList[0].accessLevel);
		for(i=0;i<arraycount(comp.userList) && comp.userList[i].userName!="";i++)
		{
			if(minSkill > int(comp.userList[i].accessLevel))
			{
				minSkill = int(comp.userList[i].accessLevel);				
			}
		}
	}
	
	// Check to see if the player is skilled in Hacking before 
	// creating the window
	if ((skillLevel > 0) && (bUsesHackWindow))
	{
		// Base the detection and hack time on the skill level
		hackTime       = detectionTime / (skillLevelValue * 1.5);
		detectionTime *= skillLevelValue;

		// First create the shadow window
		winHackShadow = ShadowWindow(NewChild(Class'ShadowWindow'));

		winHack = ComputerScreenHack(NewChild(Class'tnmComputerScreenHack'));
		winHack.SetNetworkTerminal(Self);
		winHack.SetDetectionTime(detectionTime, hackTime);
		
		if(skillLevel < minSkill)
		{
			tnmComputerScreenHack(winHack).InsufficientSkill();
		}

		bblackice = tnmComputers(player.activecomputer).bblackice;
		tnmComputerScreenHack(winhack).bblackice = bblackice;

		bnarcissus = tnmComputers(player.activecomputer).bNarcissus;
		tnmComputerScreenHack(winhack).bnarcissus = bnarcissus;
		tnmComputerScreenHack(winhack).narcissus_flag = tnmComputers(player.activecomputer).NarcissusFlag;
		bnarcissus = bnarcissus && !player.FlagBase.GetBool(tnmComputerScreenHack(winhack).narcissus_flag);
	}
}

function CloseScreen(String action)
{
	if (action == "EXIT")
	{
		if (winHack!=None && winHack.bHacking)
			if (bBlackIce)
				PM_BlackIce();
			else if (bNarcissus)
				PM_Narcissus();
	}

	Super.CloseScreen(action);
}

function PM_BlackIce()
{
	if (trestkon(player) == None)
		player.StartDataLinkTransmission(trestkon(player).blackiceDL);
}

function PM_Narcissus()
{
	if(player!=None)
		player.StartDataLinkTransmission("PM_Narcissus_FailedHack");
}

function bool AreSpecialOptionsAvailable(optional bool bCheckActivated)
{
	local int i;
	local bool bOK;

	bOK = False;
	for (i=0; i<ArrayCount(Computers(compOwner).specialOptions); i++)
	{
		if (Computers(compOwner).specialOptions[i].Text != "")
		{
			if ((Computers(compOwner).specialOptions[i].userName == "") || (Caps(Computers(compOwner).specialOptions[i].userName) == userName))
			{
				// Also check if the "bCheckActivated" bool is set, in which case we also 
				// want to make sure the item hasn't already been triggered.

				if (!((bCheckActivated) && (Computers(compOwner).specialOptions[i].bAlreadyTriggered)))
				{
					//this is going to be a bitch to debug... -nick
					if(tnmComputers(compOwner)!=None && (
						tnmComputers(compOwner).specialOptionflags[i].bVisibleInactive ||
						tnmComputers(compOwner).specialOptionflags[i].SpecialOptionFlag=='' ||
						Trestkon(GetPlayerPawn()).flagBase.GetBool
						(tnmComputers(compOwner).specialOptionflags[i].SpecialOptionFlag)
						==tnmComputers(compOwner).specialOptionflags[i].bDesiredValue))
					{
						bOK = True;
						break;
					}
				}
			}
		}
	}

	return bOK;
}