class tnmNetworkTerminalAIPuzzle extends tnmNetworkTerminal;

var float staticTime;
var float staticBlinkTime;
var bool bShowStatic;
var bool bStaticBlinking;
var tnmStaticWindow winStatic;

function CloseScreen(String action)
{
	if (action == "STATIC")
		ShowStatic();
	else if (action == "LOGOUT")
		Super.CloseScreen("EXIT");
	else
		Super.CloseScreen(action);
}

function ShowStatic()
{
	local int i;
	if (winComputer != None)
	{
		winComputer.Destroy();
		winComputer = None;
	}

	winStatic = tnmStaticWindow(NewChild(Class'tnmStaticWindow'));
	winStatic.SetWindowAlignments(HALIGN_Full, VALIGN_Full);
	bShowStatic=true;
	staticTime=2.0;
	staticBlinkTime=0.5;
}

function Tick(float deltaTime)
{
	local int i;
	local tnmAIPuzzle comp;
	local Actor act;

	super.Tick(deltaTime);

	if(bShowStatic)
	{
		staticTime-=deltaTime;
		if(staticTime<=0)
		{
			bStaticBlinking=true;
			bShowStatic=false;
			winStatic.SetWindowAlignments(HALIGN_Full, VALIGN_Center);
		}
	}
	if(bStaticBlinking)
	{
		staticBlinkTime-=deltaTime;
		winStatic.SetSize(width, height*staticBlinkTime/0.5);
		if(staticBlinkTime<=0)
		{
			comp=tnmAIPuzzle(compOwner);
			comp.bFinished=true;
			comp.MultiSkins[comp.SolvedTextureMultiSkinIndex]=comp.SolvedTexture;
			foreach comp.AllActors(Class'Actor',act)
				if(bHacked&&act.Tag==comp.SolveEventHacked||!bHacked&&act.Tag==comp.SolveEvent)
					act.Trigger(comp,player);
			winStatic.Destroy();
			bStaticBlinking=false;
			CloseScreen("EXIT");
		}
	}
}

function ComputerHacked()
{
	bHacked = True;

	AIPuzzleWindow(winComputer).puzzleHacked();
}

function HackDetected(optional bool bDamageOnly)
{
	return;
}

defaultproperties
{
     FirstScreen=Class'TNMGUI.AIPuzzleWindow'
     bUsesHackWindow=False
}
