//=============================================================================
// tnmNetworkTerminalPersonal.
//=============================================================================
class tnmNetworkTerminalPersonal extends tnmNetworkTerminal;

function ShowScreen(Class<ComputerUIWindow> newScreen)
{
	local tnmComputerScreenEmail emailScreen;
	// First close any existing screen
	if (winComputer != None)
	{
		winComputer.Destroy();
		winComputer = None;
	}

	// Now invoke the new screen
	if (newScreen != None)
	{
		winComputer = ComputerUIWindow(NewChild(newScreen));
		winComputer.SetWindowAlignments(HALIGN_Center, VALIGN_Center);
		winComputer.SetNetworkTerminal(Self);	
		winComputer.SetCompOwner(compOwner);
		emailScreen = tnmComputerScreenEmail(winComputer);
		if (emailScreen != none)
			emailScreen.AddPrinterButton();
		winComputer.Lower();
	}
}

// ----------------------------------------------------------------------
// CloseScreen()
// ----------------------------------------------------------------------

function CloseScreen(String action)
{
	Super.CloseScreen(action);

	// Based on the action, proceed!
	if (action == "LOGOUT")
	{
		// If we're hacked into the computer, then exit completely.
		if (bHacked)
			CloseScreen("EXIT");
		else
			ShowScreen(FirstScreen);
	}
	else if (action == "LOGIN")
	{
		// Check to see if there are any "special options" the player
		// has not yet invoked, in which case we want to jump straight
		// to the special options screen (oh boy, "special" cases!)
		if (AreSpecialOptionsAvailable(True))
			ShowScreen(Class'tnmComputerScreenSpecialOptions');
		else
			ShowScreen(Class'tnmComputerScreenEmail');
	}
	else if ((action == "EMAIL") || (action == "RETURN"))
	{
		ShowScreen(Class'tnmComputerScreenEmail');
	}
	else if (action == "SPECIAL")
	{
		ShowScreen(Class'tnmComputerScreenSpecialOptions');
	}
	else if (action == "GAMES")
	{
		ShowScreen(Class'tnmComputerScreenGames');
	}
	else if (action == "PONG")
	{
		ShowScreen(Class'PongWindow');
	}
	else if (action == "TETRIS")
	{
		ShowScreen(Class'TetrisWindow');
	}
	else if (action == "BREAKOUT")
	{
		ShowScreen(Class'BreakoutWindow');
	}
	else if (action == "LIGHTSOUT")
	{
		ShowScreen(Class'LightsOutWindow');
	}
	else if (action == "FAKEIRC")
	{
		ShowScreen(Class'tnmFakeIRCWindow');
	}
	else if (action == "TEXTGAME")
	{
		ShowScreen(Class'tnmTextGameWindow');
	}
	else if (action == "REALIRC")
	{
		ShowScreen(Class'tnmIRCWindow');
	}
	else if (action == "DXIGAME")
	{
		ShowScreen(class'dxigWindow');
	}
}

// Uses a custom ComputerScreenLogin class to be able to use custom
// logos and text on the computer login window

defaultproperties
{
     FirstScreen=Class'TNMGUI.tnmComputerScreenLogin'
}
