class tnmNetworkTerminalSecurity extends tnmNetworkTerminal;

function CloseScreen(String action)
{
	Super.CloseScreen(action);

	// Based on the action, proceed!
	if (action == "LOGOUT")
	{
		// If we're hacked into the computer, then exit completely.
		if (bHacked)
			CloseScreen("EXIT");
		else
			ShowScreen(FirstScreen);
	}
	else if (action == "LOGIN")
	{
		// Check to see if there are any "special options" the player
		// has not yet invoked, in which case we want to jump straight
		// to the special options screen (oh boy, "special" cases!)
		if (AreSpecialOptionsAvailable(True))
			ShowScreen(Class'tnmComputerScreenSpecialOptions');
		else
			ShowScreen(Class'tnmComputerScreenSecurity');
	}
	else if (action == "RETURN")
	{
		ShowScreen(Class'tnmComputerScreenSecurity');
	}
	else if (action == "SPECIAL")
	{
		ShowScreen(Class'tnmComputerScreenSpecialOptions');
	}
}

// ----------------------------------------------------------------------
// ComputerHacked()
//
// Computer was hacked, allow user to login
// ----------------------------------------------------------------------

function ComputerHacked()
{
	bHacked = True;

	// Use the first login
	userIndex = 0;
	
	if (compOwner.IsA('Computers'))
		userName  = Computers(compOwner).GetUserName(userIndex);
	
	CloseScreen("LOGIN");
}

// ----------------------------------------------------------------------
// HackDetected()
// ----------------------------------------------------------------------

function HackDetected(optional bool bDamageOnly)
{
	if (compOwner.IsA('Computers'))
	{
		Computers(compOwner).bLockedOut = True;
		Computers(compOwner).lockoutTime = player.Level.TimeSeconds;
	}
	else
	{
		ATM(compOwner).bLockedOut = True;
		ATM(compOwner).lockoutTime = player.Level.TimeSeconds;
	}
 
  	if (Player.Level.NetMode == NM_Standalone && !bNarcissus)
   	{
		player.TakeDamage(200 - 50 * skillLevel, None, vect(0,0,0), vect(0,0,0), 'EMP');	
		PlaySound(sound'ProdFire');
	}
	else
	{
		player.PunishDetection(200 - 50 * skillLevel);
		PlaySound(sound'ProdFire');
	}

	if (!bDamageOnly)
		CloseScreen("EXIT");
}

// Uses a custom ComputerScreenLogin class to be able to use custom
// logos and text on the computer login window

defaultproperties
{
     FirstScreen=Class'TNMGUI.tnmComputerScreenLogin'
}
