class tnmPersonaInventoryInfoWindow extends PersonaInventoryInfoWindow;

var PersonaItemDetailButton btnBare;
var PersonaItemDetailButton btnShock;
var PersonaItemDetailButton btnStun;
var PersonaItemDetailButton btnSpike;

function clientMessage( string inString)
{
	GetRootWindow().ClientMessage(inString);
}

function bool ButtonActivated( Window buttonPressed )
{
	if (buttonPressed == btnbare)
	{
		SelectFistType(0);
	}
	else if (buttonPressed == btnspike)
	{
		SelectFistType(1);
	}
	else if (buttonPressed == btnshock)
	{
		SelectFistType(2);
	}
	else if (buttonPressed == btnstun)
	{
		SelectFistType(3);
	}
}	

function SelectFistType(byte ft)
{
	if (CanSelectFist(ft))
	{
		trestkon(Player).setFistType(ft);
		DisplaySelection(ft);
	}
	DisplayFistSelectionMessage(ft);
}

function DisplaySelection(byte ft)
{
	DeselectAll();
	switch ( ft)
	{
		case 0 : btnBare.GetParent().SetBackground(texture'FistIconBackgroundSelected');
			break;
		case 1: btnSpike.GetParent().SetBackground(texture'FistIconBackgroundSelected');
			break;
		case 2: btnShock.GetParent().SetBackground(texture'FistIconBackgroundSelected');
			break;
		case 3: btnStun.GetParent().SetBackground(texture'FistIconBackgroundSelected');
			break;
	}
}

function bool CanSelectFist(byte ft)
{
	return trestkon(GetPlayerPawn()).CanSelectFist(ft);
}

function DisplayFistSelectionMessage(byte ft)
{
	if (CanSelectFist(ft))
	{
		switch (ft)
		{
			case 0: ClientMessage("No gloves equipped"); break;
			case 1: ClientMessage("Lethal Gloves equipped."); break;
			case 2: ClientMessage("EMP Gloves equipped."); break;
			case 3: ClientMessage("Stun-Gloves equipped."); break;
		}
	}
	else
		ClientMessage("You lack the proper skill level for those gloves.");
}

function DeselectAll()
{
	btnBare.GetParent().SetBackground(texture'FistIconBackground');
	btnShock.GetParent().SetBackground(texture'FistIconBackground');
	btnStun.GetParent().SetBackground(texture'FistIconBackground');
	btnSpike.GetParent().SetBackground(texture'FistIconBackground');
}

function AddFistInfoWindows( bool bHasSpiked, bool bHasShock, bool bHasStun)
{
	AddNormalFist();
	if (bHasSpiked)
		AddSpikeFist();
	if (bHasShock)
		AddShockFist();
	if (bHasstun)
		AddStunFist();
}

function AddNormalFist()
{
	local AlignWindow winAmmo;
	local PersonaNormalTextWindow winText;
	local Window winIcon;

	winAmmo = AlignWindow(winTile.NewChild(Class'AlignWindow'));
	winAmmo.SetChildVAlignment(VALIGN_Top);
	winAmmo.SetChildSpacing(4);

	// Add icon
	winIcon = winAmmo.NewChild(Class'window');
	winIcon.SetBackground(texture'FistIconBackground');
	winIcon.SetBackgroundStyle(DSTY_Masked);
	winIcon.SetSize(41, 41);
	winIcon.SetTileColor(colBackground);
	winIcon.SetBackgroundStyle(backgroundDrawStyle);

	btnBare = PersonaItemDetailButton(winIcon.NewChild(class'PersonaItemDetailButton'));
	btnBare.SetIgnoreCount(True);
	btnBare.SetBackground(texture'FistIconBare');
	btnBare.SetBackgroundStyle(DSTY_Masked);
	btnBare.SetBorderSize(41, 41);
	btnBare.SetSize(41, 41);
	if(!CanSelectFist(0))
		btnBare.SetSensitivity(false);

	// Add description
	winText = PersonaNormalTextWindow(winAmmo.NewChild(Class'PersonaNormalTextWindow'));
	winText.SetWordWrap(True);
	winText.SetTextMargins(0, 0);
	winText.SetTextAlignments(HALIGN_Left, VALIGN_Top);
	winText.SetText("Bare Hands (no prerequisites)|n|n");
	winText.AppendText("Unlike JC Denton, Trestkon is actually capable of fighting with his bare hands. Don't expect to be Bruce Lee without some training, though. Mostly, this is a fallback weapon, but it's also good for showing off if you're too l33t to use actual weapons.");

	AddLine();
}

function AddShockFist()
{
	local AlignWindow winAmmo;
	local PersonaNormalTextWindow winText;
	local Window winIcon;

	winAmmo = AlignWindow(winTile.NewChild(Class'AlignWindow'));
	winAmmo.SetChildVAlignment(VALIGN_Top);
	winAmmo.SetChildSpacing(4);

	// Add icon
	winIcon = winAmmo.NewChild(Class'window');
	winIcon.SetBackground(texture'FistIconBackground');
	winIcon.SetBackgroundStyle(DSTY_Masked);
	winIcon.SetSize(41, 41);
	winIcon.SetTileColor(colBackground);
	winIcon.SetBackgroundStyle(backgroundDrawStyle);

	btnShock = PersonaItemDetailButton(winIcon.NewChild(class'PersonaItemDetailButton'));
	btnShock.SetIgnoreCount(True);
	btnShock.SetBackground(texture'FistIconElectric');
	btnShock.SetBackgroundStyle(DSTY_Masked);
	btnShock.SetBorderSize(41, 41);
	btnShock.SetSize(41, 41);
	if(!CanSelectFist(2))
		btnShock.SetSensitivity(false);

	// Add description
	winText = PersonaNormalTextWindow(winAmmo.NewChild(Class'PersonaNormalTextWindow'));
	winText.SetWordWrap(True);
	winText.SetTextMargins(0, 0);
	winText.SetTextAlignments(HALIGN_Left, VALIGN_Top);
	winText.SetText("EMP Gloves (Advanced)|n");
	if(!CanSelectFist(2))
		winText.AppendText("[NEEDS HIGHER SKILL]");
	winText.AppendText("|nThese gloves, while not providing any additional direct damage to the wearer," @
		"are designed to emit an electromagnetic pulse upon contact with another surface." @
		"They allow the user to easily disrupt robots and augmented individuals but have a short enough" @
		"effective radius to prevent interference with the wearer's augmentations.");

	AddLine();
}

function AddStunFist()
{
	local AlignWindow winAmmo;
	local PersonaNormalTextWindow winText;
	local Window winIcon;

	winAmmo = AlignWindow(winTile.NewChild(Class'AlignWindow'));
	winAmmo.SetChildVAlignment(VALIGN_Top);
	winAmmo.SetChildSpacing(4);

	// Add icon
	winIcon = winAmmo.NewChild(Class'window');
	winIcon.SetBackground(texture'FistIconBackground');
	winIcon.SetBackgroundStyle(DSTY_Masked);
	winIcon.SetSize(41, 41);
	winIcon.SetTileColor(colBackground);
	winIcon.SetBackgroundStyle(backgroundDrawStyle);

	btnStun = PersonaItemDetailButton(winIcon.NewChild(class'PersonaItemDetailButton'));
	btnStun.SetIgnoreCount(True);
	btnStun.SetBackground(texture'FistIconStun');
	btnStun.SetBackgroundStyle(DSTY_Masked);
	btnStun.SetBorderSize(41, 41);
	btnStun.SetSize(41, 41);
	if(!CanSelectFist(3))
		btnStun.SetSensitivity(false);

	// Add description
	winText = PersonaNormalTextWindow(winAmmo.NewChild(Class'PersonaNormalTextWindow'));
	winText.SetWordWrap(True);
	winText.SetTextMargins(0, 0);
	winText.SetTextAlignments(HALIGN_Left, VALIGN_Top);
	winText.SetText("Stun-Gloves (Master)|n");
	if(!CanSelectFist(3))
		winText.AppendText("[NEEDS HIGHER SKILL]");
	winText.AppendText("|nThese gloves emit a jolt on contact with another surface. Though the kinetic damage" @
		"itself is actually lessened by the gloves' padding, the shock can paralyze an adversary with a well" @
		"placed blow to the back of the head. The shock can be potentially fatal when used repeatedly or on" @
		"adversaries who are already wounded.");

	AddLine();
}

function AddSpikeFist()
{
	local AlignWindow winAmmo;
	local PersonaNormalTextWindow winText;
	local Window winIcon;

	winAmmo = AlignWindow(winTile.NewChild(Class'AlignWindow'));
	winAmmo.SetChildVAlignment(VALIGN_Top);
	winAmmo.SetChildSpacing(4);

	// Add icon
	winIcon = winAmmo.NewChild(Class'window');
	winIcon.SetBackground(texture'FistIconBackground');
	winIcon.SetBackgroundStyle(DSTY_Masked);
	winIcon.SetSize(41, 41);
	winIcon.SetTileColor(colBackground);
	winIcon.SetBackgroundStyle(backgroundDrawStyle);

	btnSpike = PersonaItemDetailButton(winIcon.NewChild(class'PersonaItemDetailButton'));
	btnSpike.SetIgnoreCount(True);
	btnSpike.SetBackground(texture'FistIconlethal');
	btnSpike.SetBackgroundStyle(DSTY_Masked);
	btnSpike.SetBorderSize(41, 41);
	btnSpike.SetSize(41, 41);
	if(!CanSelectFist(1))
		btnSpike.SetSensitivity(false);

	// Add description
	winText = PersonaNormalTextWindow(winAmmo.NewChild(Class'PersonaNormalTextWindow'));
	winText.SetWordWrap(True);
	winText.SetTextMargins(0, 0);
	winText.SetTextAlignments(HALIGN_Left, VALIGN_Top);
	winText.SetText("Lethal Gloves (Trained)|n");
	if(!CanSelectFist(1))
		winText.AppendText("[NEEDS HIGHER SKILL]");
	winText.AppendText("|nBesides making you look like a professional mafia hitman, these black leather gloves will imbue your punches with the power to kill a man... with some serious effort.");

	AddLine();
}

defaultproperties
{
}
