//=============================================================================
// PersonaNavBarWindow
//=============================================================================
class tnmPersonaNavBarWindow expands PersonaNavBarWindow;

// ----------------------------------------------------------------------
// ButtonActivated()
// ----------------------------------------------------------------------

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;
	local Class<PersonaScreenBaseWindow> winClass;

	bHandled = True;

	switch(buttonPressed)
	{
		case btnInventory:
			winClass = Class'tnmPersonaScreenInventory';
			break;

		case btnHealth:
			winClass = Class'tnmPersonaScreenHealth';
			break;

		case btnAugs:
			winClass = Class'tnmPersonaScreenAugmentations';
			break;

		case btnSkills:
			winClass = Class'tnmPersonaScreenSkills';
			break;

		case btnGoals:
			winClass = Class'tnmPersonaScreenGoals';
			break;

		case btnCons:
			winClass = Class'tnmPersonaScreenConversations';
			break;

		case btnImages:
			winClass = Class'tnmPersonaScreenImages';
			break;

		case btnLogs:
			winClass = Class'tnmPersonaScreenLogs';
			break;

		default:
			bHandled = False;
			break;
	}

	if (bHandled)
	{
		PersonaScreenBaseWindow(GetParent()).SaveSettings();
		root.InvokeUIScreen(winClass);
		return bHandled;
	}
	else
	{
		return Super.ButtonActivated(buttonPressed);
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
