class tnmPersonaScreenInventory extends PersonaScreenInventory;

var personaitemdetailwindow winfist;
var bool bupdatingfistdisplay;
var string fiststitle;

// ----------------------------------------------------------------------
// CreateInfoWindow()
// ----------------------------------------------------------------------

function CreateInfoWindow()
{
	winInfo = PersonaInventoryInfoWindow(winClient.NewChild(Class'TNMPersonaInventoryInfoWindow'));
	winInfo.SetPos(337, 17);
	winInfo.SetSize(238, 218);
}

// ----------------------------------------------------------------------
// CreateControls()
// ----------------------------------------------------------------------

function CreateControls()
{
	Super.CreateControls();
	winammo.destroy();
	CreateFistwindow();
	Createammowindow();
}

// ----------------------------------------------------------------------
// CreateNanoKeyRingWindow()
// ----------------------------------------------------------------------

function CreateNanoKeyRingWindow()
{
	winNanoKeyRing = PersonaItemDetailWindow(winClient.NewChild(Class'PersonaItemDetailWindow'));
	winNanoKeyRing.SetPos(335, 285);
	winNanoKeyRing.SetWidth(68);
	winNanoKeyRing.winicon.SetWidth(68);
	winNanoKeyRing.SetIcon(Class'NanoKeyRing'.Default.LargeIcon);
	winnanokeyring.winicon.SetBordersize(68,winnanokeyring.winicon.borderheight);
	winNanoKeyRing.SetItem(player.KeyRing);
//	winNanoKeyRing.SetText(NanoKeyRingInfoText);
	winNanoKeyRing.SetTextAlignments(HALIGN_Center, VALIGN_Center);
	winNanoKeyRing.SetCountLabel(NanoKeyRingLabel);
	winNanoKeyRing.SetCount(player.KeyRing.GetKeyCount());
	winNanoKeyRing.SetIconSensitivity(True);
}

// ----------------------------------------------------------------------
// CreateFistWindow()
// ----------------------------------------------------------------------

function CreateFistWindow()
{
	winfist = PersonaItemDetailWindow(winClient.NewChild(Class'PersonaItemDetailWindow'));
	winfist.SetPos(402, 285);
	winfist.SetWidth(55);
	winfist.SetIcon(texture'fisttexture');
	winfist.SetIconSize(Class'AmmoShell'.Default.largeIconWidth + 3, Class'AmmoShell'.Default.largeIconHeight);
	winfist.SetText(NanoKeyRingInfoText);
	winfist.SetTextAlignments(HALIGN_Center, VALIGN_Center);
	winfist.SetIgnoreCount(True);
	winfist.SetIconSensitivity(True);
}

// ----------------------------------------------------------------------
// CreateAmmoWindow()
// ----------------------------------------------------------------------

function CreateAmmoWindow()
{
	winAmmo = PersonaItemDetailWindow(winClient.NewChild(Class'PersonaItemDetailWindow'));
	winAmmo.SetPos(456, 285);
	winAmmo.SetWidth(120);
	winAmmo.SetIcon(Class'AmmoShell'.Default.LargeIcon);
	winAmmo.SetIconSize(Class'AmmoShell'.Default.largeIconWidth, Class'AmmoShell'.Default.largeIconHeight);
	winAmmo.SetText("Click on an an icon to recieve more information");
	winAmmo.SetTextAlignments(HALIGN_Center, VALIGN_Center);
	winAmmo.SetIgnoreCount(True);
	winAmmo.SetIconSensitivity(True);
}


// ----------------------------------------------------------------------
// ButtonActivated()
// ----------------------------------------------------------------------

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;
	local Class<DeusExAmmo> ammoClass;

	bHandled = True;

	// First check to see if this is an Ammo button
	if (buttonPressed.IsA('PersonaAmmoDetailButton'))
	{
		if (DeusExWeapon(selectedItem.GetClientObject()) != None)
		{
			// Before doing anything, check to see if this button is already
			// selected.

			if (!PersonaAmmoDetailButton(buttonPressed).bSelected)
			{
				winInfo.SelectAmmoButton(PersonaAmmoDetailButton(buttonPressed));
				ammoClass = LoadAmmo();
				DeusExWeapon(selectedItem.GetClientObject()).UpdateAmmoInfo(winInfo, ammoClass);
				EnableButtons();
			}
		}
	}
	else if ((buttonPressed.IsA('PersonaItemDetailButton')) && 
	         (PersonaItemDetailButton(buttonPressed).icon == texture'fisttexture'))
	{
		SelectInventory(PersonaItemButton(buttonPressed));
		UpdatefistDisplay();
	}
	// Check to see if this is the Ammo button
	else if ((buttonPressed.IsA('PersonaItemDetailButton')) && 
	         (PersonaItemDetailButton(buttonPressed).icon == Class'AmmoShell'.Default.LargeIcon))
	{
		SelectInventory(PersonaItemButton(buttonPressed));
		UpdateAmmoDisplay();
	}
//SOMETHING FOR DOUBLEGUNS HERE - TODO

	// Now check to see if it's an Inventory button
	else if (buttonPressed.IsA('PersonaItemButton'))
	{
		winStatus.ClearText();
		SelectInventory(PersonaItemButton(buttonPressed));
	}
	// Otherwise must be one of our action buttons
	else
	{
		switch( buttonPressed )
		{
			case btnChangeAmmo:
				WeaponChangeAmmo();
				break;

			case btnEquip:
				EquipSelectedItem();
				break;

			case btnUse:
				UseSelectedItem();
				break;

			case btnDrop:
				DropSelectedItem();
				break;

			default:
				bHandled = False;
				break;
		}
	}

	if ( !bHandled )
		bHandled = Super.ButtonActivated(buttonPressed);

	return bHandled;
}

function EnableButtons()
{
	super.EnableButtons();
	if(selectedItem != none)
		if(selectedItem.GetClientObject().IsA('WeaponNapalmLauncher'))
			btnChangeAmmo.EnableWindow();
}

function CreateNavBarWindow()
{
	winNavBar = PersonaNavBarBaseWindow(NewChild(Class'tnmPersonaNavBarWindow'));
	winNavBar.SetPos(0, 0);
}

function UpdatefistDisplay()
{
	local Inventory inv;
	local DeusExAmmo ammo;
	local int ammoCount;
	local fistinfo playerFistInfo;

	if (!bUpdatingfistDisplay)
	{
		bUpdatingfistDisplay = True;

		winInfo.Clear();

		winInfo.SetTitle(fiststitle);
		winInfo.AddLine();

		playerFistInfo = trestkon(Player).getFistTypes();

		TNMPersonaInventoryInfoWindow(winInfo).addFistInfoWindows(playerfistinfo.bhasSpiked,playerfistinfo.bhasShock,playerfistinfo.bhasStun);

		TNMPersonaInventoryInfoWindow(WinInfo).DisplaySelection(trestkon(Player).GetfistType());

		playerFistInfo.Destroy();

		bUpdatingfistDisplay = False;
	}
}

function Tick(float deltaTime)
{
	RefreshWindow(deltaTime);
}

function CleanBelt()
{
    local Inventory CurrentItem;

    invBelt.hudBelt.ClearBelt();
    invBelt.hudBelt.PopulateBelt();
    invBelt.objBelt.ClearBelt();
    invBelt.objBelt.PopulateBelt();
    if (selectedItem != None)    
        SelectObjectBeltItem(Inventory(selectedItem.GetClientObject()), True);
}

function WeaponChangeAmmo()
{
	local DeusExWeapon aWeapon;

	aWeapon = DeusExWeapon(selectedItem.GetClientObject());

	if ( aWeapon != None )
	{
		aWeapon.CycleAmmo();	

		if(aWeapon.IsA('WeaponNapalmLauncher'))
		{
			winStatus.AddText("Napalm Launcher fire mode switched.");
			return;
		}

		// Send status message and update info window
		winStatus.AddText(Sprintf(AmmoLoadedLabel, aWeapon.ammoType.itemName));
		aWeapon.UpdateAmmoInfo(winInfo, Class<DeusExAmmo>(aWeapon.AmmoName));
		winInfo.SetLoaded(aWeapon.AmmoName);

		// Update the object belt
		invBelt.UpdateBeltText(aWeapon);
	}
}

defaultproperties
{
     bTickEnabled=true
     fiststitle="Fists"
     NanoKeyRingInfoText="Click icon to see a list of Passwords."
     NanoKeyRingLabel="Passwords: %s"
     clientTextures(4)=Texture'TNM.UserInterface.InventoryBackground_5'
     clientTextures(5)=Texture'TNM.UserInterface.InventoryBackground_6'
}
