class tnmStaticWindow expands Window;

var Float lineInterval;
var Float lastLine;
var int currentLinePosY;
var Bool bLinePauseDelay;
var Bool bLineVisible;
var Float linePauseDelay;

event InitWindow()
{
	Super.InitWindow();

	bLineVisible = True;

	Hide();
}

function RandomizeStatic()
{
	lineInterval    = (FRand() / 15);
	linePauseDelay  = (FRand() / 2) + 0.75;
	currentLinePosY = height/2;
}

event DrawWindow(GC gc)
{	
	local int r;
	local int c;

	local int rows;
	local int cols;

	// First draw the static
//	gc.SetStyle(DSTY_Translucent);
	cols=width/128;
	if(width%128!=0)
		cols++;
	rows=height/128;
	if(height%128!=0)
		rows++;
	for(r=0;r<rows;r++)
		for(c=0;c<cols;c++)
			gc.DrawPattern(128*c, 128*r, min(width-128*c,128),  min(height-128*r,128), rand(128), rand(128), Texture'Static');

	// Now draw the line
	if (bLineVisible)
	{
		gc.SetStyle(DSTY_Modulated);
		gc.DrawPattern(0, currentLinePosY, width, 6, 0, 0, Texture'StaticLine');
	}
}

// ----------------------------------------------------------------------
// VisibilityChanged()
// ----------------------------------------------------------------------

event VisibilityChanged(bool bNewVisibility)
{
	bTickEnabled = (bNewVisibility && bLineVisible);
}

// ----------------------------------------------------------------------
// Tick()
//
// Used to update the energy bar
// ----------------------------------------------------------------------

event Tick(float deltaSeconds)
{
	lastLine += deltaSeconds;

	if (bLinePauseDelay)
	{
		if (lastLine > linePauseDelay)
		{
			bLinePauseDelay = False;
			lastLine = 0.0;
		}
	}
	else
	{
		if (lastLine > LineInterval)
		{
			lastLine = 0.0;

			currentLinePosY += 10;

			if (currentLinePosY > Height)
			{
				currentLinePosY = -6;
				bLinePauseDelay = True;
			}
		}
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     lineInterval=0.020000
     currentLinePosY=-6
     bLineVisible=True
     linePauseDelay=1.000000
}
