//=============================================================================
// summonwindow basically copied that otherone
//=============================================================================
class tnmsummonwindow expands ToolWindow;

// Windows 

var string 			list[1200];
var int 			weaponIndex,
				ammoIndex,
				augIndex,
				itemIndex,
				charIndex,
				animalIndex;

var ToolListWindow		lstClasses;
var ToolButtonWindow		btnLoad;    
var ToolButtonWindow		btnCancel;  

var ToolRadioButtonWindow 	radWeapons,
				radAmmunition,
				radAugmentations,
				radItems,
				radCharacters,
				radAnimals,
				curRad;
var int				curOffset;

var ToolEditWindow         	EDITnum;
var string 			filterstring;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	// Center this window	
	SetSize(370, 430);
	SetTitle("Summon Class");

	// Create the controls
	CreateControls();
	PopulateClassList();
}

// ----------------------------------------------------------------------
// DestroyWindow()
// ----------------------------------------------------------------------

event DestroyWindow()
{
}

function string CreateFilterString(string s)
{
	local int i;
	local string ret;
	ret="";
	for(i=0;i<256;i++)
		if(InStr(s,chr(i))==-1)
			ret=ret$chr(i);
	return ret;
}

// ----------------------------------------------------------------------
// CreateControls()
// ----------------------------------------------------------------------

function CreateControls()
{
	// Flags list box
	CreateClassList();
	
	// Buttons
	btnLoad   = CreateToolButton(280, 362, "|&Summon");
	btnCancel = CreateToolButton(280, 387, "|&Close");


	CreateToolLabel(282,344,"Amount:",self);
	editNum = CreateToolEditWindow(323, 340, 32, 32, 18);

	editNum.SetText(1);
	editNum.MoveInsertionPoint(MOVEINSERT_End);
	editNum.SetFilter(CreateFilterString(filterString));

	radWeapons=CreateToolRadioButton(280, 38, "Weapons", true);
	radAugmentations=CreateToolRadioButton(280, 58, "Augs", false);
	radAmmunition=CreateToolRadioButton(280, 78, "Ammo", false);
	radItems=CreateToolRadioButton(280, 98, "Items", false);
	radCharacters=CreateToolRadioButton(280, 118, "Characters", false);
	radAnimals=CreateToolRadioButton(280, 138, "Critters", false);
}

// ----------------------------------------------------------------------
// CreateClassList()
// ----------------------------------------------------------------------

function CreateClassList()
{
	// Now create the List Window
	lstClasses = CreateToolList(15, 38, 255, 372);
	lstClasses.EnableMultiSelect(False);
	lstClasses.EnableAutoExpandColumns(True);
}

// ----------------------------------------------------------------------
// PopulateClassList()
// ----------------------------------------------------------------------

function PopulateClassList()
{

	local int i;
	local string s;

	lstClasses.DeleteAllRows();

	for( i=0; i<arraycount(list); i++)
	{
		if(list[i]=="WEAPONS:")
			weaponIndex=i;
		else if(list[i]=="AMMUNITION:")
			ammoIndex=i;
		else if(list[i]=="AUGMENTATIONS:")
			augIndex=i;
		else if(list[i]=="ITEMS:")
			itemIndex=i;
		else if(list[i]=="CHARACTERS:")
			charIndex=i;
		else if(list[i]=="ANIMALS:")
			animalIndex=i;
	}

	SetListSet("WEAPONS");

	EnableButtons();
}

function SetListSet(string set)
{
	local int i;
	local string s;

	lstClasses.DeleteAllRows();

	switch(set)
	{
	case "WEAPONS":
		for(i=weaponIndex+1;i<ammoIndex;i++)
		{
			s = left(list[i],instr(list[i],":"));
			lstClasses.AddRow( s );
		}
		curOffset=weaponIndex;
		break;
	case "AMMUNITION":
		for(i=ammoIndex+1;i<augIndex;i++)
		{
			s = left(list[i],instr(list[i],":"));
			lstClasses.AddRow( s );
		}
		curOffset=ammoIndex;
		break;
	case "AUGMENTATIONS":
		for(i=augIndex+1;i<itemIndex;i++)
		{
			s = left(list[i],instr(list[i],":"));
			lstClasses.AddRow( s );
		}
		curOffset=augIndex;
		break;
	case "ITEMS":
		for(i=itemIndex+1;i<charIndex;i++)
		{
			s = left(list[i],instr(list[i],":"));
			lstClasses.AddRow( s );
		}
		curOffset=itemIndex;
		break;
	case "CHARACTERS":
		for(i=charIndex+1;i<animalIndex;i++)
		{
			s = left(list[i],instr(list[i],":"));
			lstClasses.AddRow( s );
		}
		curOffset=charIndex;
		break;
	case "ANIMALS":
		for(i=animalIndex+1;i<arraycount(list);i++)
		{
			s = left(list[i],instr(list[i],":"));
			if (s=="")
				break;
			lstClasses.AddRow( s );
		}
		curOffset=animalIndex;
		break;
	}
}

// ----------------------------------------------------------------------
// ButtonActivated()
// ----------------------------------------------------------------------

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;
	local int i1,i2,i3;
	local string s1;
	local string classname;
	local class<actor> newclass;

	bHandled = True;

	switch( buttonPressed )
	{
		case btnLoad:
			i1 = lstClasses.RowIdToIndex(lstClasses.GetSelectedRow())+1+curOffset;
			i2 = len(list[i1]);
			i3 = instr(list[i1],":");
			s1 = right(list[i1], i2 - i3 - 1);

			player.SpawnMass(stringtoname(s1),int(editnum.GetText()));
//			root.popwindow();
			break;

		case btnCancel:
			root.PopWindow();
			break;

		default:
			bHandled = False;
			break;
	}

	if ( !bHandled ) 
		bHandled = Super.ButtonActivated( buttonPressed );

	return bHandled;
}

event bool ToggleChanged(Window button, bool bNewToggle)
{
	local bool bHandled;
	local ToolRadioButtonWindow rad;

	bHandled=true;
	rad=ToolRadioButtonWindow(button);

	switch(rad)
	{
	case curRad:
		if(!bNewToggle)
			rad.SetToggle(true);
		break;
	case radWeapons:
		if(bNewToggle)
		{
			curRad=rad;
			radAmmunition.SetToggle(false);
			radAugmentations.SetToggle(false);
			radItems.SetToggle(false);
			radCharacters.SetToggle(false);
			radAnimals.SetToggle(false);
			SetListSet("WEAPONS");
		}
		break;
	case radAmmunition:
		if(bNewToggle)
		{
			curRad=rad;
			radWeapons.SetToggle(false);
			radAugmentations.SetToggle(false);
			radItems.SetToggle(false);
			radCharacters.SetToggle(false);
			radAnimals.SetToggle(false);
			SetListSet("AMMUNITION");
		}
		break;
	case radAugmentations:
		if(bNewToggle)
		{
			curRad=rad;
			radWeapons.SetToggle(false);
			radAmmunition.SetToggle(false);
			radItems.SetToggle(false);
			radCharacters.SetToggle(false);
			radAnimals.SetToggle(false);
			SetListSet("AUGMENTATIONS");
		}
		break;
	case radItems:
		if(bNewToggle)
		{
			curRad=rad;
			radWeapons.SetToggle(false);
			radAmmunition.SetToggle(false);
			radAugmentations.SetToggle(false);
			radCharacters.SetToggle(false);
			radAnimals.SetToggle(false);
			SetListSet("ITEMS");
		}
		break;
	case radCharacters:
		if(bNewToggle)
		{
			curRad=rad;
			radWeapons.SetToggle(false);
			radAmmunition.SetToggle(false);
			radAugmentations.SetToggle(false);
			radItems.SetToggle(false);
			radAnimals.SetToggle(false);
			SetListSet("CHARACTERS");
		}
		break;
	case radAnimals:
		if(bNewToggle)
		{
			curRad=rad;
			radWeapons.SetToggle(false);
			radAmmunition.SetToggle(false);
			radAugmentations.SetToggle(false);
			radItems.SetToggle(false);
			radCharacters.SetToggle(false);
			SetListSet("ANIMALS");
		}
		break;
	default:
		bHandled=false;
	}
	return bHandled||super.ToggleChanged(button,bNewToggle);
}

// ----------------------------------------------------------------------
// ListSelectionChanged() 
//
// When the user clicks on an item in the list, update the buttons
// appropriately
// ----------------------------------------------------------------------

event bool ListSelectionChanged(window list, int numSelections, int focusRowId)
{
	EnableButtons();

	return true;
}

// ----------------------------------------------------------------------
// ListRowActivated()
// ----------------------------------------------------------------------

event bool ListRowActivated(window list, int rowId)
{
//this was returning true and loading the map. will have to change back if dodgy
	return false;
}

// ----------------------------------------------------------------------
// EnableButtons()
//
// Checks the state of the list control and updates the pushbuttons
// appropriately
// ----------------------------------------------------------------------

function EnableButtons()
{
	btnLoad.SetSensitivity( lstClasses.GetNumSelectedRows() > 0 );

	SetFocusWindow(lstClasses);
}

function ToolRadioButtonWindow CreateToolRadioButton(int posX, int posY, String label, bool bDefaultValue)
{
	local ToolRadioButtonWindow newRadio;

	newRadio = ToolRadioButtonWindow(winContainer.NewChild(Class'ToolRadioButtonWindow'));
	newRadio.SetPos(posX, posY);
	newRadio.SetText(label);
	newRadio.SetToggle(bDefaultValue);

	return newRadio;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     List(0)="WEAPONS:"
     List(1)="Assault Rifle:WeaponTNMAssaultGun"
     List(2)="Assault Shotgun:WeaponTNMAssaultShotgun"
     List(3)="Baton:WeaponTNMBaton"
     List(4)="Blow Pipe:WeaponBlowPipe"
     List(5)="Combat Knife:WeaponTNMCombatKnife"
     List(6)="Crowbar:WeaponTNMCrowbar"
     List(7)="Daikatana:WeaponDaikatana"
     List(8)="Dragons Tooth Sword:WeaponTNMNanoSword"
     List(9)="EMP Grenade:WeaponTNMEMPGrenade"
     List(10)="PHAT-Rifle:WeaponFatRifle"
     List(11)="Fire Blade:WeaponFireBlade"
     List(12)="Firestaff:WeaponFireStaff"
     List(13)="Flamethrower:WeaponTNMFlamethrower"
     List(14)="Foon:WeaponFoon"
     List(15)="Gas Grenade:WeaponTNMGasGrenade"
     List(16)="GEP Gun:WeaponTNMGEPGun"
     List(17)="Gibinator:WeaponGibinator"
     List(18)="Golden Spork:WeaponSporkGolden"
     List(19)="Hammer:WeaponHammer"
     List(20)="Katana (Default):WeaponKatana"
     List(21)="Katana (Digital Ronin):WeaponKatanaRonin"
     List(22)="Katana (Slicer):WeaponKatanaSlicer"
     List(23)="LAM:WeaponTNMLAM"
     List(24)="LAW:WeaponTNMLAW"
     List(25)="Laser Pistol:WeaponLaser"
     List(26)="Mine:WeaponMine"
     List(27)="Mini Crossbow:WeaponTNMMiniCrossbow"
     List(28)="Molotov Cocktail:WeaponMolBottle"
     List(29)="Napalm Launcher:WeaponNapalmLauncher"
     List(30)="Pepper Gun:WeaponTNMPepperGun"
     List(31)="Pistol:WeaponTNMPistol"
     List(32)="Plasma Rifle:WeaponTNMPlasmarifle"
     List(33)="PS20:WeaponTNMHideAGun"
     List(34)="Pumpgun:WeaponShotgun"
     List(35)="Quad Launcher:WeaponQdRocket"
     List(36)="Riot Prod:WeaponTNMProd"
     List(37)="Sawed-Off Shotgun:WeaponTNMSawedOffShotgun"
     List(38)="Scrambler Grenade:WeaponTNMNanoVirusGrenade"
     List(39)="Screw Driver:WeaponScrewDriver"
     List(40)="Sniper Rifle:WeaponTNMRifle"
     List(41)="Spork:WeaponSpork"
     List(42)="Stealth Pistol:WeaponTNMStealthPistol"
     List(43)="Stun-Gloves:WeaponFists"
     List(44)="Sword:WeaponTNMSword"
     List(45)="Throwing Foons:WeaponThrowFoon"
     List(46)="Throwing Knives:WeaponTNMShuriken"
     List(47)="Throwing Sporks:WeaponThrowSpork"
     List(48)="Trestkons Pistols:WeaponDoubleGuns"
     List(49)="Trip Bomb:WeaponTripBomb"
     List(50)="Vortex Grenade:WeaponPlasmanade"
     List(51)="Wrench:WeaponWrench"
     List(52)="AMMUNITION:"
     List(53)="45 caliber:Ammo45"
     List(54)="10 mm:Ammo10mm"
     List(55)="20 mm:Ammo20mm"
     List(56)="30.06 mm:Ammo3006"
     List(57)="7.62 mm:Ammo762mm"
     List(58)="Blow Darts:AmmoBlowDart"
     List(59)="Dart (Regular):AmmoDart"
     List(60)="Dart (Flare):AmmoDartFlare"
     List(61)="Dart (Tranq):AmmoDartPoison"
     List(62)="Gibinator Battery:AmmoGibBattery"
     List(63)="Laser Battery:AmmoLaserBattery"
     List(64)="Mana Potion:AmmoManaPotion"
     List(65)="Napalm (FlameThrower):AmmoTNMNapalm"
     List(66)="Napalm (Napalm Launcher):AmmoNapalmL"
     List(67)="Pepper Cartridge:AmmoPepper"
     List(68)="PHAT-ray Canister:AmmoFatRifle"
     List(69)="Plasma Clip:AmmoPlasma"
     List(70)="Quad Rockets:AmmoQdRocket"
     List(71)="Rice Bags:AmmoRicebag"
     List(72)="Riot Prod Battery:AmmoBattery"
     List(73)="Rockets (EMP):AmmoEMPRocket"
     List(74)="Rockets (Regular):AmmoRocket"
     List(75)="Rockets (WP):AmmoRocketWP"
     List(76)="Shells (Regular):AmmoShell"
     List(77)="Shells (Sabot):AmmoSabot"
     List(78)="Spider Canister:AmmoSpiderCannister"
     List(79)="AUGMENTATIONS:"
     List(80)="Aqualung/Environmental:AugCannisterALER"
     List(81)="Ballistic/EMP Shield:AugCannisterBPES"
     List(82)="Cloak/Radar Transparency:AugCannisterCRT"
     List(83)="Regeneration/Energy Shield:AugCannisterHS"
     List(84)="Muscle/Combat Strength:AugCannisterMC"
     List(85)="ADS/Spy Drone:AugCannisterSDAD"
     List(86)="Synth Heart/Power:AugCannisterSHPR"
     List(87)="Speed/Run Silent:AugCannisterSS"
     List(88)="Targetting/Vision:AugCannisterTV"
     List(89)="ITEMS:"
     List(90)="Ambrosia Vial:VialAmbrosia"
     List(91)="Aug Upgrade Canister:AugmentationUpgradeCannister"
     List(92)="Ballistic Armor:BallisticArmor"
     List(93)="Binoculars:Binoculars"
     List(94)="Biocell (Blue):BioelectricCell"
     List(95)="Biocell (Red):RedBiocell"
     List(96)="Candybar:Candybar"
     List(97)="Chemical Bottle:ChemicalBottle"
     List(98)="Cigarettes:Cigarettes"
     List(99)="Coffee:PlasticCoffee"
     List(100)="Credits (100):Credits"
     List(101)="Crystal Melk:TNMVialCrack"
     List(102)="Dog Blood:DogBlood"
     List(103)="Fire Extinguisher:WeaponFireExting"
     List(104)="Flare:Flare"
     List(105)="Floppy Disk (Hentai):FloppyDisk"
     List(106)="Floppy Disk (Virus):VirusDisk"
     List(107)="Forty:Liquor40oz"
     List(108)="Gloves (Lethal):FistPickupLethal"
     List(109)="Gloves (Shocking):FistPickupShock"
     List(110)="Gloves (Stunning):FistPickupStun"
     List(111)="Hazmat Suit:HazMatSuit"
     List(112)="Karkian Snot:KarkianSnot"
     List(113)="Liquor Bottle:LiquorBottle"
     List(114)="Lockpick:Lockpick"
     List(115)="Medkit:MedKit"
     List(116)="Multitool:Multitool"
     List(117)="Nosferatus Teeth:NosferatusTeeth"
     List(118)="Painting Tube:PaintingTube"
     List(119)="Poster Tube:PosterTube"
     List(120)="Rebreather:Rebreather"
     List(121)="Sodacan:Sodacan"
     List(122)="Soy Food:SoyFood"
     List(123)="Spyware Device:WeaponBlackBox"
     List(124)="Tech Goggles:TechGoggles"
     List(125)="Thermoptic Camo:AdaptiveArmor"
     List(126)="Uranium Stick:UraniumStick"
     List(127)="Weapon Mod (Accuracy):WeaponModAccuracy"
     List(128)="Weapon Mod (Clip Size):WeaponModClip"
     List(129)="Weapon Mod (Laser):WeaponModLaser"
     List(130)="Weapon Mod (Range):WeaponModRange"
     List(131)="Weapon Mod (Recoil):WeaponModRecoil"
     List(132)="Weapon Mod (Reload):WeaponModReload"
     List(133)="Weapon Mod (Scope):WeaponModScope"
     List(134)="Weapon Mod (Silencer):WeaponModSilencer"
     List(135)="Wine Bottle:Winebottle"
     List(136)="CHARACTERS:"
     List(137)="ABI Commando:ABICommando"
     List(138)="ABI Elite Guard:ABIEliteGuard"
     List(139)="ABI Security Guard:ABISecurityGuard"
     List(140)="Abomination:Abomnation"
     List(141)="Aemer:Aemer"
     List(142)="AJ:AJ"
     List(143)="Alien:Alien"
     List(144)="Alpha Operator:AlphaOperator"
     List(145)="Andreus:Andreus"
     List(146)="Arny:Arny"
     List(147)="Athanatos:Athanatos"
     List(148)="Athena:Athena"
     List(149)="AT Jazz:Jazz"
     List(150)="Beeblequix:Beeblequix"
     List(151)="Beefman:Beefman"
     List(152)="Board Guest 1:BoardGuest1"
     List(153)="Board Guest 2:BoardGuest2"
     List(154)="Breadfan:Breadfan"
     List(155)="Cerulean Security Guard:CeruleanGuard"
     List(156)="Chris the Cynic:Chris"
     List(157)="Compudoc:Compudoc"
     List(158)="Dark Templar:DarkTemplar"
     List(159)="Dazza:Dazza"
     List(160)="Deus Diablo:DD"
     List(161)="Despot:Despot"
     List(162)="DP:DP"
     List(163)="Dreamcast:Dreamcast"
     List(164)="Test Dummy:Dummy"
     List(165)="Endar:Endar"
     List(166)="Evil Invasion:EvilInvasion"
     List(167)="Fender2k1:Fender2k1"
     List(168)="Firewall Agent:FireWall"
     List(169)="Firewall Officer:FireWall2"
     List(170)="Ghandaiah:Ghand"
     List(171)="Glottis:Glottis"
     List(172)="Goat 1:Goat1"
     List(173)="Goat 2:Goat2"
     List(174)="Goat 3:Goat3"
     List(175)="Goat Female:GoatFemale"
     List(176)="Goat Templar 1:GoatTemplar1"
     List(177)="Goat Templar 2:GoatTemplar2"
     List(178)="Goat Templar 3:GoatTemplar3"
     List(179)="Grub:Grub"
     List(180)="Gwog:Gwog"
     List(181)="Hao Niu-rou:Hao"
     List(182)="Hobbes:Hobbes"
     List(183)="Hoverbot:Hoverbot"
     List(184)="Illuminati IIS:Illuminati"
     List(185)="Jackie:Jackie"
     List(186)="Jaysee:Jaysee"
     List(187)="jimmycracker:jimmycracker"
     List(188)="Jonas Waever:Jonas"
     List(189)="Kevo-sama:Kevo"
     List(190)="King Kashue:KingKashue"
     List(191)="Krissy:Krissy"
     List(192)="Kunio Kun:KunioKun"
     List(193)="Kylie Griffin:Kylie"
     List(194)="Leviathan:Leviathan"
     List(195)="Llama 1:Llama1"
     List(196)="Llama 2:Llama2"
     List(197)="Llama 3:Llama3"
     List(198)="LlamaFemale:LlamaFemale"
     List(199)="Lo Vaquero:LoVaquero"
     List(200)="MadMax:MadMax"
     List(201)="Man In Black:ManInBlack"
     List(202)="Master_Kale:Master_Kale"
     List(203)="Mercedes:Mercedes"
     List(204)="Midashand:Midashand"
     List(205)="Military Bot (ABI):MilitaryBotABI"
     List(206)="Military Bot (GS):MilitaryBotGS"
     List(207)="Military Bot (PDX):MilitaryBotPDX"
     List(208)="Military Bot (WC):MilitaryBotWC"
     List(209)="Mole:Mole"
     List(210)="Nice-But-Dim:NBDRat"
     List(211)="Nosferatu:Nosferatu"
     List(212)="OiNutter:OiNutter"
     List(213)="Phasmatis:Phasmatis"
     List(214)="PimpJojo:PimpJojo"
     List(215)="Raving Nutter:RavingNutter"
     List(216)="Red Greasel:RedGreasel"
     List(217)="Ricemanu:Ricemanu"
     List(218)="Ryan:Ryan"
     List(219)="Ryan Hitman 1:RyanHitman1"
     List(220)="Ryan Hitman 2:RyanHitman2"
     List(221)="Scara B. King:ScaraKing"
     List(222)="Silver Dragon:SD"
     List(223)="Security Bot 2 (ABI):SecurityBot2ABI"
     List(224)="Security Bot 2 (PDX):SecurityBot2PDX"
     List(225)="Security Bot 2 (WC):SecurityBot2WC"
     List(226)="Security Bot 3 (WC):SecurityBot3WC"
     List(227)="Slicer:Slicer"
     List(228)="Snow Wolf:SnowWolf"
     List(229)="Steve Tack:SteveTack"
     List(230)="SymGeosis:SymGeosis"
     List(231)="That Guy:ThatGuy"
     List(232)="The Fury:Fury"
     List(233)="Treskton:Treskton"
     List(234)="TheRenegadeMaster:TRM"
     List(235)="Vavrek:Vavrek"
     List(236)="walton simons:Walton"
     List(237)="WC Commando:WCCommando"
     List(238)="WCID Agent:WCIDAgent"
     List(239)="WC Security Guard:WCSecurity"
     List(240)="WC Thug:WCThug"
     List(241)="Winquman:Winquman"
     List(242)="Wolfy:Wolfy"
     List(243)="Yardbomb:Yardbomb"
     List(244)="ZeroPresence:ZeroPresence"
     List(245)="ANIMALS:"
     List(246)="Cat:TNMCat"
     List(247)="Doberman:TNMDoberman"
     List(248)="Dog:TNMMutt"
     List(249)="Fish 1:Fish"
     List(250)="Fish 2:Fish2"
     List(251)="Fly:Fly"
     List(252)="Gray:Gray"
     List(253)="Greasel:TNMGreasel"
     List(254)="Karkian:TNMKarkian"
     List(255)="Karkian Baby:TNMKarkianBaby"
     List(256)="Pigeon:Pigeon"
     List(257)="Rat:TNMRat"
     List(258)="Seagull:Seagull"
     filterString="0123456789"
}
