class tnmTextGameWindow extends ComputerUIWindow;

#exec TEXTURE IMPORT NAME=TNTABackground01 FILE=Textures\TNTABackground01.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2
#exec TEXTURE IMPORT NAME=TNTABackground02 FILE=Textures\TNTABackground02.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2
#exec TEXTURE IMPORT NAME=TNTABackground03 FILE=Textures\TNTABackground03.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2
#exec TEXTURE IMPORT NAME=TNTABackground04 FILE=Textures\TNTABackground04.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2
#exec TEXTURE IMPORT NAME=TNTABackground05 FILE=Textures\TNTABackground05.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2
#exec TEXTURE IMPORT NAME=TNTABackground06 FILE=Textures\TNTABackground06.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2

var TextConsole console;

var MenuUIActionButtonWindow 	btnLogout;
var MenuUIActionButtonWindow 	btnReturn;

function CreateControls()
{
	super.CreateControls();

	btnReturn=winButtonBar.AddButton("|&Return", HALIGN_Right);
	btnLogout=winButtonBar.AddButton("|&Logout", HALIGN_Right);

//	btnReturn.SetSelectability(false);
//	btnLogout.SetSelectability(false);

	console=TextConsole(winClient.NewChild(Class'TextConsole'));
	console.Init(Class'TextBasedGameInterface');
//	console.Init(Class'consoleinterfacetest');
}

function bool ButtonActivated( Window buttonPressed )
{
	if(buttonPressed == btnLogout)
	{
		CloseScreen("LOGOUT");
		return true;
	}

	if(buttonPressed == btnReturn)
	{
		CloseScreen("RETURN");
		return true;
	}

	return super.ButtonActivated(buttonPressed);
}

event InitWindow()
{
	Super.InitWindow();
	bTickEnabled=true;
}

function Tick(float deltaTime)
{
	Trestkon(GetPlayerPawn()).AddGameTimePlayed("TEXT",deltaTime);
}

defaultproperties
{
     escapeAction="RETURN"
     Title="The Nameless Text Adventure"
     ClientWidth=600
     ClientHeight=400
     clientTextures(0)=Texture'TNMGUI.UI.TNTABackground01'
     clientTextures(1)=Texture'TNMGUI.UI.TNTABackground02'
     clientTextures(2)=Texture'TNMGUI.UI.TNTABackground03'
     clientTextures(3)=Texture'TNMGUI.UI.TNTABackground04'
     clientTextures(4)=Texture'TNMGUI.UI.TNTABackground05'
     clientTextures(5)=Texture'TNMGUI.UI.TNTABackground06'
     textureRows=2
     textureCols=3
     bUsesStatusWindow=False
     ComputerNodeFunctionLabel="TextGame"
}
